/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.debug;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.base.common.NetworkNode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.core.WorkingMemory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.kiesession.debug.AccumulateNodeVisitor;
import org.drools.kiesession.debug.AlphaNodeVisitor;
import org.drools.kiesession.debug.BetaNodeVisitor;
import org.drools.kiesession.debug.BetaRightAdapterNodeVisitor;
import org.drools.kiesession.debug.DefaultNetworkNodeVisitor;
import org.drools.kiesession.debug.EvalConditionNodeVisitor;
import org.drools.kiesession.debug.FromNodeVisitor;
import org.drools.kiesession.debug.LeftInputAdapterNodeVisitor;
import org.drools.kiesession.debug.NetworkNodeVisitor;
import org.drools.kiesession.debug.ObjectTypeNodeVisitor;
import org.drools.kiesession.debug.QueryTerminalNodeVisitor;
import org.drools.kiesession.debug.RightInputAdapterNodeVisitor;
import org.drools.kiesession.debug.RuleTerminalNodeVisitor;
import org.drools.kiesession.debug.StatefulKnowledgeSessionInfo;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;

public class SessionInspector {
    private StatefulKnowledgeSessionImpl session;
    private Map<Integer, NetworkNodeVisitor> visitors = new HashMap<Integer, NetworkNodeVisitor>();

    public SessionInspector(KieSession session) {
        this.visitors.put(5900720, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put(6228400, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put(3932169, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(3276809, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(4259849, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put(4587529, AlphaNodeVisitor.INSTANCE);
        this.visitors.put(5245233, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5309448, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5374984, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5440520, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5506056, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(10816052, BetaNodeVisitor.INSTANCE);
        this.visitors.put(10488372, BetaNodeVisitor.INSTANCE);
        this.visitors.put(11471412, BetaNodeVisitor.INSTANCE);
        this.visitors.put(11143732, BetaNodeVisitor.INSTANCE);
        this.visitors.put(11799092, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put(7538740, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put(8849460, FromNodeVisitor.INSTANCE);
        this.visitors.put(6883436, LeftInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put(7211116, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = (StatefulKnowledgeSessionImpl)session;
    }

    public SessionInspector(WorkingMemory session) {
        this.visitors.put(5900720, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put(6228400, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put(3932169, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(3276809, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(4259849, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put(4587529, AlphaNodeVisitor.INSTANCE);
        this.visitors.put(5245233, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5309448, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5374984, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5440520, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(5506056, BetaRightAdapterNodeVisitor.INSTANCE);
        this.visitors.put(10816052, BetaNodeVisitor.INSTANCE);
        this.visitors.put(10488372, BetaNodeVisitor.INSTANCE);
        this.visitors.put(11471412, BetaNodeVisitor.INSTANCE);
        this.visitors.put(11143732, BetaNodeVisitor.INSTANCE);
        this.visitors.put(11799092, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put(7538740, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put(8849460, FromNodeVisitor.INSTANCE);
        this.visitors.put(6883436, LeftInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put(7211116, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = (StatefulKnowledgeSessionImpl)session;
    }

    public StatefulKnowledgeSessionInfo getSessionInfo() {
        StatefulKnowledgeSessionInfo info = new StatefulKnowledgeSessionInfo();
        info.setSession(this.session);
        ArrayDeque<NetworkNode> nodeList = new ArrayDeque<NetworkNode>();
        this.gatherNodeInfo((NetworkNode)this.session.getKnowledgeBase().getRete(), nodeList, info);
        return info;
    }

    private void gatherNodeInfo(NetworkNode parent, Deque<NetworkNode> nodeList, StatefulKnowledgeSessionInfo info) {
        if (!info.visited(parent)) {
            nodeList.push(parent);
            NetworkNodeVisitor visitor = this.visitors.get(parent.getType());
            if (visitor == null) {
                throw new RuntimeException("No visitor found for node class: " + parent.getClass() + " node: " + parent);
            }
            visitor.visit(parent, nodeList, info);
            this.visitChildren(parent, nodeList, info);
            nodeList.pop();
        } else {
            Set<RuleImpl> rules = info.getNodeInfo(parent).getRules();
            for (NetworkNode snode : nodeList) {
                for (RuleImpl rule : rules) {
                    info.assign(snode, rule);
                }
            }
        }
    }

    protected void visitChildren(NetworkNode parent, Deque<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        if (parent instanceof Rete) {
            Rete rete = (Rete)parent;
            for (EntryPointNode sink : rete.getEntryPointNodes().values()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (parent instanceof EntryPointNode) {
            EntryPointNode epn = (EntryPointNode)parent;
            for (ObjectTypeNode sink : epn.getObjectTypeNodes().values()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (parent instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)parent;
            for (ObjectSink sink : source.getObjectSinkPropagator().getSinks()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (parent instanceof LeftTupleSource) {
            LeftTupleSource source = (LeftTupleSource)parent;
            for (LeftTupleSink sink : source.getSinkPropagator().getSinks()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (!(parent instanceof RightInputAdapterNode || parent instanceof RuleTerminalNode || parent instanceof QueryTerminalNode)) {
            throw new RuntimeException("ERROR: No idea how to visit childrens of this node: " + parent);
        }
    }
}

