/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.util.Objects;

public interface GeneratedFileType {
    public static final GeneratedFileType SOURCE = GeneratedFileType.of(Category.SOURCE);
    public static final GeneratedFileType INTERNAL_RESOURCE = GeneratedFileType.of(Category.INTERNAL_RESOURCE);
    public static final GeneratedFileType STATIC_HTTP_RESOURCE = GeneratedFileType.of(Category.STATIC_HTTP_RESOURCE);
    public static final GeneratedFileType COMPILED_CLASS = GeneratedFileType.of(Category.COMPILED_CLASS);
    public static final GeneratedFileType RULE = GeneratedFileType.of("RULE", Category.SOURCE);
    public static final GeneratedFileType CONFIG = GeneratedFileType.of("CONFIG", Category.SOURCE);
    public static final GeneratedFileType DECLARED_TYPE = GeneratedFileType.of("DECLARED_TYPE", Category.SOURCE);
    public static final GeneratedFileType REST = GeneratedFileType.of("REST", Category.SOURCE, true, true);

    public String name();

    public Category category();

    public boolean canHotReload();

    public boolean isCustomizable();

    public static GeneratedFileType of(Category category) {
        Objects.requireNonNull(category, "category cannot be null");
        return GeneratedFileType.of(category.name(), category);
    }

    public static GeneratedFileType of(String name, Category category) {
        return GeneratedFileType.of(name, category, true);
    }

    public static GeneratedFileType of(String name, Category category, boolean canHotReload) {
        return new StaticGeneratedFileType(name, category, canHotReload, false);
    }

    public static GeneratedFileType of(String name, Category category, boolean canHotReload, boolean customizable) {
        return new StaticGeneratedFileType(name, category, canHotReload, customizable);
    }

    public static enum Category {
        SOURCE,
        INTERNAL_RESOURCE,
        STATIC_HTTP_RESOURCE,
        COMPILED_CLASS;

    }

    public static class StaticGeneratedFileType
    implements GeneratedFileType {
        private final String name;
        private final Category category;
        private final boolean canHotReload;
        private final boolean customizable;

        private StaticGeneratedFileType(String name, Category category, boolean canHotReload, boolean customizable) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(category, "category cannot be null");
            this.customizable = customizable;
            this.name = name;
            this.category = category;
            this.canHotReload = canHotReload;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean canHotReload() {
            return this.canHotReload;
        }

        @Override
        public boolean isCustomizable() {
            return this.customizable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeneratedFileType)) {
                return false;
            }
            GeneratedFileType that = (GeneratedFileType)o;
            return this.canHotReload == that.canHotReload() && this.name.equals(that.name()) && this.category == that.category() && this.customizable == that.isCustomizable();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.category, this.canHotReload, this.customizable});
        }

        public String toString() {
            return "GeneratedFileType{name='" + this.name + "', category=" + this.category + ", canHotReload=" + this.canHotReload + "}";
        }
    }
}

