/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import java.math.BigDecimal;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import org.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.util.ArrowUtils;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

@DeveloperApi
public class ArrowColumnVector
extends ColumnVector {
    ArrowVectorAccessor accessor;
    ArrowColumnVector[] childColumns;

    public ValueVector getValueVector() {
        return this.accessor.vector;
    }

    @Override
    public boolean hasNull() {
        return this.accessor.getNullCount() > 0;
    }

    @Override
    public int numNulls() {
        return this.accessor.getNullCount();
    }

    @Override
    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
            this.childColumns = null;
        }
        this.accessor.close();
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.accessor.isNullAt(rowId);
    }

    @Override
    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    @Override
    public byte getByte(int rowId) {
        return this.accessor.getByte(rowId);
    }

    @Override
    public short getShort(int rowId) {
        return this.accessor.getShort(rowId);
    }

    @Override
    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    @Override
    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    @Override
    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    @Override
    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    @Override
    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getDecimal(rowId, precision, scale);
    }

    @Override
    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getUTF8String(rowId);
    }

    @Override
    public CalendarInterval getInterval(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getInterval(rowId);
    }

    @Override
    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    @Override
    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getArray(rowId);
    }

    @Override
    public ColumnarMap getMap(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getMap(rowId);
    }

    @Override
    public ArrowColumnVector getChild(int ordinal) {
        return this.childColumns[ordinal];
    }

    ArrowColumnVector(DataType type) {
        super(type);
    }

    public ArrowColumnVector(ValueVector vector) {
        this(ArrowUtils.fromArrowField((Field)vector.getField()));
        this.initAccessor(vector);
    }

    void initAccessor(ValueVector vector) {
        if (vector instanceof BitVector) {
            this.accessor = new BooleanAccessor((BitVector)vector);
        } else if (vector instanceof TinyIntVector) {
            this.accessor = new ByteAccessor((TinyIntVector)vector);
        } else if (vector instanceof SmallIntVector) {
            this.accessor = new ShortAccessor((SmallIntVector)vector);
        } else if (vector instanceof IntVector) {
            this.accessor = new IntAccessor((IntVector)vector);
        } else if (vector instanceof BigIntVector) {
            this.accessor = new LongAccessor((BigIntVector)vector);
        } else if (vector instanceof Float4Vector) {
            this.accessor = new FloatAccessor((Float4Vector)vector);
        } else if (vector instanceof Float8Vector) {
            this.accessor = new DoubleAccessor((Float8Vector)vector);
        } else if (vector instanceof DecimalVector) {
            this.accessor = new DecimalAccessor((DecimalVector)vector);
        } else if (vector instanceof VarCharVector) {
            this.accessor = new StringAccessor((VarCharVector)vector);
        } else if (vector instanceof LargeVarCharVector) {
            this.accessor = new LargeStringAccessor((LargeVarCharVector)vector);
        } else if (vector instanceof VarBinaryVector) {
            this.accessor = new BinaryAccessor((VarBinaryVector)vector);
        } else if (vector instanceof LargeVarBinaryVector) {
            this.accessor = new LargeBinaryAccessor((LargeVarBinaryVector)vector);
        } else if (vector instanceof DateDayVector) {
            this.accessor = new DateAccessor((DateDayVector)vector);
        } else if (vector instanceof TimeStampMicroTZVector) {
            this.accessor = new TimestampAccessor((TimeStampMicroTZVector)vector);
        } else if (vector instanceof TimeStampMicroVector) {
            this.accessor = new TimestampNTZAccessor((TimeStampMicroVector)vector);
        } else if (vector instanceof MapVector) {
            MapVector mapVector = (MapVector)vector;
            this.accessor = new MapAccessor(mapVector);
        } else if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            this.accessor = new ArrayAccessor(listVector);
        } else if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            this.accessor = new StructAccessor(structVector);
            this.childColumns = new ArrowColumnVector[structVector.size()];
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i] = new ArrowColumnVector(structVector.getVectorById(i));
            }
        } else if (vector instanceof NullVector) {
            this.accessor = new NullAccessor((NullVector)vector);
        } else if (vector instanceof IntervalYearVector) {
            this.accessor = new IntervalYearAccessor((IntervalYearVector)vector);
        } else if (vector instanceof DurationVector) {
            this.accessor = new DurationAccessor((DurationVector)vector);
        } else if (vector instanceof IntervalMonthDayNanoVector) {
            this.accessor = new IntervalMonthDayNanoAccessor((IntervalMonthDayNanoVector)vector);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static class IntervalMonthDayNanoAccessor
    extends ArrowVectorAccessor {
        private final IntervalMonthDayNanoVector accessor;
        private final NullableIntervalMonthDayNanoHolder result = new NullableIntervalMonthDayNanoHolder();

        IntervalMonthDayNanoAccessor(IntervalMonthDayNanoVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        CalendarInterval getInterval(int rowId) {
            this.accessor.get(rowId, this.result);
            if (this.result.isSet == 0) {
                return null;
            }
            return new CalendarInterval(this.result.months, this.result.days, this.result.nanoseconds / 1000L);
        }
    }

    static class DurationAccessor
    extends ArrowVectorAccessor {
        private final DurationVector accessor;

        DurationAccessor(DurationVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return DurationVector.get((ArrowBuf)this.accessor.getDataBuffer(), (int)rowId);
        }
    }

    static class IntervalYearAccessor
    extends ArrowVectorAccessor {
        private final IntervalYearVector accessor;

        IntervalYearAccessor(IntervalYearVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class NullAccessor
    extends ArrowVectorAccessor {
        NullAccessor(NullVector vector) {
            super((ValueVector)vector);
        }
    }

    static class MapAccessor
    extends ArrowVectorAccessor {
        private final MapVector accessor;
        private final ArrowColumnVector keys;
        private final ArrowColumnVector values;

        MapAccessor(MapVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
            StructVector entries = (StructVector)vector.getDataVector();
            this.keys = new ArrowColumnVector((ValueVector)entries.getChild("key"));
            this.values = new ArrowColumnVector((ValueVector)entries.getChild("value"));
        }

        @Override
        final ColumnarMap getMap(int rowId) {
            int index = rowId * 4;
            int offset = this.accessor.getOffsetBuffer().getInt((long)index);
            int length = this.accessor.getInnerValueCountAt(rowId);
            return new ColumnarMap(this.keys, this.values, offset, length);
        }
    }

    static class StructAccessor
    extends ArrowVectorAccessor {
        StructAccessor(StructVector vector) {
            super((ValueVector)vector);
        }
    }

    static class ArrayAccessor
    extends ArrowVectorAccessor {
        private final ListVector accessor;
        private final ArrowColumnVector arrayData;

        ArrayAccessor(ListVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
            this.arrayData = new ArrowColumnVector((ValueVector)vector.getDataVector());
        }

        @Override
        final ColumnarArray getArray(int rowId) {
            int start = this.accessor.getElementStartIndex(rowId);
            int end = this.accessor.getElementEndIndex(rowId);
            return new ColumnarArray(this.arrayData, start, end - start);
        }
    }

    static class TimestampNTZAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroVector accessor;

        TimestampNTZAccessor(TimeStampMicroVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class TimestampAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroTZVector accessor;

        TimestampAccessor(TimeStampMicroTZVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class DateAccessor
    extends ArrowVectorAccessor {
        private final DateDayVector accessor;

        DateAccessor(DateDayVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class LargeBinaryAccessor
    extends ArrowVectorAccessor {
        private final LargeVarBinaryVector accessor;

        LargeBinaryAccessor(LargeVarBinaryVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte[] getBinary(int rowId) {
            return this.accessor.getObject(rowId);
        }
    }

    static class BinaryAccessor
    extends ArrowVectorAccessor {
        private final VarBinaryVector accessor;

        BinaryAccessor(VarBinaryVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte[] getBinary(int rowId) {
            return this.accessor.getObject(rowId);
        }
    }

    static class LargeStringAccessor
    extends ArrowVectorAccessor {
        private final LargeVarCharVector accessor;
        private final NullableLargeVarCharHolder stringResult = new NullableLargeVarCharHolder();

        LargeStringAccessor(LargeVarCharVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + this.stringResult.start), (int)((int)(this.stringResult.end - this.stringResult.start)));
        }
    }

    static class StringAccessor
    extends ArrowVectorAccessor {
        private final VarCharVector accessor;
        private final NullableVarCharHolder stringResult = new NullableVarCharHolder();

        StringAccessor(VarCharVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + (long)this.stringResult.start), (int)(this.stringResult.end - this.stringResult.start));
        }
    }

    static class DecimalAccessor
    extends ArrowVectorAccessor {
        private final DecimalVector accessor;

        DecimalAccessor(DecimalVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final Decimal getDecimal(int rowId, int precision, int scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.accessor.getObject(rowId), (int)precision, (int)scale);
        }
    }

    static class DoubleAccessor
    extends ArrowVectorAccessor {
        private final Float8Vector accessor;

        DoubleAccessor(Float8Vector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final double getDouble(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class FloatAccessor
    extends ArrowVectorAccessor {
        private final Float4Vector accessor;

        FloatAccessor(Float4Vector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final float getFloat(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class LongAccessor
    extends ArrowVectorAccessor {
        private final BigIntVector accessor;

        LongAccessor(BigIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class IntAccessor
    extends ArrowVectorAccessor {
        private final IntVector accessor;

        IntAccessor(IntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class ShortAccessor
    extends ArrowVectorAccessor {
        private final SmallIntVector accessor;

        ShortAccessor(SmallIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final short getShort(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class ByteAccessor
    extends ArrowVectorAccessor {
        private final TinyIntVector accessor;

        ByteAccessor(TinyIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte getByte(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class BooleanAccessor
    extends ArrowVectorAccessor {
        private final BitVector accessor;

        BooleanAccessor(BitVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final boolean getBoolean(int rowId) {
            return this.accessor.get(rowId) == 1;
        }
    }

    static abstract class ArrowVectorAccessor {
        final ValueVector vector;

        ArrowVectorAccessor(ValueVector vector) {
            this.vector = vector;
        }

        final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        final int getNullCount() {
            return this.vector.getNullCount();
        }

        final void close() {
            this.vector.close();
        }

        boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte getByte(int rowId) {
            throw new UnsupportedOperationException();
        }

        short getShort(int rowId) {
            throw new UnsupportedOperationException();
        }

        int getInt(int rowId) {
            throw new UnsupportedOperationException();
        }

        long getLong(int rowId) {
            throw new UnsupportedOperationException();
        }

        float getFloat(int rowId) {
            throw new UnsupportedOperationException();
        }

        double getDouble(int rowId) {
            throw new UnsupportedOperationException();
        }

        CalendarInterval getInterval(int rowId) {
            throw new UnsupportedOperationException();
        }

        Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException();
        }

        ColumnarArray getArray(int rowId) {
            throw new UnsupportedOperationException();
        }

        ColumnarMap getMap(int rowId) {
            throw new UnsupportedOperationException();
        }
    }
}

