/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.xml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception$;
import scala.util.control.NonFatal$;

public final class TypeCast$ {
    public static TypeCast$ MODULE$;

    static {
        new TypeCast$();
    }

    public Object castTo(String datum, DataType castType, XmlOptions options) {
        DataType dataType;
        block15: {
            block14: {
                String string = datum;
                String string2 = options.nullValue();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block14;
                if (!options.treatEmptyValuesAsNulls()) break block15;
                String string3 = datum;
                String string4 = "";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block15;
            }
            return null;
        }
        if ((dataType = castType) instanceof ByteType) {
            return BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(datum)).toByte());
        }
        if (dataType instanceof ShortType) {
            return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(datum)).toShort());
        }
        if (dataType instanceof IntegerType) {
            return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(datum)).toInt());
        }
        if (dataType instanceof LongType) {
            return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(datum)).toLong());
        }
        if (dataType instanceof FloatType) {
            return Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(datum)).toFloat()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).floatValue());
        }
        if (dataType instanceof DoubleType) {
            return Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(datum)).toDouble()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).doubleValue());
        }
        if (dataType instanceof BooleanType) {
            return BoxesRunTime.boxToBoolean((boolean)this.parseXmlBoolean(datum));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Decimal$.MODULE$.apply(new BigDecimal(datum.replaceAll(",", "")), decimalType.precision(), decimalType.scale());
        }
        if (dataType instanceof TimestampType) {
            return BoxesRunTime.boxToLong((long)this.parseXmlTimestamp(datum, options));
        }
        if (dataType instanceof DateType) {
            return BoxesRunTime.boxToInteger((int)this.parseXmlDate(datum, options));
        }
        if (dataType instanceof StringType) {
            return UTF8String.fromString((String)datum);
        }
        throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported type: ").append(castType.typeName()).toString());
    }

    private boolean parseXmlBoolean(String s) {
        String string = s.toLowerCase(Locale.ROOT);
        if ("true".equals(string) ? true : "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) ? true : "0".equals(string)) {
            return false;
        }
        throw new IllegalArgumentException(new StringBuilder(18).append("For input string: ").append(s).toString());
    }

    private int parseXmlDate(String value, XmlOptions options) {
        return options.dateFormatter().parse(value);
    }

    private long parseXmlTimestamp(String value, XmlOptions options) {
        long l;
        try {
            l = options.timestampFormatter().parse(value);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                boolean enableParsingFallbackForTimestampType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.get().jsonEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
                    Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
                    return !(value == null ? value2 != null : !value.equals(value2)) || options.timestampFormatInRead().isEmpty();
                }));
                if (!enableParsingFallbackForTimestampType) {
                    throw e;
                }
                UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)value));
                l = BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(str, options.zoneId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw e;
                }));
            }
            throw throwable;
        }
        return l;
    }

    public Object convertTo(String datum, DataType dataType, XmlOptions options) {
        DataType dataType2;
        String value;
        block16: {
            block15: {
                String string = value = datum != null && options.ignoreSurroundingSpaces() ? datum.trim() : datum;
                String string2 = options.nullValue();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block15;
                if (!options.treatEmptyValuesAsNulls()) break block16;
                String string3 = value;
                String string4 = "";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block16;
            }
            return null;
        }
        if (NullType$.MODULE$.equals(dataType2 = dataType)) {
            return this.castTo(value, (DataType)StringType$.MODULE$, options);
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToLong((long)this.signSafeToLong(value, options));
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToDouble((double)this.signSafeToDouble(value, options));
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return this.castTo(value, (DataType)BooleanType$.MODULE$, options);
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return this.castTo(value, (DataType)StringType$.MODULE$, options);
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return this.castTo(value, (DataType)DateType$.MODULE$, options);
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return this.castTo(value, (DataType)TimestampType$.MODULE$, options);
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToFloat((float)this.signSafeToFloat(value, options));
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return this.castTo(value, (DataType)ByteType$.MODULE$, options);
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return this.castTo(value, (DataType)ShortType$.MODULE$, options);
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToInteger((int)this.signSafeToInt(value, options));
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return this.castTo(value, (DataType)decimalType, options);
        }
        throw new IllegalArgumentException(new StringBuilder(39).append("Failed to parse a value for data type ").append(dataType).append(".").toString());
    }

    public boolean isBoolean(String value) {
        String string = value.toLowerCase(Locale.ROOT);
        return "true".equals(string) ? true : "false".equals(string);
    }

    public boolean isDouble(String value) {
        String signSafeValue;
        String string = signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        if (signSafeValue.isEmpty() || !Character.isDigit(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).head())) && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).head()) != '.') {
            return false;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty()) {
            boolean bl;
            char c = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(value)).last());
            switch (c) {
                case 'D': 
                case 'F': 
                case 'd': 
                case 'f': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
            if (bl) {
                return false;
            }
        }
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toDouble()).isDefined();
    }

    public boolean isInteger(String value) {
        String signSafeValue;
        String string = signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        if (signSafeValue.isEmpty() || !Character.isDigit(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).head()))) {
            return false;
        }
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toInt()).isDefined();
    }

    public boolean isLong(String value) {
        String signSafeValue;
        String string = signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        if (signSafeValue.isEmpty() || !Character.isDigit(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).head()))) {
            return false;
        }
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toLong()).isDefined();
    }

    public boolean isTimestamp(String value, XmlOptions options) {
        boolean bl;
        try {
            bl = options.timestampFormatter().parseOptional(value).isDefined();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    public boolean isDate(String value, XmlOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> options.dateFormatter().parse(value)).isDefined();
    }

    public long signSafeToLong(String value, XmlOptions options) {
        if (value.startsWith("+")) {
            String data = value.substring(1);
            return BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        }
        if (value.startsWith("-")) {
            String data = value.substring(1);
            return -BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        }
        String data = value;
        return BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
    }

    public double signSafeToDouble(String value, XmlOptions options) {
        if (value.startsWith("+")) {
            String data = value.substring(1);
            return BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        }
        if (value.startsWith("-")) {
            String data = value.substring(1);
            return -BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        }
        String data = value;
        return BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
    }

    public int signSafeToInt(String value, XmlOptions options) {
        if (value.startsWith("+")) {
            String data = value.substring(1);
            return BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        }
        if (value.startsWith("-")) {
            String data = value.substring(1);
            return -BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        }
        String data = value;
        return BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
    }

    public float signSafeToFloat(String value, XmlOptions options) {
        if (value.startsWith("+")) {
            String data = value.substring(1);
            return BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        }
        if (value.startsWith("-")) {
            String data = value.substring(1);
            return -BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        }
        String data = value;
        return BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
    }

    private TypeCast$() {
        MODULE$ = this;
    }
}

