/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.xml;

import java.io.Serializable;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StaxXmlParserUtils$ {
    public static StaxXmlParserUtils$ MODULE$;
    private final XMLInputFactory factory;

    static {
        new StaxXmlParserUtils$();
    }

    public XMLInputFactory factory() {
        return this.factory;
    }

    public XMLEventReader filteredReader(String xml) {
        EventFilter filter = new EventFilter(){

            public boolean accept(XMLEvent event) {
                int n = event.getEventType();
                switch (n) {
                    case 3: 
                    case 5: {
                        return false;
                    }
                }
                return true;
            }
        };
        XMLEventReader eventReader = this.factory().createXMLEventReader(new StringReader(xml));
        return this.factory().createFilteredReader(eventReader, filter);
    }

    public Attribute[] gatherRootAttributes(XMLEventReader parser) {
        XMLEvent rootEvent = this.skipUntil(parser, 1);
        return (Attribute[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rootEvent.asStartElement().getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Attribute)x$1).toArray(ClassTag$.MODULE$.apply(Attribute.class));
    }

    public XMLEvent skipUntil(XMLEventReader parser, int eventType) {
        XMLEvent event = parser.peek();
        while (parser.hasNext() && event.getEventType() != eventType) {
            event = parser.nextEvent();
        }
        return event;
    }

    public boolean checkEndElement(XMLEventReader parser) {
        XMLEvent xMLEvent;
        while (!((xMLEvent = parser.peek()) instanceof EndElement ? true : xMLEvent instanceof EndDocument)) {
            if (xMLEvent instanceof StartElement) {
                return false;
            }
            parser.nextEvent();
        }
        return true;
    }

    public Map<String, String> convertAttributesToValuesMap(Attribute[] attributes, XmlOptions options) {
        if (options.excludeAttributeFlag()) {
            return Predef$.MODULE$.Map().empty();
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes)).map((Function1 & Serializable & scala.Serializable)attr -> {
            String key = new StringBuilder(0).append(options.attributePrefix()).append(MODULE$.getName(attr.getName(), options)).toString();
            String string = attr.getValue();
            String value = options.treatEmptyValuesAsNulls() && string.trim().isEmpty() ? null : string;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public String getName(QName name, XmlOptions options) {
        String localPart = name.getLocalPart();
        if (options.ignoreNamespace()) {
            return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localPart.split(":"))).last();
        }
        return localPart;
    }

    public String currentStructureAsString(XMLEventReader parser) {
        boolean bl;
        scala.collection.mutable.StringBuilder xmlString = new scala.collection.mutable.StringBuilder();
        int indent = 0;
        do {
            XMLEvent xMLEvent;
            if ((xMLEvent = parser.nextEvent()) instanceof StartElement) {
                StartElement startElement = (StartElement)xMLEvent;
                xmlString.append('<').append((Object)startElement.getName());
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(startElement.getAttributes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
                    Attribute att = (Attribute)a;
                    return xmlString.append(' ').append((Object)att.getName()).append("=\"").append(att.getValue()).append('\"');
                });
                xmlString.append('>');
                ++indent;
            } else if (xMLEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xMLEvent;
                xmlString.append("</").append((Object)endElement.getName()).append('>');
                --indent;
            } else if (xMLEvent instanceof Characters) {
                Characters characters = (Characters)xMLEvent;
                xmlString.append(characters.getData());
            } else if (xMLEvent != null) {
            } else {
                throw new MatchError((Object)xMLEvent);
            }
            XMLEvent xMLEvent2 = parser.peek();
            if (xMLEvent2 instanceof EndElement) {
                if (indent > 0) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = true;
        } while (bl);
        return xmlString.toString();
    }

    public void skipChildren(XMLEventReader parser) {
        boolean shouldStop = this.checkEndElement(parser);
        while (!shouldStop) {
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                XMLEvent e = parser.peek();
                Object object = e.isCharacters() && e.asCharacters().isWhiteSpace() ? parser.next() : BoxedUnit.UNIT;
                if (parser.peek().isStartElement()) {
                    this.skipChildren(parser);
                }
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = this.checkEndElement(parser);
                continue;
            }
            if (xMLEvent != null) {
                continue;
            }
            throw new MatchError((Object)xMLEvent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private StaxXmlParserUtils$() {
        void var1_1;
        MODULE$ = this;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.isCoalescing", BoxesRunTime.boxToBoolean((boolean)true));
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.supportDTD", BoxesRunTime.boxToBoolean((boolean)false));
        this.factory = var1_1;
    }
}

