/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.xml;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import javax.xml.stream.XMLStreamWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class StaxXmlGenerator$ {
    public static StaxXmlGenerator$ MODULE$;

    static {
        new StaxXmlGenerator$();
    }

    public void apply(StructType schema, XMLStreamWriter writer, XmlOptions options, InternalRow row) {
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(options.attributePrefix())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "'attributePrefix' option should not be empty string.");
        Seq<Object> rowSeq = row.toSeq(schema);
        Tuple2 tuple2 = ((TraversableLike)schema.zip(rowSeq, Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlGenerator$.$anonfun$apply$11(options, x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq attributes = (Seq)tuple2._1();
        Seq elements = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)attributes, (Object)elements);
        Seq attributes2 = (Seq)tuple22._1();
        Seq elements2 = (Seq)tuple22._2();
        writer.writeStartElement(options.rowTag());
        attributes2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            StaxXmlGenerator$.$anonfun$apply$12(options, writer, x0$2);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple23 = elements2.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq names = (Seq)tuple23._1();
        Seq values = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)names, (Object)values);
        Seq names2 = (Seq)tuple24._1();
        Seq values2 = (Seq)tuple24._2();
        StructType elementSchema = StructType$.MODULE$.apply((Seq)schema.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)names2.contains(elem))));
        InternalRow elementRow = InternalRow$.MODULE$.fromSeq((Seq<Object>)((Seq)rowSeq.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)values2.contains(elem)))));
        StaxXmlGenerator$.writeElement$1((DataType)elementSchema, elementRow, options, writer, options);
        writer.writeEndElement();
    }

    private static final void writeChildElement$1(String name, DataType dt, Object v, XmlOptions options$1, XMLStreamWriter writer$1) {
        DataType dataType;
        Object object;
        Tuple3 tuple3 = new Tuple3((Object)name, (Object)dt, v);
        if ((tuple3 != null && (object = tuple3._3()) == null ? true : tuple3 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple3._2())) && options$1.nullValue() == null) {
            return;
        }
        if (tuple3 != null) {
            String string = name;
            String string2 = options$1.valueTag();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                StaxXmlGenerator$.writeElement$1(dt, v, options$1, writer$1, options$1);
                return;
            }
        }
        if (tuple3 != null) {
            writer$1.writeStartElement(name);
            StaxXmlGenerator$.writeElement$1(dt, v, options$1, writer$1, options$1);
            writer$1.writeEndElement();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private static final void writeChild$1(String name, DataType dt, Object v, XmlOptions options$1, XMLStreamWriter writer$1) {
        DataType dataType;
        Object object;
        Tuple2 tuple2 = new Tuple2((Object)dt, v);
        if ((tuple2 != null && (object = tuple2._2()) == null ? true : tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._1())) && name.startsWith(options$1.attributePrefix())) {
            String string = name;
            String string2 = options$1.valueTag();
            if (string == null ? string2 != null : !string.equals(string2)) {
                Option$.MODULE$.apply((Object)options$1.nullValue()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    writer$1.writeAttribute(name.substring(options$1.attributePrefix().length()), x$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if (name.startsWith(options$1.attributePrefix())) {
            String string = name;
            String string3 = options$1.valueTag();
            if (string == null ? string3 != null : !string.equals(string3)) {
                writer$1.writeAttribute(name.substring(options$1.attributePrefix().length()), v.toString());
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType2 = (DataType)tuple2._1();
            Object v2 = tuple2._2();
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType ty = arrayType.elementType();
                if (v2 instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)v2;
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arrayData.numElements()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> StaxXmlGenerator$.writeChildElement$1(name, ty, arrayData.get(i, ty), options$1, writer$1));
                    return;
                }
            }
        }
        StaxXmlGenerator$.writeChildElement$1(name, dt, v, options$1, writer$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$apply$5(XmlOptions options$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object f = tuple2._1();
        if (!f.toString().startsWith(options$2.attributePrefix())) return false;
        String string = f.toString();
        String string2 = options$2.valueTag();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$apply$6(DataType vt$1, XmlOptions options$1, XMLStreamWriter writer$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object k = tuple2._1();
            Object v = tuple2._2();
            StaxXmlGenerator$.writeChild$1(k.toString(), vt$1, v, options$1, writer$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$apply$7(XmlOptions options$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        StructField f = (StructField)tuple2._1();
        if (!f.name().startsWith(options$2.attributePrefix())) return false;
        String string = f.name();
        String string2 = options$2.valueTag();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$apply$8(XmlOptions options$1, XMLStreamWriter writer$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            Object value = tuple2._2();
            StaxXmlGenerator$.writeChild$1(field.name(), field.dataType(), value, options$1, writer$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void writeElement$1(DataType dt, Object v, XmlOptions options, XMLStreamWriter writer$1, XmlOptions options$1) {
        DataType dataType;
        Object object;
        Tuple2 tuple2 = new Tuple2((Object)dt, v);
        if (tuple2 != null && (object = tuple2._2()) == null ? true : tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._1())) {
            writer$1.writeCharacters(options.nullValue());
            return;
        }
        if (tuple2 != null) {
            DataType dataType2 = (DataType)tuple2._1();
            Object v2 = tuple2._2();
            if (StringType$.MODULE$.equals(dataType2) && v2 instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)v2;
                writer$1.writeCharacters(uTF8String.toString());
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType3 = (DataType)tuple2._1();
            Object v3 = tuple2._2();
            if (StringType$.MODULE$.equals(dataType3) && v3 instanceof String) {
                String string = (String)v3;
                writer$1.writeCharacters(string);
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType4 = (DataType)tuple2._1();
            Object v4 = tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType4) && v4 instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)v4;
                writer$1.writeCharacters(options.timestampFormatterInWrite().format(timestamp.toInstant()));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType5 = (DataType)tuple2._1();
            Object v5 = tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType5) && v5 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)v5);
                writer$1.writeCharacters(options.timestampFormatterInWrite().format(l));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType6 = (DataType)tuple2._1();
            Object v6 = tuple2._2();
            if (DateType$.MODULE$.equals(dataType6) && v6 instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)v6);
                writer$1.writeCharacters(options.dateFormatterInWrite().format(n));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType7 = (DataType)tuple2._1();
            Object v7 = tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType7) && v7 instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)v7);
                writer$1.writeCharacters(Integer.toString(n));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType8 = (DataType)tuple2._1();
            Object v8 = tuple2._2();
            if (ShortType$.MODULE$.equals(dataType8) && v8 instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)v8);
                writer$1.writeCharacters(Short.toString(s));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType9 = (DataType)tuple2._1();
            Object v9 = tuple2._2();
            if (FloatType$.MODULE$.equals(dataType9) && v9 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)v9);
                writer$1.writeCharacters(Float.toString(f));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType10 = (DataType)tuple2._1();
            Object v10 = tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType10) && v10 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)v10);
                writer$1.writeCharacters(Double.toString(d));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType11 = (DataType)tuple2._1();
            Object v11 = tuple2._2();
            if (LongType$.MODULE$.equals(dataType11) && v11 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)v11);
                writer$1.writeCharacters(Long.toString(l));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType12 = (DataType)tuple2._1();
            Object v12 = tuple2._2();
            if (DecimalType$.MODULE$.unapply(dataType12) && v12 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)v12;
                writer$1.writeCharacters(bigDecimal.toString());
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType13 = (DataType)tuple2._1();
            Object v13 = tuple2._2();
            if (DecimalType$.MODULE$.unapply(dataType13) && v13 instanceof Decimal) {
                Decimal decimal = (Decimal)v13;
                writer$1.writeCharacters(decimal.toString());
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType14 = (DataType)tuple2._1();
            Object v14 = tuple2._2();
            if (ByteType$.MODULE$.equals(dataType14) && v14 instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)v14);
                writer$1.writeCharacters(Byte.toString(by));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType15 = (DataType)tuple2._1();
            Object v15 = tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType15) && v15 instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)v15);
                writer$1.writeCharacters(Boolean.toString(bl));
                return;
            }
        }
        if (tuple2 != null) {
            DataType dataType16 = (DataType)tuple2._1();
            Object v16 = tuple2._2();
            if (dataType16 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType16;
                DataType ty = arrayType.elementType();
                if (v16 instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)v16;
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arrayData.numElements()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> StaxXmlGenerator$.writeChild$1(options.arrayElementName(), ty, arrayData.get(i, ty), options$1, writer$1));
                    return;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType17 = (DataType)tuple2._1();
            Object mv = tuple2._2();
            if (dataType17 instanceof MapType) {
                MapType mapType = (MapType)dataType17;
                DataType vt = mapType.valueType();
                if (mv instanceof Map) {
                    Map map = (Map)mv;
                    Tuple2 tuple22 = map.toSeq().partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlGenerator$.$anonfun$apply$5(options, x0$1)));
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Seq attributes = (Seq)tuple22._1();
                    Seq elements = (Seq)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)attributes, (Object)elements);
                    Seq attributes2 = (Seq)tuple23._1();
                    Seq elements2 = (Seq)tuple23._2();
                    ((IterableLike)attributes2.$plus$plus((GenTraversableOnce)elements2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        StaxXmlGenerator$.$anonfun$apply$6(vt, options$1, writer$1, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }
        }
        if (tuple2 != null) {
            DataType mt = (DataType)tuple2._1();
            Object mv = tuple2._2();
            if (mt instanceof MapType) {
                MapType mapType = (MapType)mt;
                if (mv instanceof MapData) {
                    MapData mapData = (MapData)mv;
                    StaxXmlGenerator$.writeMapData$1(mapType, mapData, options$1, writer$1);
                    return;
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Object r = tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (r instanceof InternalRow) {
                    InternalRow internalRow = (InternalRow)r;
                    Tuple2 tuple24 = ((TraversableLike)structType.zip(internalRow.toSeq(structType), Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlGenerator$.$anonfun$apply$7(options, x0$3)));
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    Seq attributes = (Seq)tuple24._1();
                    Seq elements = (Seq)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)attributes, (Object)elements);
                    Seq attributes3 = (Seq)tuple25._1();
                    Seq elements3 = (Seq)tuple25._2();
                    ((IterableLike)attributes3.$plus$plus((GenTraversableOnce)elements3, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        StaxXmlGenerator$.$anonfun$apply$8(options$1, writer$1, x0$4);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }
        }
        if (tuple2 != null) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Failed to convert value ").append(v).append(" (class of ").append(v.getClass()).append(") in type ").append(dt).append(" to XML.").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$apply$10(ArrayData keyArray$1, MapType mapType$1, XmlOptions options$1, boolean writeAttribute$1, ArrayData valueArray$1, XMLStreamWriter writer$1, int i) {
        key = keyArray$1.get(i, mapType$1.keyType()).toString();
        if (!key.startsWith(options$1.attributePrefix())) ** GOTO lbl-1000
        v0 = key;
        var9_8 = options$1.valueTag();
        if (v0 == null ? var9_8 != null : v0.equals(var9_8) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = isAttribute = false;
        }
        if (writeAttribute$1 == isAttribute) {
            StaxXmlGenerator$.writeChild$1(key, mapType$1.valueType(), valueArray$1.get(i, mapType$1.valueType()), options$1, writer$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$apply$9(MapData map$1, ArrayData keyArray$1, MapType mapType$1, XmlOptions options$1, ArrayData valueArray$1, XMLStreamWriter writer$1, boolean writeAttribute) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), map$1.numElements()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> StaxXmlGenerator$.$anonfun$apply$10(keyArray$1, mapType$1, options$1, writeAttribute, valueArray$1, writer$1, arg_0)));
    }

    private static final void writeMapData$1(MapType mapType, MapData map, XmlOptions options$1, XMLStreamWriter writer$1) {
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)writeAttribute -> {
            StaxXmlGenerator$.$anonfun$apply$9(map, keyArray, mapType, options$1, valueArray, writer$1, BoxesRunTime.unboxToBoolean((Object)writeAttribute));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$apply$11(XmlOptions options$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        StructField f = (StructField)tuple2._1();
        if (!f.name().startsWith(options$1.attributePrefix())) return false;
        String string = f.name();
        String string2 = options$1.valueTag();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$apply$12(XmlOptions options$1, XMLStreamWriter writer$1, Tuple2 x0$2) {
        Tuple2 tuple2;
        block4: {
            StructField f;
            block5: {
                tuple2 = x0$2;
                if (tuple2 == null) break block4;
                f = (StructField)tuple2._1();
                Object v = tuple2._2();
                if (v == null) break block5;
                DataType dataType = f.dataType();
                NullType$ nullType$ = NullType$.MODULE$;
                if (dataType != null ? !dataType.equals(nullType$) : nullType$ != null) break block4;
            }
            Option$.MODULE$.apply((Object)options$1.nullValue()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                writer$1.writeAttribute(f.name().substring(options$1.attributePrefix().length()), x$5);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            Object v = tuple2._2();
            writer$1.writeAttribute(f.name().substring(options$1.attributePrefix().length()), v.toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private StaxXmlGenerator$() {
        MODULE$ = this;
    }
}

