/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.hadoop.io.Text;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Predef$;
import scala.Serializable;
import sun.nio.cs.StreamDecoder;

public final class CreateXmlParser$
implements Serializable {
    public static CreateXmlParser$ MODULE$;
    private final EventFilter filter;

    static {
        new CreateXmlParser$();
    }

    public EventFilter filter() {
        return this.filter;
    }

    public XMLEventReader string(XMLInputFactory xmlInputFactory, String record) {
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(new StringReader(record));
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    public XMLEventReader utf8String(XMLInputFactory xmlInputFactory, UTF8String record) {
        ByteBuffer bb = record.getByteBuffer();
        Predef$.MODULE$.assert(bb.hasArray());
        ByteArrayInputStream bain = new ByteArrayInputStream(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)bain, StandardCharsets.UTF_8));
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    public XMLEventReader text(XMLInputFactory xmlInputFactory, Text record) {
        ByteArrayInputStream bs = new ByteArrayInputStream(record.getBytes(), 0, record.getLength());
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(bs);
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    private StreamDecoder getStreamDecoder(String enc, byte[] in, int length) {
        ByteArrayInputStream bais = new ByteArrayInputStream(in, 0, length);
        ReadableByteChannel byteChannel = Channels.newChannel(bais);
        int decodingBufferSize = Math.min(length, 8192);
        CharsetDecoder decoder = Charset.forName(enc).newDecoder();
        return StreamDecoder.forDecoder(byteChannel, decoder, decodingBufferSize);
    }

    public XMLEventReader text(String enc, XMLInputFactory xmlInputFactory, Text record) {
        StreamDecoder sd = this.getStreamDecoder(enc, record.getBytes(), record.getLength());
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(sd);
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    public XMLEventReader inputStream(XMLInputFactory xmlInputFactory, InputStream is) {
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(is);
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    public XMLEventReader inputStream(String enc, XMLInputFactory xmlInputFactory, InputStream is) {
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader(is, enc));
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    public XMLEventReader internalRow(XMLInputFactory xmlInputFactory, InternalRow row) {
        byte[] ba = row.getBinary(0);
        ByteArrayInputStream bs = new ByteArrayInputStream(ba, 0, ba.length);
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(bs);
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    public XMLEventReader internalRow(String enc, XMLInputFactory xmlInputFactory, InternalRow row) {
        byte[] binary = row.getBinary(0);
        StreamDecoder sd = this.getStreamDecoder(enc, binary, binary.length);
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(sd);
        return xmlInputFactory.createFilteredReader(eventReader, this.filter());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CreateXmlParser$() {
        MODULE$ = this;
        this.filter = new EventFilter(){

            public boolean accept(XMLEvent event) {
                int n = event.getEventType();
                switch (n) {
                    case 3: 
                    case 5: {
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

