/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.catalyst.types.PhysicalNumericType$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AnsiIntervalType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TypeUtils$
implements QueryErrorsBase {
    public static TypeUtils$ MODULE$;

    static {
        new TypeUtils$();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public TypeCheckResult checkForOrderingExpr(DataType dt, String caller) {
        if (RowOrdering$.MODULE$.isOrderable(dt)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_ORDERING_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(caller)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)dt))}))));
    }

    public TypeCheckResult checkForSameTypeInputExpr(Seq<DataType> types, String caller) {
        if (TypeCoercion$.MODULE$.haveSameType(types)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(caller)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> MODULE$.toSQLType((AbstractDataType)t), Seq$.MODULE$.canBuildFrom())).mkString("(", " or ", ")"))}))));
    }

    public TypeCheckResult checkForMapKeyType(DataType keyType) {
        if (keyType.existsRecursively((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.$anonfun$checkForMapKeyType$1(x$1)))) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyType"), (Object)this.toSQLType((AbstractDataType)keyType))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public TypeCheckResult checkForAnsiIntervalOrNumericType(Expression input) {
        DataType dataType = input.dataType();
        if (dataType instanceof AnsiIntervalType ? true : NullType$.MODULE$.equals(dataType)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        if (dataType instanceof NumericType) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)((TraversableOnce)((TraversableLike)new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)AnsiIntervalType$.MODULE$, (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.toSQLType((AbstractDataType)t), Seq$.MODULE$.canBuildFrom())).mkString(" or ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(input)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)dataType))}))));
    }

    public Numeric<Object> getNumeric(DataType t, boolean exactNumericRequired) {
        if (exactNumericRequired) {
            return PhysicalNumericType$.MODULE$.exactNumeric((NumericType)t);
        }
        return PhysicalNumericType$.MODULE$.numeric((NumericType)t);
    }

    public boolean getNumeric$default$2() {
        return false;
    }

    public Ordering<Object> getInterpretedOrdering(DataType t) {
        DataType dataType;
        while ((dataType = t) instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            t = userDefinedType.sqlType();
        }
        return PhysicalDataType$.MODULE$.ordering(dataType);
    }

    public boolean typeWithProperEquals(DataType dataType) {
        DataType dataType2 = dataType;
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return false;
        }
        return dataType2 instanceof AtomicType;
    }

    public void failWithIntervalType(DataType dataType) {
        this.invokeOnceForInterval(dataType, false, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotUseIntervalTypeInTableSchemaError();
        });
    }

    public void invokeOnceForInterval(DataType dataType2, boolean forbidAnsiIntervals, Function0<BoxedUnit> f) {
        if (dataType2.existsRecursively((Function1 & Serializable & scala.Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.isInterval$1(dataType, forbidAnsiIntervals)))) {
            f.apply$mcV$sp();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForMapKeyType$1(DataType x$1) {
        return x$1 instanceof MapType;
    }

    private static final boolean isInterval$1(DataType dataType, boolean forbidAnsiIntervals$1) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            return forbidAnsiIntervals$1;
        }
        return CalendarIntervalType$.MODULE$.equals(dataType2);
    }

    private TypeUtils$() {
        MODULE$ = this;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

