/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import java.time.ZoneId;
import javax.xml.validation.Schema;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.expressions.xml.XmlToStructs$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser$;
import org.apache.spark.sql.catalyst.xml.ValidatorUtil$;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xmlStr, schema[, options]) - Returns a struct value with the given `xmlStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('<p><a>1</a><b>0.8</b></p>', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('<p><time>26/08/2015</time></p>', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('<p><teacher>Alice</teacher><student><name>Bob</name><rank>1</rank></student><student><name>Charlie</name><rank>2</rank></student></p>', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="xml_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0001\tEf\u0001B\u00181\u0001~B\u0001\"\u001e\u0001\u0003\u0016\u0004%\tA\u001e\u0005\t{\u0002\u0011\t\u0012)A\u0005o\"Aa\u0010\u0001BK\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\u0018\u0001\u0011\t\u0012)A\u0005\u0003\u0003A!\"!\u0007\u0001\u0005+\u0007I\u0011AA\u000e\u0011)\t\u0019\u0003\u0001B\tB\u0003%\u0011Q\u0004\u0005\u000b\u0003K\u0001!Q3A\u0005\u0002\u0005\u001d\u0002BCA\u0018\u0001\tE\t\u0015!\u0003\u0002*!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u0019\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011!\t\u0019\u0006\u0001b\u0001\n\u00031\bbBA+\u0001\u0001\u0006Ia\u001e\u0005\b\u0003c\u0001A\u0011AA,\u0011\u001d\t\t\u0004\u0001C\u0001\u0003;B!\"!\u001a\u0001\u0011\u000b\u0007I\u0011AA4\u0011%\t)\u000b\u0001b\u0001\n\u0003\t9\u000b\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BA\t\u0011)\tY\u000b\u0001EC\u0002\u0013\u0005\u0011Q\u0016\u0005\u0007\u0003{\u0003A\u0011\t<\t\u000f\u0005}\u0006\u0001\"\u0011\u0002B\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\u0007o\u0001!\t%a*\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002(\"9\u00111\u001d\u0001\u0005\u0012\u0005\u0015\b\"CAv\u0001\u0005\u0005I\u0011AAw\u0011%\t9\u0010AI\u0001\n\u0003\tI\u0010C\u0005\u0003\u0010\u0001\t\n\u0011\"\u0001\u0003\u0012!I!Q\u0003\u0001\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u00057\u0001\u0011\u0013!C\u0001\u0005;A\u0011B!\t\u0001\u0003\u0003%\tEa\t\t\u0013\t%\u0002!!A\u0005\u0002\t-\u0002\"\u0003B\u001a\u0001\u0005\u0005I\u0011\u0001B\u001b\u0011%\u0011Y\u0004AA\u0001\n\u0003\u0012i\u0004C\u0005\u0003J\u0001\t\t\u0011\"\u0001\u0003L!I!q\n\u0001\u0002\u0002\u0013\u0005#\u0011K\u0004\n\u0005k\u0002\u0014\u0011!E\u0001\u0005o2\u0001b\f\u0019\u0002\u0002#\u0005!\u0011\u0010\u0005\b\u0003c9C\u0011\u0001BD\u0011%\u0011IiJA\u0001\n\u000b\u0012Y\tC\u0005\u0003\u000e\u001e\n\t\u0011\"!\u0003\u0010\"I!\u0011T\u0014\u0012\u0002\u0013\u0005!Q\u0004\u0005\n\u00057;\u0013\u0011!CA\u0005;C\u0011Ba+(#\u0003%\tA!\b\t\u0013\t5v%!A\u0005\n\t=&\u0001\u0004-nYR{7\u000b\u001e:vGR\u001c(BA\u00193\u0003\rAX\u000e\u001c\u0006\u0003gQ\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QGN\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0007O\u0001\u0004gFd'BA\u001d;\u0003\u0015\u0019\b/\u0019:l\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\u0004\u0001MI\u0001\u0001\u0011#H\u001bB3GN\u001d\t\u0003\u0003\nk\u0011AM\u0005\u0003\u0007J\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0003\u0016K!A\u0012\u001a\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007C\u0001%L\u001b\u0005I%B\u0001&3\u0003\u001d\u0019w\u000eZ3hK:L!\u0001T%\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"!\u0011(\n\u0005=\u0013$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011k\u0019\b\u0003%\u0006t!a\u00151\u000f\u0005Q{fBA+_\u001d\t1VL\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!LP\u0001\u0007yI|w\u000e\u001e \n\u0003uJ!a\u000f\u001f\n\u0005eR\u0014BA\u001c9\u0013\t)d'\u0003\u00024i%\u0011!MM\u0001\ba\u0006\u001c7.Y4f\u0013\t!WM\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\t\u0014\u0004CA4k\u001b\u0005A'BA57\u0003\u0019)'O]8sg&\u00111\u000e\u001b\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011Q\u000e]\u0007\u0002]*\tq.A\u0003tG\u0006d\u0017-\u0003\u0002r]\n9\u0001K]8ek\u000e$\bCA7t\u0013\t!hN\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004tG\",W.Y\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\u0011!PN\u0001\u0006if\u0004Xm]\u0005\u0003yf\u0014\u0001\u0002R1uCRK\b/Z\u0001\bg\u000eDW-\\1!\u0003\u001dy\u0007\u000f^5p]N,\"!!\u0001\u0011\u0011\u0005\r\u00111BA\t\u0003#qA!!\u0002\u0002\bA\u0011\u0001L\\\u0005\u0004\u0003\u0013q\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!aA'ba*\u0019\u0011\u0011\u00028\u0011\t\u0005\r\u00111C\u0005\u0005\u0003+\tyA\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u0005)1\r[5mIV\u0011\u0011Q\u0004\t\u0004\u0003\u0006}\u0011bAA\u0011e\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0003\u0003S\u0001R!\\A\u0016\u0003#I1!!\fo\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}QQ\u0011QGA\u001d\u0003w\ti$a\u0010\u0011\u0007\u0005]\u0002!D\u00011\u0011\u0015)\u0018\u00021\u0001x\u0011\u0019q\u0018\u00021\u0001\u0002\u0002!9\u0011\u0011D\u0005A\u0002\u0005u\u0001\"CA\u0013\u0013A\u0005\t\u0019AA\u0015)!\t)$a\u0011\u0002F\u0005\u001d\u0003bBA\r\u0015\u0001\u0007\u0011Q\u0004\u0005\u0007k*\u0001\r!!\b\t\ryT\u0001\u0019AA\u0001\u0003!qW\u000f\u001c7bE2,WCAA'!\ri\u0017qJ\u0005\u0004\u0003#r'a\u0002\"p_2,\u0017M\\\u0001\u000f]VdG.\u00192mKN\u001b\u0007.Z7b\u0003=qW\u000f\u001c7bE2,7k\u00195f[\u0006\u0004CCBA\u001b\u00033\nY\u0006C\u0004\u0002\u001a9\u0001\r!!\b\t\rUt\u0001\u0019AA\u000f)!\t)$a\u0018\u0002b\u0005\r\u0004bBA\r\u001f\u0001\u0007\u0011Q\u0004\u0005\u0007k>\u0001\r!!\b\t\ry|\u0001\u0019AA\u000f\u0003%\u0019wN\u001c<feR,'/\u0006\u0002\u0002jA9Q.a\u001b\u0002p\u0005\u001d\u0015bAA7]\nIa)\u001e8di&|g.\r\t\u0007\u0003c\nI(a \u000f\t\u0005M\u0014q\u000f\b\u00041\u0006U\u0014\"A8\n\u0005\tt\u0017\u0002BA>\u0003{\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003E:\u0004B!!!\u0002\u00046\tA'C\u0002\u0002\u0006R\u00121\"\u00138uKJt\u0017\r\u001c*poJ)\u0011\u0011\u0012:\u0002\u000e\u001a1\u00111\u0012\u0001\u0001\u0003\u000f\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0003mC:<'BAAL\u0003\u0011Q\u0017M^1\n\t\u0005m\u0015\u0011\u0013\u0002\u0007\u001f\nTWm\u0019;)\u0007A\ty\nE\u0002n\u0003CK1!a)o\u0005%!(/\u00198tS\u0016tG/A\noC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H-\u0006\u0002\u0002\u0012\u0005!b.Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sI\u0002\na\u0001]1sg\u0016\u0014XCAAX!\u0019\t\t,a.\u0002\u00125\u0011\u00111\u0017\u0006\u0004\u0003k#\u0014\u0001B;uS2LA!!/\u00024\n\tb)Y5mkJ,7+\u00194f!\u0006\u00148/\u001a:)\u0007M\ty*\u0001\u0005eCR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r!\u00151\u0019\u0005\b\u0003K)\u0002\u0019AA\t\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\tI-a4\u0011\u00075\fY-C\u0002\u0002N:\u00141!\u00118z\u0011\u0019\td\u00031\u0001\u0002J\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005U\u0007CBA9\u0003/\fY.\u0003\u0003\u0002Z\u0006u$aA*fcB\u0019\u00010!8\n\u0007\u0005}\u0017P\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\u0011\t)$a:\t\u000f\u0005%(\u00041\u0001\u0002\u001e\u0005Aa.Z<DQ&dG-\u0001\u0003d_BLHCCA\u001b\u0003_\f\t0a=\u0002v\"9Qo\u0007I\u0001\u0002\u00049\b\u0002\u0003@\u001c!\u0003\u0005\r!!\u0001\t\u0013\u0005e1\u0004%AA\u0002\u0005u\u0001\"CA\u00137A\u0005\t\u0019AA\u0015\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a?+\u0007]\fip\u000b\u0002\u0002\u0000B!!\u0011\u0001B\u0006\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011!C;oG\",7m[3e\u0015\r\u0011IA\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0007\u0005\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0005+\t\u0005\u0005\u0011Q`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IB\u000b\u0003\u0002\u001e\u0005u\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005?QC!!\u000b\u0002~\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\n\u0011\t\u0005=%qE\u0005\u0005\u0003+\t\t*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003.A\u0019QNa\f\n\u0007\tEbNA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002J\n]\u0002\"\u0003B\u001dE\u0005\u0005\t\u0019\u0001B\u0017\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\b\t\u0007\u0005\u0003\u00129%!3\u000e\u0005\t\r#b\u0001B#]\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m$1I\u0001\tG\u0006tW)];bYR!\u0011Q\nB'\u0011%\u0011I\u0004JA\u0001\u0002\u0004\tI-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\u0012\u0019\u0006C\u0005\u0003:\u0015\n\t\u00111\u0001\u0002J\"\u001a\u0002Aa\u0016\u0003^\t}#1\rB3\u0005S\u0012YGa\u001c\u0003rA\u0019\u0011I!\u0017\n\u0007\tm#GA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u0005\u0014\u0001Y0G+:\u001bu\f\u000b=nYN#(\u000f\f\u0011tG\",W.Y.-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u001aHO];di\u00022\u0018\r\\;fA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002\u00070\u001c7TiJ\u0004\u0007%\u00198eA\u0001\u001c8\r[3nC\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\u001d\u0014\u0001b&\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001db\u0004O\u0010\u001fb}Ebt&\u0019 =Ez\u0002d\u0006\u000f\u001f0Ezbt\u0006\u001d (Y\u0001:\u0013\rI%O)2\u0002#\r\t#P+\ncUiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u0019/quT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001fq}q\"\u0018.\\3?eYz\u0003\u0007O\u00183aE*Dh\f;j[\u0016tDh\f9?O1\u0002s\u0005^5nK\u0002\"\u0016.\\3ti\u0006l\u0007o\n\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u001a1cUj\u0003\u0007O\u00173m\u0001\u0002\u0004G\u000f\u00191uA\u0002TP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(yAtD\b^3bG\",'OP!mS\u000e,Gh\f;fC\u000eDWM\u001d =gR,H-\u001a8u}qr\u0017-\\3?\u0005>\u0014Gh\f8b[\u0016tDH]1oWz\nDh\f:b].tDhL:uk\u0012,g\u000e\u001e =gR,H-\u001a8u}qr\u0017-\\3?\u0007\"\f'\u000f\\5fy=r\u0017-\\3?yI\fgn\u001b 3y=\u0012\u0018M\\6?y=\u001aH/\u001e3f]RtDh\f9?O1\u0002se\u0015+S+\u000e#F\b^3bG\",'O\u000f\u0011T)JKej\u0012\u0017!gR,H-\u001a8uu\u0001\n%KU!ZyM#&+V\"Uy9\fW.\u001a\u001e!'R\u0013\u0016JT$-AI\fgn\u001b\u001e!\u0013:#fH\u0010 (SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;fC\u000eDWM\u001d\u0012;E\u0005c\u0017nY3#Y\t\u001aH/\u001e3f]R\u0014#hW>#]\u0006lWM\t\u001e#\u0005>\u0014'\u0005\f\u0012sC:\\'EO\u0019~Ym\u0014c.Y7fEi\u00123\t[1sY&,'\u0005\f\u0012sC:\\'E\u000f\u001a~;vT\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005[\n\u0011\u0002_7m?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\tM\u0014!\u0002\u001b/a9\u0002\u0014\u0001\u0004-nYR{7\u000b\u001e:vGR\u001c\bcAA\u001cOM!qEa\u001fs!5\u0011iHa!x\u0003\u0003\ti\"!\u000b\u000265\u0011!q\u0010\u0006\u0004\u0005\u0003s\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005\u000b\u0013yHA\tBEN$(/Y2u\rVt7\r^5p]R\"\"Aa\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\n\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005U\"\u0011\u0013BJ\u0005+\u00139\nC\u0003vU\u0001\u0007q\u000f\u0003\u0004\u007fU\u0001\u0007\u0011\u0011\u0001\u0005\b\u00033Q\u0003\u0019AA\u000f\u0011%\t)C\u000bI\u0001\u0002\u0004\tI#A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa(\u0003(B)Q.a\u000b\u0003\"BQQNa)x\u0003\u0003\ti\"!\u000b\n\u0007\t\u0015fN\u0001\u0004UkBdW\r\u000e\u0005\n\u0005Sc\u0013\u0011!a\u0001\u0003k\t1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\t")
public class XmlToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
QueryErrorsBase,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return XmlToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(XmlToStructs xmlToStructs) {
        return XmlToStructs$.MODULE$.unapply(xmlToStructs);
    }

    public static Option<String> apply$default$4() {
        return XmlToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, XmlToStructs> tupled() {
        return XmlToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, XmlToStructs>>>> curried() {
        return XmlToStructs$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> {
                        if (rows.hasNext()) {
                            return (InternalRow)rows.next();
                        }
                        return null;
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> {
                        if (rows.hasNext()) {
                            return ((SpecializedGetters)rows.next()).getArray(0);
                        }
                        return null;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> {
                        if (rows.hasNext()) {
                            return ((SpecializedGetters)rows.next()).getMap(0);
                        }
                        return null;
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<String> parser$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ArrayType arrayType;
                DataType st;
                StructType structType;
                Tuple2 tuple2;
                Tuple2 tuple22;
                DataType dataType;
                ParseMode mode;
                XmlOptions parsedOptions = new XmlOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_xml", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType2 = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType2, parsedOptions.columnNameOfCorruptRecord());
                    tuple22 = new Tuple2((Object)structType2, (Object)StructType$.MODULE$.apply((Seq)structType2.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XmlToStructs.$anonfun$parser$1(parsedOptions, x$1)))));
                } else {
                    tuple22 = tuple2 = new Tuple2((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), (Object)dataType);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructType parserSchema = (StructType)tuple2._1();
                DataType actualSchema = (DataType)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                StructType parserSchema2 = (StructType)tuple23._1();
                DataType actualSchema2 = (DataType)tuple23._2();
                DataType dataType2 = this.schema();
                if (dataType2 instanceof StructType) {
                    StructType structType3;
                    structType = structType3 = (StructType)dataType2;
                } else if (dataType2 instanceof ArrayType && (st = (arrayType = (ArrayType)dataType2).elementType()) instanceof StructType) {
                    StructType structType4;
                    structType = structType4 = (StructType)st;
                } else {
                    throw new MatchError((Object)dataType2);
                }
                StructType rowSchema = structType;
                StaxXmlParser rawParser = new StaxXmlParser(rowSchema, parsedOptions, StaxXmlParser$.MODULE$.$lessinit$greater$default$3());
                Option xsdSchema = Option$.MODULE$.apply((Object)parsedOptions.rowValidationXSDPath()).map((Function1 & Serializable & scala.Serializable)path -> ValidatorUtil$.MODULE$.getSchema((String)path));
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> Option$.MODULE$.option2Iterable(rawParser.doParseColumn((String)input, mode, (Option<Schema>)xsdSchema)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<String> parser() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object xml) {
        Object object = xml;
        if (object instanceof GenericArrayData) {
            GenericArrayData genericArrayData = (GenericArrayData)object;
            return new GenericArrayData(Predef$.MODULE$.genericArrayOps((Object)genericArrayData.array()).map((Function1 & Serializable & scala.Serializable)s -> this.converter().apply(this.parser().parse(s.toString())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Object.class))));
        }
        if (object instanceof ArrayData) {
            ArrayData arrayData = (ArrayData)object;
            return new GenericArrayData(Predef$.MODULE$.genericArrayOps((Object)arrayData.array()).map((Function1 & Serializable & scala.Serializable)s -> this.converter().apply(this.parser().parse(s.toString())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Object.class))));
        }
        String str = ((UTF8String)xml).toString();
        return this.converter().apply(this.parser().parse(str));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        if (dataType instanceof MapType) {
            return "entries";
        }
        return super.sql();
    }

    @Override
    public String prettyName() {
        return "from_xml";
    }

    @Override
    public XmlToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public XmlToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new XmlToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "XmlToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XmlToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XmlToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        XmlToStructs xmlToStructs = (XmlToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = xmlToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = xmlToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = xmlToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = xmlToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!xmlToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(XmlOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public XmlToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public XmlToStructs(Expression child, Expression schema, Map<String, String> options) {
        this((DataType)ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public XmlToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public XmlToStructs(Expression child, Expression schema, Expression options) {
        this((DataType)ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

