/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.WindowTime$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(window_column) - Extract the time value from time/session window column which can be used for event time value of window.\n      The extracted time is (window.end - 1) which reflects the fact that the aggregating\n      windows have exclusive upper bound - [start, end)\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#window-operations-on-event-time\">'Window Operations on Event Time'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * window_column - The column representing time/session window.\n  ", examples="\n    Examples:\n      > SELECT a, window.start as start, window.end as end, _FUNC_(window), cnt FROM (SELECT a, window, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, window(b, '5 minutes') ORDER BY a, window.start);\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2021-01-01 00:04:59.999999\t2\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:10:00\t2021-01-01 00:09:59.999999\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2021-01-01 00:04:59.999999\t1\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\")a\t\u0001C\u0001\u000f\")!\n\u0001C!\u0003\")1\n\u0001C!\u0019\")q\f\u0001C!A\"9A\r\u0001b\u0001\n\u000b*\u0007B\u0002?\u0001A\u00035a\rC\u0003~\u0001\u0011\u0005c\u0010\u0003\u0006\u0002\u0010\u0001A)\u0019!C!\u0003#Aq!!\u0007\u0001\t#\nY\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003\u007f\u0001\u0011\u0011!C!\u0003\u0003B\u0011\"!\u0015\u0001\u0003\u0003%\t!a\u0015\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0003\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\u001eI\u00111\u0016\u000f\u0002\u0002#\u0005\u0011Q\u0016\u0004\t7q\t\t\u0011#\u0001\u00020\"1a)\u0006C\u0001\u0003{C\u0011\"a0\u0016\u0003\u0003%)%!1\t\u0013\u0005\rW#!A\u0005\u0002\u0006\u0015\u0007\"CAe+\u0005\u0005I\u0011QAf\u0011%\t9.FA\u0001\n\u0013\tIN\u0001\u0006XS:$wn\u001e+j[\u0016T!!\b\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\b\u0001)r\u0013\u0007N\u001c>!\tYC&D\u0001\u001d\u0013\tiCDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYs&\u0003\u000219\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002,e%\u00111\u0007\b\u0002\f+:,g/\u00197vC\ndW\r\u0005\u0002,k%\u0011a\u0007\b\u0002\u0011\u001d>t7+\u0015'FqB\u0014Xm]:j_:\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00029}%\u0011q(\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ro&tGm\\<D_2,XN\\\u000b\u0002\u0005B\u00111fQ\u0005\u0003\tr\u0011!\"\u0012=qe\u0016\u001c8/[8o\u000359\u0018N\u001c3po\u000e{G.^7oA\u00051A(\u001b8jiz\"\"\u0001S%\u0011\u0005-\u0002\u0001\"\u0002!\u0004\u0001\u0004\u0011\u0015!B2iS2$\u0017AC5oaV$H+\u001f9fgV\tQ\nE\u0002O-fs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005IC\u0013A\u0002\u001fs_>$h(C\u0001;\u0013\t)\u0016(A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&aA*fc*\u0011Q+\u000f\t\u00035vk\u0011a\u0017\u0006\u00039\u0002\nQ\u0001^=qKNL!AX.\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0005\u0004\"A\u00172\n\u0005\r\\&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199|G-\u001a)biR,'O\\:\u0016\u0003\u0019\u00042A\u0014,h!\tA\u0017P\u0004\u0002jm:\u0011!\u000e\u001e\b\u0003WNt!\u0001\u001c:\u000f\u00055\fhB\u00018q\u001d\t\u0001v.C\u0001(\u0013\t)c%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003?\u0001J!!\u001e\u0010\u0002\u000bQ\u0014X-Z:\n\u0005]D\u0018a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T!!\u001e\u0010\n\u0005i\\(a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T!a\u001e=\u0002\u001b9|G-\u001a)biR,'O\\:!\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u007fB!\u0011\u0011AA\u0005\u001d\u0011\t\u0019!!\u0002\u0011\u0005AK\u0014bAA\u0004s\u00051\u0001K]3eK\u001aLA!a\u0003\u0002\u000e\t11\u000b\u001e:j]\u001eT1!a\u0002:\u0003!\u0011Xm]8mm\u0016$WCAA\n!\rA\u0014QC\u0005\u0004\u0003/I$a\u0002\"p_2,\u0017M\\\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007!\u000bi\u0002\u0003\u0004\u0002 -\u0001\rAQ\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\rA\u0015Q\u0005\u0005\b\u00012\u0001\n\u00111\u0001C\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000b+\u0007\t\u000bic\u000b\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C;oG\",7m[3e\u0015\r\tI$O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001f\u0003g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\t\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!a\u0003\u0002H\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000b\t\u0004q\u0005]\u0013bAA-s\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qLA3!\rA\u0014\u0011M\u0005\u0004\u0003GJ$aA!os\"I\u0011q\r\t\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0004CBA8\u0003k\ny&\u0004\u0002\u0002r)\u0019\u00111O\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002x\u0005E$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0005\u0002~!I\u0011q\r\n\u0002\u0002\u0003\u0007\u0011qL\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u00111\u0011\u0005\n\u0003O\u001a\u0012\u0011!a\u0001\u0003?Bs\u0003AAD\u0003\u001b\u000by)a%\u0002\u0016\u0006e\u00151TAP\u0003C\u000b)+a*\u0011\u0007-\nI)C\u0002\u0002\fr\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0012\u0006!iB\u0003\u0011!A\u0001zf)\u0016(D?\":\u0018N\u001c3po~\u001bw\u000e\\;n]&\u0002S\u0006I#yiJ\f7\r\u001e\u0011uQ\u0016\u0004C/[7fAY\fG.^3!MJ|W\u000e\t;j[\u0016|3/Z:tS>t\u0007e^5oI><\beY8mk6t\u0007e\u001e5jG\"\u00043-\u00198!E\u0016\u0004So]3eA\u0019|'\u000fI3wK:$\b\u0005^5nK\u00022\u0018\r\\;fA=4\u0007e^5oI><hF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0015DHO]1di\u0016$\u0007\u0005^5nK\u0002J7\u000f\t\u0015xS:$wn\u001e\u0018f]\u0012\u0004S\u0006I\u0019*A]D\u0017n\u00195!e\u00164G.Z2ug\u0002\"\b.\u001a\u0011gC\u000e$\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011bO\u001e\u0014XmZ1uS:<'\u0002\t\u0011!A\u0001\u0002s/\u001b8e_^\u001c\b\u0005[1wK\u0002*\u0007p\u00197vg&4X\rI;qa\u0016\u0014\bEY8v]\u0012\u0004S\u0006I.ti\u0006\u0014H\u000f\f\u0011f]\u0012L#\u0002\t\u0011!A\u0001\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf\u001d;sk\u000e$XO]3e[M$(/Z1nS:<W\u0006\u001d:pOJ\fW.\\5oO6:W/\u001b3f]!$X\u000e\\\u0012xS:$wn^\u0017pa\u0016\u0014\u0018\r^5p]NlsN\\\u0017fm\u0016tG/\f;j[\u0016\u0014chJ,j]\u0012|w\u000fI(qKJ\fG/[8og\u0002zg\u000eI#wK:$\b\u0005V5nK\u001ebt&\u0019 !S:\u00043\u000b\u001e:vGR,(/\u001a3!'R\u0014X-Y7j]\u001e\u0004s-^5eK\u0002\"wn\u0019\u0011g_J\u0004C-\u001a;bS2,G\rI3ya2\fg.\u0019;j_:\u0004\u0013M\u001c3!Kb\fW\u000e\u001d7fg:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a&\u0002/*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e^5oI><xlY8mk6t\u0007%\f\u0011UQ\u0016\u00043m\u001c7v[:\u0004#/\u001a9sKN,g\u000e^5oO\u0002\"\u0018.\\30g\u0016\u001c8/[8oA]Lg\u000eZ8x])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti*\u0001CL\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006I<j]\u0012|wOL:uCJ$\b%Y:!gR\f'\u000f\u001e\u0017!o&tGm\\</K:$\u0007%Y:!K:$G\u0006I0G+:\u001bu\fK<j]\u0012|w/\u000b\u0017!G:$\bE\u0012*P\u001b\u0002B3+\u0012'F\u0007R\u0003\u0013\r\f\u0011xS:$wn\u001e\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aYR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJ\u0003%Q*!i\u0006\u0014\u0007&\u0019\u0017!E&\u0002sIU(V!\u0002\u0012\u0017\u0010I1-A]Lg\u000eZ8xQ\td\u0003eJ\u001b![&tW\u000f^3tO%\u0002sJ\u0015#F%\u0002\u0012\u0015\fI1-A]Lg\u000eZ8x]M$\u0018M\u001d;*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;ker\u0013(O\u001d:seJ!G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002TG\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aeRT'\u000f\u0018:seJ\u0014(O\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\u000e\u001e6s9J\u0014(O\u001d:s%\t$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0016A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003S\u000bQa\r\u00185]A\n!bV5oI><H+[7f!\tYSc\u0005\u0003\u0016\u0003ck\u0004CBAZ\u0003s\u0013\u0005*\u0004\u0002\u00026*\u0019\u0011qW\u001d\u0002\u000fI,h\u000e^5nK&!\u00111XA[\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003[\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\nQ!\u00199qYf$2\u0001SAd\u0011\u0015\u0001\u0005\u00041\u0001C\u0003\u001d)h.\u00199qYf$B!!4\u0002TB!\u0001(a4C\u0013\r\t\t.\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005U\u0017$!AA\u0002!\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0007\u0003BA#\u0003;LA!a8\u0002H\t1qJ\u00196fGR\u0004")
public class WindowTime
extends UnaryExpression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression windowColumn;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Expression> unapply(WindowTime windowTime) {
        return WindowTime$.MODULE$.unapply(windowTime);
    }

    public static <A> Function1<Expression, A> andThen(Function1<WindowTime, A> function1) {
        return WindowTime$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, WindowTime> compose(Function1<A, Expression> function1) {
        return WindowTime$.MODULE$.compose(function1);
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression windowColumn() {
        return this.windowColumn;
    }

    @Override
    public Expression child() {
        return this.windowColumn();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StructType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return ((StructField)((StructType)this.child().dataType()).head()).dataType();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String prettyName() {
        return "window_time";
    }

    private boolean resolved$lzycompute() {
        WindowTime windowTime = this;
        synchronized (windowTime) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public WindowTime withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public WindowTime copy(Expression windowColumn) {
        return new WindowTime(windowColumn);
    }

    public Expression copy$default$1() {
        return this.windowColumn();
    }

    @Override
    public String productPrefix() {
        return "WindowTime";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.windowColumn();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WindowTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WindowTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        WindowTime windowTime = (WindowTime)x$1;
        Expression expression = this.windowColumn();
        Expression expression2 = windowTime.windowColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!windowTime.canEqual(this)) return false;
        return true;
    }

    public WindowTime(Expression windowColumn) {
        this.windowColumn = windowColumn;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.WINDOW_TIME(), (List)Nil$.MODULE$);
    }
}

