/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Encode;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToBinary$;
import org.apache.spark.sql.catalyst.expressions.UnBase64;
import org.apache.spark.sql.catalyst.expressions.Unhex;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str[, fmt]) - Converts the input `str` to a binary value based on the supplied `fmt`.\n      `fmt` can be a case-insensitive string literal of \"hex\", \"utf-8\", \"utf8\", or \"base64\".\n      By default, the binary format for conversion is \"hex\" if `fmt` is omitted.\n      The function returns NULL if at least one of the input parameters is NULL.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001\u0002\u0013&\u0001JB\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005g!A\u0011\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005O\u0001\tE\t\u0015!\u0003L\u0011!y\u0005A!f\u0001\n\u0003\u0001\u0006\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B)\t\u000bU\u0003A\u0011\u0001,\t\u0011m\u0003\u0001R1A\u0005\u0002qC\u0001\u0002\u001c\u0001\t\u0006\u0004%\te\u0012\u0005\u0006+\u0002!\t!\u001c\u0005\u0006+\u0002!\ta\u001c\u0005\u0006e\u0002!\t\u0005\u0018\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006}\u0002!\te \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\ty\u0002\u0001C)\u0003CA\u0011\"!\f\u0001\u0003\u0003%\t!a\f\t\u0013\u0005]\u0002!%A\u0005\u0002\u0005e\u0002\"CA(\u0001E\u0005I\u0011AA)\u0011%\t)\u0006AI\u0001\n\u0003\t9\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0011\u0002^!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003o\u0002\u0011\u0011!C\u0001\u0003sB\u0011\"!\"\u0001\u0003\u0003%\t%a\"\t\u0013\u0005U\u0005!!A\u0005\u0002\u0005]\u0005\"CAN\u0001\u0005\u0005I\u0011IAO\u000f%\t\t-JA\u0001\u0012\u0003\t\u0019M\u0002\u0005%K\u0005\u0005\t\u0012AAc\u0011\u0019)F\u0004\"\u0001\u0002T\"I\u0011Q\u001b\u000f\u0002\u0002\u0013\u0015\u0013q\u001b\u0005\n\u00033d\u0012\u0011!CA\u00037D\u0011\"a9\u001d#\u0003%\t!a\u0016\t\u0013\u0005\u0015H$!A\u0005\u0002\u0006\u001d\b\"CA{9E\u0005I\u0011AA,\u0011%\t9\u0010HA\u0001\n\u0013\tIP\u0001\u0005U_\nKg.\u0019:z\u0015\t1s%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011C\u0002\u00014oij4\t\u0005\u00025k5\tQ%\u0003\u00027K\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005QB\u0014BA\u001d&\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005QZ\u0014B\u0001\u001f&\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$a\u0002)s_\u0012,8\r\u001e\t\u0003}\u0011K!!R \u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t\u0015D\bO]\u000b\u0002g\u0005)Q\r\u001f9sA\u00051am\u001c:nCR,\u0012a\u0013\t\u0004}1\u001b\u0014BA'@\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013a\u00058vY2|e.\u00138wC2LGMR8s[\u0006$X#A)\u0011\u0005y\u0012\u0016BA*@\u0005\u001d\u0011un\u001c7fC:\fAC\\;mY>s\u0017J\u001c<bY&$gi\u001c:nCR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003X1fS\u0006C\u0001\u001b\u0001\u0011\u00151u\u00011\u00014\u0011\u0015Iu\u00011\u0001L\u0011\u001dyu\u0001%AA\u0002E\u000b1AZ7u+\u0005i\u0006C\u00010f\u001d\ty6\r\u0005\u0002a\u007f5\t\u0011M\u0003\u0002cc\u00051AH]8pizJ!\u0001Z \u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003I~B#\u0001C5\u0011\u0005yR\u0017BA6@\u0005%!(/\u00198tS\u0016tG/A\u0006sKBd\u0017mY3nK:$HCA,o\u0011\u00151%\u00021\u00014)\r9\u0006/\u001d\u0005\u0006\r.\u0001\ra\r\u0005\u0006\u0013.\u0001\raM\u0001\u000baJ,G\u000f^=OC6,\u0017\u0001C2iS2$'/\u001a8\u0016\u0003U\u00042A^>4\u001d\t9\u0018P\u0004\u0002aq&\t\u0001)\u0003\u0002{\u007f\u00059\u0001/Y2lC\u001e,\u0017B\u0001?~\u0005\r\u0019V-\u001d\u0006\u0003u~\n!\"\u001b8qkR$\u0016\u0010]3t+\t\t\t\u0001\u0005\u0003ww\u0006\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0011&A\u0003usB,7/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbJ\u0001\tC:\fG._:jg&!\u0011QDA\f\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u0019\u00141\u0005\u0005\b\u0003K\u0001\u0002\u0019AA\u0014\u0003-qWm^\"iS2$'/\u001a8\u0011\tY\fIcM\u0005\u0004\u0003Wi(AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u001d9\u0016\u0011GA\u001a\u0003kAqAR\t\u0011\u0002\u0003\u00071\u0007C\u0004J#A\u0005\t\u0019A&\t\u000f=\u000b\u0002\u0013!a\u0001#\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001eU\r\u0019\u0014QH\u0016\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011J \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA*U\rY\u0015QH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tIFK\u0002R\u0003{\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA\u0001\\1oO*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-C\u0002g\u0003G\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001d\u0011\u0007y\n\u0019(C\u0002\u0002v}\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001f\u0002\u0002B\u0019a(! \n\u0007\u0005}tHA\u0002B]fD\u0011\"a!\u0018\u0003\u0003\u0005\r!!\u001d\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\t\u0005\u0004\u0002\f\u0006E\u00151P\u0007\u0003\u0003\u001bS1!a$@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\u000biI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA)\u0002\u001a\"I\u00111Q\r\u0002\u0002\u0003\u0007\u00111P\u0001\u0007KF,\u0018\r\\:\u0015\u0007E\u000by\nC\u0005\u0002\u0004j\t\t\u00111\u0001\u0002|!\u001a\u0002!a)\u0002*\u0006-\u0016qVAY\u0003k\u000b9,a/\u0002>B\u0019A'!*\n\u0007\u0005\u001dVEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u00055\u0016Aa2\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;s72\u0002c-\u001c;^S\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\u00027\u000f\u001e:aAQ|\u0007%\u0019\u0011cS:\f'/\u001f\u0011wC2,X\r\t2bg\u0016$\u0007e\u001c8!i\",\u0007e];qa2LW\r\u001a\u0011aM6$\bM\f\u0006!A\u0001\u0002\u0003\u0005\t1g[R\u0004\u0007eY1oA\t,\u0007%\u0019\u0011dCN,W&\u001b8tK:\u001c\u0018\u000e^5wK\u0002\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u0004sN\u001a\u0011#Q\u0016D(\u0005\f\u0011#kR4W\u0006\u000f\u0012-A\t*HO\u001a\u001d#Y\u0001z'\u000f\t\u0012cCN,g\u0007\u000e\u0012/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0005f\u0004C-\u001a4bk2$H\u0006\t;iK\u0002\u0012\u0017N\\1ss\u00022wN]7bi\u00022wN\u001d\u0011d_:4XM]:j_:\u0004\u0013n\u001d\u0011#Q\u0016D(\u0005I5gA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$gF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\rI1uA1,\u0017m\u001d;!_:,\u0007e\u001c4!i\",\u0007%\u001b8qkR\u0004\u0003/\u0019:b[\u0016$XM]:!SN\u0004c*\u0016'M])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019,A\"\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'mY\u0014-A\u001d*HOZ\u00179O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u00192d\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA]\u0003\u0015\u0019df\r\u00181\u0003\u00159'o\\;qC\t\ty,\u0001\u0007tiJLgnZ0gk:\u001c7/\u0001\u0005U_\nKg.\u0019:z!\t!Dd\u0005\u0003\u001d\u0003\u000f\u001c\u0005\u0003CAe\u0003\u001f\u001c4*U,\u000e\u0005\u0005-'bAAg\u007f\u00059!/\u001e8uS6,\u0017\u0002BAi\u0003\u0017\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\t\u0019-\u0001\u0005u_N#(/\u001b8h)\t\ty&A\u0003baBd\u0017\u0010F\u0004X\u0003;\fy.!9\t\u000b\u0019{\u0002\u0019A\u001a\t\u000b%{\u0002\u0019A&\t\u000f={\u0002\u0013!a\u0001#\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0018\u0011\u001f\t\u0005}1\u000bY\u000f\u0005\u0004?\u0003[\u001c4*U\u0005\u0004\u0003_|$A\u0002+va2,7\u0007\u0003\u0005\u0002t\u0006\n\t\u00111\u0001X\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003w\u0004B!!\u0019\u0002~&!\u0011q`A2\u0005\u0019y%M[3di\u0002")
public class ToBinary
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
scala.Serializable {
    private transient String fmt;
    private Expression replacement;
    private final Expression expr;
    private final Option<Expression> format;
    private final boolean nullOnInvalidFormat;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return ToBinary$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Option<Expression>, Object>> unapply(ToBinary toBinary) {
        return ToBinary$.MODULE$.unapply(toBinary);
    }

    public static boolean apply$default$3() {
        return ToBinary$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Object>, ToBinary> tupled() {
        return ToBinary$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, ToBinary>>> curried() {
        return ToBinary$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression expr() {
        return this.expr;
    }

    public Option<Expression> format() {
        return this.format;
    }

    public boolean nullOnInvalidFormat() {
        return this.nullOnInvalidFormat;
    }

    private String fmt$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if (!this.bitmap$trans$0) {
                this.fmt = (String)this.format().map((Function1 & Serializable & scala.Serializable)f -> {
                    Object value = f.eval(f.eval$default$1());
                    if (value == null) {
                        return null;
                    }
                    return ((UTF8String)value).toString().toLowerCase(Locale.ROOT);
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "hex");
                this.bitmap$trans$0 = true;
            }
        }
        return this.fmt;
    }

    public String fmt() {
        if (!this.bitmap$trans$0) {
            return this.fmt$lzycompute();
        }
        return this.fmt;
    }

    private Expression replacement$lzycompute() {
        ToBinary toBinary = this;
        synchronized (toBinary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String string;
                this.replacement = this.fmt() == null ? new Literal(null, (DataType)BinaryType$.MODULE$) : ("hex".equals(string = this.fmt()) ? new Unhex(this.expr(), true) : (("utf-8".equals(string) ? true : "utf8".equals(string)) ? new Encode(this.expr(), Literal$.MODULE$.apply("UTF-8")) : ("base64".equals(string) ? new UnBase64(this.expr(), true) : new Literal(null, (DataType)BinaryType$.MODULE$))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_binary";
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.expr();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$43 -> StringType$.MODULE$, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        block5: {
            Expression f;
            block6: {
                block7: {
                    Option<Expression> option = this.format();
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    f = (Expression)some.value();
                    if (!f.foldable()) break block6;
                    DataType dataType = f.dataType();
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType == null ? stringType$ != null : !dataType.equals(stringType$))) break block7;
                    DataType dataType2 = f.dataType();
                    NullType$ nullType$ = NullType$.MODULE$;
                    if (dataType2 != null ? !dataType2.equals(nullType$) : nullType$ != null) break block6;
                }
                if (this.isValidFormat$1() || this.nullOnInvalidFormat()) {
                    return ExpectsInputTypes.checkInputDataTypes$(this);
                }
                return new TypeCheckResult.DataTypeMismatch("INVALID_ARG_VALUE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"fmt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requireType"), (Object)new StringBuilder(17).append("case-insensitive ").append(Cast$.MODULE$.toSQLType((AbstractDataType)StringType$.MODULE$)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"validValues"), (Object)"'hex', 'utf-8', 'utf8', or 'base64'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputValue"), (Object)Cast$.MODULE$.toSQLValue(this.fmt(), (DataType)StringType$.MODULE$))}))));
            }
            if (!f.foldable()) {
                return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("fmt")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(f))}))));
            }
            return new TypeCheckResult.DataTypeMismatch("INVALID_ARG_VALUE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"fmt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requireType"), (Object)new StringBuilder(17).append("case-insensitive ").append(Cast$.MODULE$.toSQLType((AbstractDataType)StringType$.MODULE$)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"validValues"), (Object)"'hex', 'utf-8', 'utf8', or 'base64'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputValue"), (Object)Cast$.MODULE$.toSQLValue(f.eval(f.eval$default$1()), f.dataType()))}))));
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3());
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3());
    }

    public ToBinary copy(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        return new ToBinary(expr, format, nullOnInvalidFormat);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public boolean copy$default$3() {
        return this.nullOnInvalidFormat();
    }

    @Override
    public String productPrefix() {
        return "ToBinary";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.nullOnInvalidFormat());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToBinary;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToBinary)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToBinary toBinary = (ToBinary)x$1;
        Expression expression = this.expr();
        Expression expression2 = toBinary.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = toBinary.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.nullOnInvalidFormat() != toBinary.nullOnInvalidFormat()) return false;
        if (!toBinary.canEqual(this)) return false;
        return true;
    }

    private final boolean isValidFormat$1() {
        return this.fmt() == null || ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hex", "utf-8", "utf8", "base64"}))).contains((Object)this.fmt());
    }

    public ToBinary(Expression expr, Option<Expression> format, boolean nullOnInvalidFormat) {
        this.expr = expr;
        this.format = format;
        this.nullOnInvalidFormat = nullOnInvalidFormat;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ToBinary(Expression expr) {
        this(expr, (Option<Expression>)None$.MODULE$, false);
    }

    public ToBinary(Expression expr, Expression format) {
        this(expr, (Option<Expression>)new Some((Object)format), false);
    }
}

