/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NthValue$;
import org.apache.spark.sql.catalyst.expressions.OffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset]) - Returns the value of `input` at the row that is the `offset`th row\n      from beginning of the window frame. Offset starts at 1. If ignoreNulls=true, we will skip\n      nulls when finding the `offset`th row. Otherwise, every row counts for the `offset`. If\n      there is no such an `offset`th row (e.g., when the offset is 10, size of the window frame\n      is less than 10), null is returned.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b, 2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", arguments="\n    Arguments:\n      * input - the target column or expression that the function operates on.\n      * offset - a positive int literal to indicate the offset in the window frame. It starts\n          with 1.\n      * ignoreNulls - an optional specification that indicates the NthValue should skip null\n          values in the determination of which row to use.\n  ", since="3.1.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001\u0002\u0017.\u0001jB\u0001\"\u0018\u0001\u0003\u0016\u0004%\tA\u0018\u0005\t?\u0002\u0011\t\u0012)A\u0005\u0017\"A\u0001\r\u0001BK\u0002\u0013\u0005a\f\u0003\u0005b\u0001\tE\t\u0015!\u0003L\u0011!\u0011\u0007A!f\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011\u00023\t\u000b!\u0004A\u0011A5\t\u000b!\u0004A\u0011\u00018\t\u0011I\u0004\u0001R1A\u0005BMDQa\u001e\u0001\u0005ByCQ\u0001\u001f\u0001\u0005ByCq!\u001f\u0001C\u0002\u0013\u0005#\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001f\u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002BCA!\u0001!\u0015\r\u0011\"\u0003\u0002D!Q\u00111\n\u0001\t\u0006\u0004%I!!\u0014\t\u0015\u0005U\u0003\u0001#b\u0001\n\u0013\ti\u0005\u0003\u0006\u0002X\u0001A)\u0019!C!\u00033B!\"!\u0018\u0001\u0011\u000b\u0007I\u0011IA0\u0011)\t\u0019\u0007\u0001EC\u0002\u0013\u0005\u0013Q\r\u0005\u000b\u0003S\u0002\u0001R1A\u0005B\u00055\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\u0007e\u0001!\t%!\u001c\t\u000f\u0005}\u0004\u0001\"\u0015\u0002\u0002\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003+\u0003\u0011\u0013!C\u0001\u0003/C\u0011\"!,\u0001#\u0003%\t!a&\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005E\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u0011%\t9\rAA\u0001\n\u0003\tI\rC\u0005\u0002R\u0002\t\t\u0011\"\u0001\u0002T\"I\u0011q\u001c\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001d\u0005\n\u0003_\u0004\u0011\u0011!C\u0001\u0003cD\u0011\"!>\u0001\u0003\u0003%\t%a>\b\u0013\t\u0005R&!A\t\u0002\t\rb\u0001\u0003\u0017.\u0003\u0003E\tA!\n\t\r!4C\u0011\u0001B\u001a\u0011%\u0011)DJA\u0001\n\u000b\u00129\u0004C\u0005\u0003:\u0019\n\t\u0011\"!\u0003<!I!1\t\u0014\u0002\u0002\u0013\u0005%Q\t\u0005\n\u0005/2\u0013\u0011!C\u0005\u00053\u0012\u0001B\u0014;i-\u0006dW/\u001a\u0006\u0003]=\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001'M\u0001\tG\u0006$\u0018\r\\=ti*\u0011!gM\u0001\u0004gFd'B\u0001\u001b6\u0003\u0015\u0019\b/\u0019:l\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\u0004\u0001MA\u0001aO C\u000b:#&\f\u0005\u0002={5\tQ&\u0003\u0002?[\t9\u0012iZ4sK\u001e\fG/Z,j]\u0012|wOR;oGRLwN\u001c\t\u0003y\u0001K!!Q\u0017\u0003)=3gm]3u/&tGm\\<Gk:\u001cG/[8o!\ta4)\u0003\u0002E[\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002G\u0013.k\u0011a\u0012\u0006\u0003\u0011>\nQ\u0001\u001e:fKNL!AS$\u0003\u0015\tKg.\u0019:z\u0019&\\W\r\u0005\u0002=\u0019&\u0011Q*\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA(S\u001b\u0005\u0001&BA)2\u0003\u0019)'O]8sg&\u00111\u000b\u0015\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011Q\u000bW\u0007\u0002-*\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\n9\u0001K]8ek\u000e$\bCA+\\\u0013\tafK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003j]B,H/F\u0001L\u0003\u0019Ig\u000e];uA\u00051qN\u001a4tKR\fqa\u001c4gg\u0016$\b%A\u0006jO:|'/\u001a(vY2\u001cX#\u00013\u0011\u0005U+\u0017B\u00014W\u0005\u001d\u0011un\u001c7fC:\fA\"[4o_J,g*\u001e7mg\u0002\na\u0001P5oSRtD\u0003\u00026lY6\u0004\"\u0001\u0010\u0001\t\u000bu;\u0001\u0019A&\t\u000b\u0001<\u0001\u0019A&\t\u000b\t<\u0001\u0019\u00013\u0015\u0007)|\u0017\u000fC\u0003q\u0011\u0001\u00071*A\u0003dQ&dG\rC\u0003a\u0011\u0001\u00071*A\u0004eK\u001a\fW\u000f\u001c;\u0016\u0003Q\u0004\"\u0001P;\n\u0005Yl#a\u0002'ji\u0016\u0014\u0018\r\\\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/A\u0003ge\u0006lW-F\u0001|!\taD0\u0003\u0002~[\tYq+\u001b8e_^4%/Y7f\u0003\u00191'/Y7fA\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nE\nQ\u0001^=qKNLA!!\u0004\u0002\b\tAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\"!a\u0005\u0011\r\u0005U\u0011QEA\u0016\u001d\u0011\t9\"!\t\u000f\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b:\u0003\u0019a$o\\8u}%\tq+C\u0002\u0002$Y\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\u0005%\"aA*fc*\u0019\u00111\u0005,\u0011\t\u0005\u0015\u0011QF\u0005\u0005\u0003_\t9A\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u0018\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u0010\u0002:\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0005pM\u001a\u001cX\r\u001e,bYV\u0011\u0011Q\t\t\u0004+\u0006\u001d\u0013bAA%-\n!Aj\u001c8h\u0003\u0019\u0011Xm];miV\u0011\u0011q\n\t\u0004y\u0005E\u0013bAA*[\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003\u0015\u0019w.\u001e8u\u0003M\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t+\t\tY\u0006\u0005\u0004\u0002\u0016\u0005\u0015\u0012qJ\u0001\u000eS:LG/[1m-\u0006dW/Z:\u0016\u0005\u0005\u0005\u0004#BA\u000b\u0003K!\u0018!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8ogV\u0011\u0011q\r\t\u0006\u0003+\t)cS\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u001c\u0011\t\u0005E\u0014\u0011\u0010\b\u0005\u0003g\n)\bE\u0002\u0002\u001aYK1!a\u001eW\u0003\u0019\u0001&/\u001a3fM&!\u00111PA?\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u000f,\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00026\u0002\u0004\u0006\u001d\u0005BBAC5\u0001\u00071*A\u0004oK^dUM\u001a;\t\r\u0005%%\u00041\u0001L\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$rA[AH\u0003#\u000b\u0019\nC\u0004^7A\u0005\t\u0019A&\t\u000f\u0001\\\u0002\u0013!a\u0001\u0017\"9!m\u0007I\u0001\u0002\u0004!\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00033S3aSANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'bAAT-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019LK\u0002e\u00037\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fA\u0001\\1oO*\u0011\u00111Y\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\u0005u\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAf!\r)\u0016QZ\u0005\u0004\u0003\u001f4&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAk\u00037\u00042!VAl\u0013\r\tIN\u0016\u0002\u0004\u0003:L\b\"CAoC\u0005\u0005\t\u0019AAf\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001d\t\u0007\u0003K\fY/!6\u000e\u0005\u0005\u001d(bAAu-\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0018q\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002e\u0003gD\u0011\"!8$\u0003\u0003\u0005\r!!6\u0002\r\u0015\fX/\u00197t)\r!\u0017\u0011 \u0005\n\u0003;$\u0013\u0011!a\u0001\u0003+Ds\u0003AA\u007f\u0005\u0007\u0011)A!\u0003\u0003\f\t=!\u0011\u0003B\u000b\u0005/\u0011YB!\b\u0011\u0007q\ny0C\u0002\u0003\u00025\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\b\u0005\u0019IF\u0003\u0011!A\u0001zf)\u0016(D?\"Jg\u000e];u72\u0002sN\u001a4tKRl\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t<bYV,\u0007e\u001c4!A&t\u0007/\u001e;aA\u0005$\b\u0005\u001e5fAI|w\u000f\t;iCR\u0004\u0013n\u001d\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><(\u0002\t\u0011!A\u0001\u0002cM]8nA\t,w-\u001b8oS:<\u0007e\u001c4!i\",\u0007e^5oI><\bE\u001a:b[\u0016t\u0003e\u00144gg\u0016$\be\u001d;beR\u001c\b%\u0019;!c9\u0002\u0013J\u001a\u0011jO:|'/\u001a(vY2\u001cX\b\u001e:vK2\u0002s/\u001a\u0011xS2d\u0007e]6ja*\u0001\u0003\u0005\t\u0011!A9,H\u000e\\:!o\",g\u000e\t4j]\u0012Lgn\u001a\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><h\u0006I(uQ\u0016\u0014x/[:fY\u0001*g/\u001a:zAI|w\u000fI2pk:$8\u000f\t4pe\u0002\"\b.\u001a\u0011a_\u001a47/\u001a;a]\u0001JeM\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5fe\u0016\u0004\u0013n\u001d\u0011o_\u0002\u001aXo\u00195!C:\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><\b\u0005K3/O:b\u0003e\u001e5f]\u0002\"\b.\u001a\u0011pM\u001a\u001cX\r\u001e\u0011jg\u0002\n\u0004\u0007\f\u0011tSj,\u0007e\u001c4!i\",\u0007e^5oI><\bE\u001a:b[\u0016T\u0001\u0005\t\u0011!A\u0001J7\u000f\t7fgN\u0004C\u000f[1oAE\u0002\u0014\u0006\f\u0011ok2d\u0007%[:!e\u0016$XO\u001d8fI:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QB\u0001\u0002$*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\r\f\u0011cY\u0001zf)\u0016(D?\"\u0012G\u0006\t\u001a*A=3VI\u0015\u0011)!\u0006\u0013F+\u0013+J\u001f:\u0003#)\u0017\u0011bA=\u0013F)\u0012*!\u0005f\u0003#-\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003EM\u0015-A!:\u0013)M\u0014-AEJC\u0006\t\u0015(\u0003J:C\u0006I\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\t;bE\"\nG\u0006\t2*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n%'C\u001a\n\u001dVcEJ\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0003\u0014\u0005\u0011\u0019N\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!S:\u0004X\u000f\u001e\u0011.AQDW\r\t;be\u001e,G\u000fI2pYVlg\u000eI8sA\u0015D\bO]3tg&|g\u000e\t;iCR\u0004C\u000f[3!MVt7\r^5p]\u0002z\u0007/\u001a:bi\u0016\u001c\be\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001zgMZ:fi\u0002j\u0003%\u0019\u0011q_NLG/\u001b<fA%tG\u000f\t7ji\u0016\u0014\u0018\r\u001c\u0011u_\u0002Jg\u000eZ5dCR,\u0007\u0005\u001e5fA=4gm]3uA%t\u0007\u0005\u001e5fA]Lg\u000eZ8xA\u0019\u0014\u0018-\\3/A%#\be\u001d;beR\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!o&$\b\u000eI\u0019/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001JwM\\8sK:+H\u000e\\:![\u0001\ng\u000eI8qi&|g.\u00197!gB,7-\u001b4jG\u0006$\u0018n\u001c8!i\"\fG\u000fI5oI&\u001c\u0017\r^3tAQDW\r\t(uQZ\u000bG.^3!g\"|W\u000f\u001c3!g.L\u0007\u000f\t8vY2T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011wC2,Xm\u001d\u0011j]\u0002\"\b.\u001a\u0011eKR,'/\\5oCRLwN\u001c\u0011pM\u0002:\b.[2iAI|w\u000f\t;pAU\u001cXM\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012!\u0011D\u0001\u0006g9\nd\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005?\tAb^5oI><xLZ;oGN\f\u0001B\u0014;i-\u0006dW/\u001a\t\u0003y\u0019\u001aBA\nB\u00145BA!\u0011\u0006B\u0018\u0017.#'.\u0004\u0002\u0003,)\u0019!Q\u0006,\u0002\u000fI,h\u000e^5nK&!!\u0011\u0007B\u0016\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005G\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003s\u000bQ!\u00199qYf$rA\u001bB\u001f\u0005\u007f\u0011\t\u0005C\u0003^S\u0001\u00071\nC\u0003aS\u0001\u00071\nC\u0003cS\u0001\u0007A-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u001d#1\u000b\t\u0006+\n%#QJ\u0005\u0004\u0005\u00172&AB(qi&|g\u000e\u0005\u0004V\u0005\u001fZ5\nZ\u0005\u0004\u0005#2&A\u0002+va2,7\u0007\u0003\u0005\u0003V)\n\t\u00111\u0001k\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\\A!\u00111\u0018B/\u0013\u0011\u0011y&!0\u0003\r=\u0013'.Z2u\u0001")
public class NthValue
extends AggregateWindowFunction
implements OffsetWindowFunction,
ImplicitCastInputTypes,
BinaryLike<Expression>,
QueryErrorsBase {
    private Literal default;
    private long offsetVal;
    private AttributeReference result;
    private AttributeReference count;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private AttributeReference evaluateExpression;
    private final Expression input;
    private final Expression offset;
    private final boolean ignoreNulls;
    private final WindowFrame frame;
    private transient Seq<Expression> children;
    private SpecifiedWindowFrame fakeFrame;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NthValue nthValue) {
        return NthValue$.MODULE$.unapply(nthValue);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NthValue> tupled() {
        return NthValue$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NthValue>>> curried() {
        return NthValue$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    private SpecifiedWindowFrame fakeFrame$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.fakeFrame = OffsetWindowFunction.fakeFrame$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.fakeFrame;
    }

    @Override
    public SpecifiedWindowFrame fakeFrame() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.fakeFrame$lzycompute();
        }
        return this.fakeFrame;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    private Literal default$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 1) == 0) {
                this.default = Literal$.MODULE$.create(null, this.input().dataType());
                this.bitmap$0 |= 1;
            }
        }
        return this.default;
    }

    @Override
    public Literal default() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.default$lzycompute();
        }
        return this.default;
    }

    @Override
    public Expression left() {
        return this.input();
    }

    @Override
    public Expression right() {
        return this.offset();
    }

    @Override
    public WindowFrame frame() {
        return this.frame;
    }

    @Override
    public DataType dataType() {
        return this.input().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult check = ExpectsInputTypes.checkInputDataTypes$(this);
        if (check.isFailure()) {
            return check;
        }
        if (!this.offset().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.toSQLId("offset")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.offset().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.offset()))}))));
        }
        if (this.offsetVal() <= 0L) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"offset"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(5).append("(0, ").append(Long.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.offsetVal()), (DataType)LongType$.MODULE$))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private long offsetVal$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 2) == 0) {
                this.offsetVal = BoxesRunTime.unboxToInt((Object)this.offset().eval(this.offset().eval$default$1()));
                this.bitmap$0 |= 2;
            }
        }
        return this.offsetVal;
    }

    private long offsetVal() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.offsetVal$lzycompute();
        }
        return this.offsetVal;
    }

    private AttributeReference result$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "result";
                DataType x$2 = this.input().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.result = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.result;
    }

    private AttributeReference result() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.result$lzycompute();
        }
        return this.result;
    }

    private AttributeReference count$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
                this.count = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.count$lzycompute();
        }
        return this.count;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.result();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)new .colon.colon((Object)this.default(), (List)new .colon.colon((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal())))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNotNull()))), this.input(), this.result()), (List)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))), (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal()))), this.input(), this.result()), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.result();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "nth_value";
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.input().sql()).append(", ").append(this.offset().sql()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : "")).toString();
    }

    @Override
    public NthValue withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NthValue copy(Expression input, Expression offset, boolean ignoreNulls) {
        return new NthValue(input, offset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public boolean copy$default$3() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "NthValue";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.offset();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NthValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NthValue)) return false;
        boolean bl = true;
        if (!bl) return false;
        NthValue nthValue = (NthValue)x$1;
        Expression expression = this.input();
        Expression expression2 = nthValue.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = nthValue.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.ignoreNulls() != nthValue.ignoreNulls()) return false;
        if (!nthValue.canEqual(this)) return false;
        return true;
    }

    public NthValue(Expression input, Expression offset, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.ignoreNulls = ignoreNulls;
        OffsetWindowFunction.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.frame = UnspecifiedFrame$.MODULE$;
    }

    public NthValue(Expression child, Expression offset) {
        this(child, offset, false);
    }
}

