/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('{\"teacher\": \"Alice\", \"student\": [{\"name\": \"Bob\", \"rank\": 1}, {\"name\": \"Charlie\", \"rank\": 2}]}', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001B\u00193\u0001~B\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\t]\u0002\u0011\t\u0012)A\u0005Q\"Aq\u000e\u0001BK\u0002\u0013\u0005\u0001\u000f\u0003\u0005\u0000\u0001\tE\t\u0015!\u0003r\u0011)\t\t\u0001\u0001BK\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u0017\u0001!\u0011#Q\u0001\n\u0005\u0015\u0001BCA\u0007\u0001\tU\r\u0011\"\u0001\u0002\u0010!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!A\u0011q\u0005\u0001C\u0002\u0013\u0005q\rC\u0004\u0002*\u0001\u0001\u000b\u0011\u00025\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011Q\u0007\u0001\u0005F\u0005]\u0002bBA\r\u0001\u0011\u0005\u00111\u000f\u0005\b\u00033\u0001A\u0011AA>\u0011\u001d\tI\u0002\u0001C\u0001\u0003\u0003Cq!!#\u0001\t\u0003\nY\t\u0003\u0006\u0002\u001a\u0002A)\u0019!C\u0001\u00037C\u0011\"a4\u0001\u0005\u0004%\t!!5\t\u000f\u0005M\u0007\u0001)A\u0005y\"Q\u0011Q\u001b\u0001\t\u0006\u0004%\t!a6\t\r\u0005U\b\u0001\"\u0011h\u0011\u001d\t9\u0010\u0001C!\u0003sDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003\f\u0001!\tE!\u0004\t\r]\u0002A\u0011IAi\u0011\u001d\u00119\u0002\u0001C!\u0003#DqA!\u0007\u0001\t#\u0012Y\u0002C\u0005\u0003\"\u0001\t\t\u0011\"\u0001\u0003$!I!Q\u0006\u0001\u0012\u0002\u0013\u0005!q\u0006\u0005\n\u0005\u000b\u0002\u0011\u0013!C\u0001\u0005\u000fB\u0011Ba\u0013\u0001#\u0003%\tA!\u0014\t\u0013\tE\u0003!%A\u0005\u0002\tM\u0003\"\u0003B,\u0001\u0005\u0005I\u0011\tB-\u0011%\u0011y\u0006AA\u0001\n\u0003\u0011\t\u0007C\u0005\u0003j\u0001\t\t\u0011\"\u0001\u0003l!I!\u0011\u000f\u0001\u0002\u0002\u0013\u0005#1\u000f\u0005\n\u0005\u007f\u0002\u0011\u0011!C\u0001\u0005\u0003C\u0011B!\"\u0001\u0003\u0003%\tEa\"\b\u0013\t-&'!A\t\u0002\t5f\u0001C\u00193\u0003\u0003E\tAa,\t\u000f\u0005e\u0011\u0006\"\u0001\u0003>\"I!qX\u0015\u0002\u0002\u0013\u0015#\u0011\u0019\u0005\n\u0005\u0007L\u0013\u0011!CA\u0005\u000bD\u0011Ba4*#\u0003%\tAa\u0015\t\u0013\tE\u0017&!A\u0005\u0002\nM\u0007\"\u0003BqSE\u0005I\u0011\u0001B*\u0011%\u0011\u0019/KA\u0001\n\u0013\u0011)OA\u0007Kg>tGk\\*ueV\u001cGo\u001d\u0006\u0003gQ\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QGN\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0007O\u0001\u0004gFd'BA\u001d;\u0003\u0015\u0019\b/\u0019:l\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\u0004\u0001MI\u0001\u0001\u0011#H\u001bB;Vl\u0019\t\u0003\u0003\nk\u0011AM\u0005\u0003\u0007J\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0003\u0016K!A\u0012\u001a\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007C\u0001%L\u001b\u0005I%B\u0001&3\u0003\u001d\u0019w\u000eZ3hK:L!\u0001T%\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"!\u0011(\n\u0005=\u0013$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\u000b\u0016\b\u0003\u0003JK!a\u0015\u001a\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t\u0019&\u0007\u0005\u0002Y76\t\u0011L\u0003\u0002[m\u00051QM\u001d:peNL!\u0001X-\u0003\u001fE+XM]=FeJ|'o\u001d\"bg\u0016\u0004\"AX1\u000e\u0003}S\u0011\u0001Y\u0001\u0006g\u000e\fG.Y\u0005\u0003E~\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002_I&\u0011Qm\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007g\u000eDW-\\1\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u001c\u0002\u000bQL\b/Z:\n\u00055T'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001cX#A9\u0011\tILH\u0010 \b\u0003g^\u0004\"\u0001^0\u000e\u0003UT!A\u001e \u0002\rq\u0012xn\u001c;?\u0013\tAx,\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u00141!T1q\u0015\tAx\f\u0005\u0002s{&\u0011ap\u001f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\nQa\u00195jY\u0012,\"!!\u0002\u0011\u0007\u0005\u000b9!C\u0002\u0002\nI\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005QA/[7f5>tW-\u00133\u0016\u0005\u0005E\u0001\u0003\u00020\u0002\u0014qL1!!\u0006`\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}QQ\u0011QDA\u0010\u0003C\t\u0019#!\n\u0011\u0005\u0005\u0003\u0001\"\u00024\n\u0001\u0004A\u0007\"B8\n\u0001\u0004\t\bbBA\u0001\u0013\u0001\u0007\u0011Q\u0001\u0005\n\u0003\u001bI\u0001\u0013!a\u0001\u0003#\taB\\;mY\u0006\u0014G.Z*dQ\u0016l\u0017-A\bok2d\u0017M\u00197f'\u000eDW-\\1!\u0003!qW\u000f\u001c7bE2,WCAA\u0018!\rq\u0016\u0011G\u0005\u0004\u0003gy&a\u0002\"p_2,\u0017M\\\u0001\u0015]>$W\rU1ui\u0016\u0014hn]%oi\u0016\u0014h.\u00197\u0015\u0005\u0005e\u0002CBA\u001e\u0003\u0007\nIE\u0004\u0003\u0002>\u0005\u0005cb\u0001;\u0002@%\t\u0001-\u0003\u0002T?&!\u0011QIA$\u0005\r\u0019V-\u001d\u0006\u0003'~\u0003B!a\u0013\u0002n9!\u0011QJA4\u001d\u0011\ty%a\u0019\u000f\t\u0005E\u0013\u0011\r\b\u0005\u0003'\nyF\u0004\u0003\u0002V\u0005uc\u0002BA,\u00037r1\u0001^A-\u0013\u0005i\u0014BA\u001e=\u0013\tI$(\u0003\u00028q%\u0011QGN\u0005\u0004\u0003K\"\u0014!\u0002;sK\u0016\u001c\u0018\u0002BA5\u0003W\n1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u0011Q\r\u001b\n\t\u0005=\u0014\u0011\u000f\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002j\u0005-D\u0003CA\u000f\u0003k\n9(!\u001f\t\u000f\u0005\u0005a\u00021\u0001\u0002\u0006!1aM\u0004a\u0001\u0003\u000bAQa\u001c\bA\u0002E$b!!\b\u0002~\u0005}\u0004bBA\u0001\u001f\u0001\u0007\u0011Q\u0001\u0005\u0007M>\u0001\r!!\u0002\u0015\u0011\u0005u\u00111QAC\u0003\u000fCq!!\u0001\u0011\u0001\u0004\t)\u0001\u0003\u0004g!\u0001\u0007\u0011Q\u0001\u0005\u0007_B\u0001\r!!\u0002\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME'\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t9*!%\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005u\u0005c\u00020\u0002 \u0006\r\u0016\u0011W\u0005\u0004\u0003C{&!\u0003$v]\u000e$\u0018n\u001c82!\u0019\tY$!*\u0002*&!\u0011qUA$\u0005!IE/\u001a:bi>\u0014\b\u0003BAV\u0003[k\u0011\u0001N\u0005\u0004\u0003_#$aC%oi\u0016\u0014h.\u00197S_^\u0014R!a-d\u0003o3a!!.\u0001\u0001\u0005E&\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0006!!.\u0019<b\u0013\u0011\t)-a/\u0003\r=\u0013'.Z2uQ\r\u0011\u0012\u0011\u001a\t\u0004=\u0006-\u0017bAAg?\nIAO]1og&,g\u000e^\u0001\u0014]\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ\u000b\u0002y\u0006!b.Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sI\u0002\na\u0001]1sg\u0016\u0014XCAAm!\u0019\tY.!9\u0002f6\u0011\u0011Q\u001c\u0006\u0004\u0003?$\u0014\u0001B;uS2LA!a9\u0002^\n\tb)Y5mkJ,7+\u00194f!\u0006\u00148/\u001a:\u0011\t\u0005\u001d\u0018q^\u0007\u0003\u0003ST1a[Av\u0015\r\ti\u000fO\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005E\u0018\u0011\u001e\u0002\u000b+R3\u0005h\u0015;sS:<\u0007fA\u000b\u0002J\u0006AA-\u0019;b)f\u0004X-\u0001\u0007xSRDG+[7f5>tW\rF\u0002E\u0003wDa!!\u0004\u0018\u0001\u0004a\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002B\u0001\u0005\u000f\u00012A\u0018B\u0002\u0013\r\u0011)a\u0018\u0002\u0004\u0003:L\bb\u0002B\u00051\u0001\u0007!\u0011A\u0001\u0005UN|g.\u0001\u0006j]B,H\u000fV=qKN,\"Aa\u0004\u0011\r\u0005m\u00121\tB\t!\rI'1C\u0005\u0004\u0005+Q'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\t\u0005u!Q\u0004\u0005\b\u0005?a\u0002\u0019AA\u0003\u0003!qWm^\"iS2$\u0017\u0001B2paf$\"\"!\b\u0003&\t\u001d\"\u0011\u0006B\u0016\u0011\u001d1W\u0004%AA\u0002!Dqa\\\u000f\u0011\u0002\u0003\u0007\u0011\u000fC\u0005\u0002\u0002u\u0001\n\u00111\u0001\u0002\u0006!I\u0011QB\u000f\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tDK\u0002i\u0005gY#A!\u000e\u0011\t\t]\"\u0011I\u0007\u0003\u0005sQAAa\u000f\u0003>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u007fy\u0016AC1o]>$\u0018\r^5p]&!!1\tB\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IEK\u0002r\u0005g\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003P)\"\u0011Q\u0001B\u001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\u0016+\t\u0005E!1G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tm\u0003\u0003BA]\u0005;J1A`A^\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\u0019\u0007E\u0002_\u0005KJ1Aa\u001a`\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tA!\u001c\t\u0013\t=D%!AA\u0002\t\r\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003vA1!q\u000fB?\u0005\u0003i!A!\u001f\u000b\u0007\tmt,\u0001\u0006d_2dWm\u0019;j_:LA!a*\u0003z\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u00020\t\r\u0005\"\u0003B8M\u0005\u0005\t\u0019\u0001B\u0001\u0003\u0019)\u0017/^1mgR!\u0011q\u0006BE\u0011%\u0011ygJA\u0001\u0002\u0004\u0011\t\u0001K\n\u0001\u0005\u001b\u0013\u0019J!&\u0003\u001a\nm%q\u0014BQ\u0005K\u00139\u000bE\u0002B\u0005\u001fK1A!%3\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa&\u0002E~3UKT\"`Q)\u001cxN\\*ue2\u00023o\u00195f[\u0006\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011tiJ,8\r\u001e\u0011wC2,X\rI<ji\"\u0004C\u000f[3!O&4XM\u001c\u0011aUN|gn\u0015;sA\u0002\ng\u000e\u001a\u0011ag\u000eDW-\\1a]\u0005AQ\r_1na2,7/\t\u0002\u0003\u001e\u0006!\u0019C\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\n\n'EO\u0019-A\t\u0012'E\u000f\u0019/qu<C\u0006I\u0014bA%sE\u000b\f\u0011cA\u0011{UK\u0011'FO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEi\nDF\t2#uAr\u0003( \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014C/[7fEi\u0012#GN\u00181q=\u0012\u0004'M\u001b#{\u001eb\u0003e\n;j[\u0016\u0004C+[7fgR\fW\u000e]\u0014-A5\f\u0007\u000fK\u0014uS6,7\u000f^1na\u001a{'/\\1uO1\u0002s\u0005\u001a30\u001b6{\u00130_=zO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#i&lWM\t\u001e3aE*T\u0006\r\u001d.eY\u0002\u0003\u0007\r\u001e1ai\u0002\u0004' \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014C/Z1dQ\u0016\u0014(E\u000f\u0011#\u00032L7-\u001a\u0012-A\t\u001aH/\u001e3f]R\u0014#\bI.|E9\fW.\u001a\u0012;A\t\u0012uN\u0019\u0012-A\t\u0012\u0018M\\6#u\u0001\nT\u0010\f\u0011|E9\fW.\u001a\u0012;A\t\u001a\u0005.\u0019:mS\u0016\u0014C\u0006\t\u0012sC:\\'E\u000f\u00113{vkx\u0005\f\u0011('R\u0013Vk\u0011+=i\u0016\f7\r[3su\u0001\u001aFKU%O\u000f2\u00023\u000f^;eK:$(\bI!S%\u0006KFh\u0015+S+\u000e#FH\\1nKj\u00023\u000b\u0016*J\u001d\u001ec\u0003E]1oWj\u0002\u0013J\u0014+?}y:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|EQ,\u0017m\u00195fe\nR$%\u00117jG\u0016\u0014CFI:uk\u0012,g\u000e\u001e\u0012;7n\u0014c.Y7fEi\u0012#i\u001c2#Y\t\u0012\u0018M\\6#uEjHf\u001f\u0012oC6,'E\u000f\u0012DQ\u0006\u0014H.[3#Y\t\u0012\u0018M\\6#uIjX, \u0006!A\u0005)qM]8va\u0006\u0012!1U\u0001\u000bUN|gn\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001BU\u0003\u0015\u0011dF\r\u00181\u00035Q5o\u001c8U_N#(/^2ugB\u0011\u0011)K\n\u0005S\tE6\r\u0005\u0007\u00034\ne\u0006.]A\u0003\u0003#\ti\"\u0004\u0002\u00036*\u0019!qW0\u0002\u000fI,h\u000e^5nK&!!1\u0018B[\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0005[\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00057\nQ!\u00199qYf$\"\"!\b\u0003H\n%'1\u001aBg\u0011\u00151G\u00061\u0001i\u0011\u0015yG\u00061\u0001r\u0011\u001d\t\t\u0001\fa\u0001\u0003\u000bA\u0011\"!\u0004-!\u0003\u0005\r!!\u0005\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003V\nu\u0007#\u00020\u0002\u0014\t]\u0007#\u00030\u0003Z\"\f\u0018QAA\t\u0013\r\u0011Yn\u0018\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t}g&!AA\u0002\u0005u\u0011a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0017")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
QueryErrorsBase,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.JSON_TO_STRUCT(), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        if (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType)) {
            TypeCheckResult checkResult = ExprUtils$.MODULE$.checkJsonSchema(this.nullableSchema());
            if (checkResult.isFailure()) {
                return checkResult;
            }
            return ExpectsInputTypes.checkInputDataTypes$(this);
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_SCHEMA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)this.nullableSchema()))}))));
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> {
                        if (rows.hasNext()) {
                            return (InternalRow)rows.next();
                        }
                        return null;
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> {
                        if (rows.hasNext()) {
                            return ((SpecializedGetters)rows.next()).getArray(0);
                        }
                        return null;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> {
                        if (rows.hasNext()) {
                            return ((SpecializedGetters)rows.next()).getMap(0);
                        }
                        return null;
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_json", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple22 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq)structType.filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$12)))));
                } else {
                    tuple22 = tuple2 = new Tuple2((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), (Object)dataType);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructType parserSchema = (StructType)tuple2._1();
                DataType actualSchema = (DataType)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                StructType parserSchema2 = (StructType)tuple23._1();
                DataType actualSchema2 = (DataType)tuple23._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false, JacksonParser$.MODULE$.$lessinit$greater$default$4());
                Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        if (dataType instanceof MapType) {
            return "entries";
        }
        return super.sql();
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$12) {
        String string = x$12.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

