/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ExprUtils$
implements QueryErrorsBase {
    public static ExprUtils$ MODULE$;

    static {
        new ExprUtils$();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public DataType evalTypeExpr(Expression exp) {
        if (exp.foldable()) {
            UTF8String uTF8String;
            Object object = exp.eval(exp.eval$default$1());
            if (object instanceof UTF8String && (uTF8String = (UTF8String)object) != null) {
                DataType dataType = DataType$.MODULE$.fromDDL(uTF8String.toString());
                return CharVarcharUtils$.MODULE$.failIfHasCharVarchar(dataType);
            }
            throw QueryCompilationErrors$.MODULE$.unexpectedSchemaTypeError(exp);
        }
        throw QueryCompilationErrors$.MODULE$.unexpectedSchemaTypeError(exp);
    }

    public StructType evalSchemaExpr(Expression exp) {
        DataType dataType = this.evalTypeExpr(exp);
        if (!(dataType instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(exp, dataType);
        }
        return (StructType)dataType;
    }

    public Map<String, String> convertToMapData(Expression exp) {
        boolean bl = false;
        CreateMap createMap = null;
        Expression expression = exp;
        if (expression instanceof CreateMap) {
            bl = true;
            createMap = (CreateMap)expression;
            if (createMap.dataType().acceptsType((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false))) {
                ArrayBasedMapData arrayMap = (ArrayBasedMapData)createMap.eval(createMap.eval$default$1());
                return (Map)ArrayBasedMapData$.MODULE$.toScalaMap(arrayMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)value.toString());
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom());
            }
        }
        if (bl) {
            throw QueryCompilationErrors$.MODULE$.keyValueInMapNotStringError(createMap);
        }
        throw QueryCompilationErrors$.MODULE$.nonMapFunctionNotAllowedError();
    }

    public void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw QueryCompilationErrors$.MODULE$.invalidFieldTypeForCorruptRecordError();
            }
        });
    }

    public Function1<String, BigDecimal> getDecimalParser(Locale locale) {
        Locale locale2 = locale;
        Locale locale3 = Locale.US;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            return (Function1 & Serializable & scala.Serializable)s -> new BigDecimal(s.replaceAll(",", ""));
        }
        DecimalFormat decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(locale));
        decimalFormat.setParseBigDecimal(true);
        return (Function1 & Serializable & scala.Serializable)s -> {
            ParsePosition pos = new ParsePosition(0);
            BigDecimal result = (BigDecimal)decimalFormat.parse((String)s, pos);
            if (pos.getIndex() != s.length() || pos.getErrorIndex() != -1) {
                throw QueryExecutionErrors$.MODULE$.cannotParseDecimalError();
            }
            return result;
        };
    }

    public TypeCheckResult checkJsonSchema(DataType schema) {
        boolean isInvalid = schema.existsRecursively((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$checkJsonSchema$1(x0$1)));
        if (isInvalid) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)schema))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public TypeCheckResult checkXmlSchema(DataType schema) {
        boolean isInvalid = schema.existsRecursively((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$checkXmlSchema$1(x0$1)));
        if (isInvalid) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_XML_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)schema))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$checkJsonSchema$1(DataType x0$1) {
        DataType dataType = x0$1;
        if (dataType instanceof MapType) {
            DataType keyType;
            MapType mapType = (MapType)dataType;
            DataType dataType2 = keyType = mapType.keyType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkXmlSchema$1(DataType x0$1) {
        DataType dataType = x0$1;
        if (dataType instanceof MapType) {
            DataType keyType;
            MapType mapType = (MapType)dataType;
            DataType dataType2 = keyType = mapType.keyType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$)) {
                return true;
            }
        }
        return false;
    }

    private ExprUtils$() {
        MODULE$ = this;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

