/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Concat$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(col1, col2, ..., colN) - Returns the concatenation of col1, col2, ..., colN.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 'SQL');\n       SparkSQL\n      > SELECT _FUNC_(array(1, 2, 3), array(4, 5), array(6));\n       [1,2,3,4,5,6]\n  ", note="\n    Concat logic for arrays is available since 2.4.0.\n  ", group="collection_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t/\u0002\u0011\t\u0012)A\u0005\u0017\")\u0001\f\u0001C\u00013\")A\f\u0001C\u0005;\"9Q\r\u0001b\u0001\n\u000b2\u0007BB?\u0001A\u00035q\rC\u0003\u007f\u0001\u0011\u0005s\u0010\u0003\u0006\u0002\u000e\u0001A)\u0019!C!\u0003\u001fAq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002\"!9\u0011q\b\u0001\u0005B\u0005\u0005\u0002bBA!\u0001\u0011\u0005\u00131\t\u0005\u000b\u0003/\u0002\u0001R1A\u0005\n\u0005e\u0003bBA2\u0001\u0011E\u0013Q\r\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!a'\u0001\t\u0003\ni\n\u0003\u0004+\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003?\u0003A\u0011KAQ\u0011%\ti\u000bAA\u0001\n\u0003\ty\u000bC\u0005\u00024\u0002\t\n\u0011\"\u0001\u00026\"I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0013Q\u001a\u0005\n\u0003;\u0004\u0011\u0011!C\u0001\u0003?D\u0011\"a:\u0001\u0003\u0003%\t!!;\t\u0013\u0005=\b!!A\u0005B\u0005E\b\"CA\u0000\u0001\u0005\u0005I\u0011\u0001B\u0001\u0011%\u0011)\u0001AA\u0001\n\u0003\u00129aB\u0005\u00032\u0015\n\t\u0011#\u0001\u00034\u0019AA%JA\u0001\u0012\u0003\u0011)\u0004\u0003\u0004Y=\u0011\u0005!1\t\u0005\n\u00037s\u0012\u0011!C#\u0005\u000bB\u0011Ba\u0012\u001f\u0003\u0003%\tI!\u0013\t\u0013\t5c$!A\u0005\u0002\n=\u0003\"\u0003B.=\u0005\u0005I\u0011\u0002B/\u0005\u0019\u0019uN\\2bi*\u0011aeJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002)S\u0005A1-\u0019;bYf\u001cHO\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001g]R\u0004I\u0012\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t!\u0004(\u0003\u0002:K\ta2i\\7qY\u0016DH+\u001f9f\u001b\u0016\u0014x-\u001b8h\u000bb\u0004(/Z:tS>t\u0007CA\u001e?\u001b\u0005a$BA\u001f*\u0003\u0019)'O]8sg&\u0011q\b\u0010\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA!H\u0013\tA%I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005dQ&dGM]3o+\u0005Y\u0005c\u0001'Ug9\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!F\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005M\u0013\u0015a\u00029bG.\fw-Z\u0005\u0003+Z\u00131aU3r\u0015\t\u0019&)A\u0005dQ&dGM]3oA\u00051A(\u001b8jiz\"\"AW.\u0011\u0005Q\u0002\u0001\"B%\u0004\u0001\u0004Y\u0015\u0001D1mY><X\r\u001a+za\u0016\u001cX#\u00010\u0011\u00071#v\f\u0005\u0002aG6\t\u0011M\u0003\u0002cS\u0005)A/\u001f9fg&\u0011A-\u0019\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fAB\\8eKB\u000bG\u000f^3s]N,\u0012a\u001a\t\u0004\u0019RC\u0007CA5{\u001d\tQwO\u0004\u0002lk:\u0011A\u000e\u001e\b\u0003[Nt!A\u001c:\u000f\u0005=\fhB\u0001(q\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003m\u001e\nQ\u0001\u001e:fKNL!\u0001_=\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003m\u001eJ!a\u001f?\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003qf\fQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004O\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\f\u0005\u0015!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0005\u0011\u0007\u0001\f\u0019\"C\u0002\u0002\u0016\u0005\u0014\u0001\u0002R1uCRK\b/\u001a\u0015\u0004\u0011\u0005e\u0001cA!\u0002\u001c%\u0019\u0011Q\u0004\"\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0007:fgVdG/\u0011:sCf,E.Z7f]RtU\u000f\u001c7bE2,WCAA\u0012!\r\t\u0015QE\u0005\u0004\u0003O\u0011%a\u0002\"p_2,\u0017M\\\u0001\tU\u00064\u0018\rV=qKV\u0011\u0011Q\u0006\t\u0005\u0003_\t9D\u0004\u0003\u00022\u0005M\u0002C\u0001(C\u0013\r\t)DQ\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\")\u0001\u0005ok2d\u0017M\u00197f\u0003!1w\u000e\u001c3bE2,\u0017\u0001B3wC2$B!!\u0012\u0002LA\u0019\u0011)a\u0012\n\u0007\u0005%#IA\u0002B]fD\u0011\"!\u0014\u000e!\u0003\u0005\r!a\u0014\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005E\u00131K\u0007\u0002O%\u0019\u0011QK\u0014\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\tI>\u001cuN\\2biV\u0011\u00111\f\t\b\u0003\u0006u\u0013qJA#\u0013\r\tyF\u0011\u0002\n\rVt7\r^5p]FB3ADA\r\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002h\u0005M\u0014Q\u0010\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011QN\u0013\u0002\u000f\r|G-Z4f]&!\u0011\u0011OA6\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA;\u001f\u0001\u0007\u0011qO\u0001\u0004GRD\b\u0003BA5\u0003sJA!a\u001f\u0002l\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA@\u001f\u0001\u0007\u0011qM\u0001\u0003KZ\f!dZ3o\u0007>$WMR8s\u001dVl'-\u001a:PM\u0016cW-\\3oiN$B!!\"\u0002\fB9\u0011)a\"\u0002.\u00055\u0012bAAE\u0005\n1A+\u001e9mKJBq!!\u001e\u0011\u0001\u0004\t9(\u0001\thK:\u001cu\u000eZ3G_J\f%O]1zgRA\u0011QFAI\u0003'\u000b9\nC\u0004\u0002vE\u0001\r!a\u001e\t\u000f\u0005U\u0015\u00031\u0001\u0002\u0012\u0005YQ\r\\3nK:$H+\u001f9f\u0011\u001d\tI*\u0005a\u0001\u0003G\tAb\u00195fG.4uN\u001d(vY2\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003[\tqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007i\u000b\u0019\u000bC\u0004\u0002&R\u0001\r!a*\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005\u0019\u0006%6'C\u0002\u0002,Z\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u0007i\u000b\t\fC\u0004J+A\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0017\u0016\u0004\u0017\u0006e6FAA^!\u0011\ti,a2\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015')\u0001\u0006b]:|G/\u0019;j_:LA!!3\u0002@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\t1\fgn\u001a\u0006\u0003\u00033\fAA[1wC&!\u0011\u0011HAj\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u000fE\u0002B\u0003GL1!!:C\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)%a;\t\u0013\u00055\u0018$!AA\u0002\u0005\u0005\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002tB1\u0011Q_A~\u0003\u000bj!!a>\u000b\u0007\u0005e()\u0001\u0006d_2dWm\u0019;j_:LA!!@\u0002x\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019Ca\u0001\t\u0013\u000558$!AA\u0002\u0005\u0015\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002$\t%\u0001\"CAw9\u0005\u0005\t\u0019AA#Q]\u0001!Q\u0002B\n\u0005+\u0011IBa\u0007\u0003 \t\u0005\"Q\u0005B\u0014\u0005W\u0011i\u0003E\u00025\u0005\u001fI1A!\u0005&\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0006\u0002'~3UKT\"`Q\r|G.\r\u0017!G>d'\u0007\f\u0011/]9b\u0003eY8m\u001d&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043m\u001c8dCR,g.\u0019;j_:\u0004sN\u001a\u0011d_2\fD\u0006I2pYJb\u0003E\f\u0018/Y\u0001\u001aw\u000e\u001c(/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u000f\u0003\u0005]\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!OM\u000bFjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u0011beJ\f\u0017\u0010\u000b\u001b-AUJC\u0006I1se\u0006L\bFN\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a-g1\"D&\u000e\u00177;*\u0001\u0003%\u0001\u0003o_R,\u0017E\u0001B\u0012\u0003eR\u0001\u0005\t\u0011!\u0007>t7-\u0019;!Y><\u0017n\u0019\u0011g_J\u0004\u0013M\u001d:bsN\u0004\u0013n\u001d\u0011bm\u0006LG.\u00192mK\u0002\u001a\u0018N\\2fAIrCG\f\u0019/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0015\u0003A\u0019w\u000e\u001c7fGRLwN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u00030\u0005)\u0011GL\u001b/a\u000511i\u001c8dCR\u0004\"\u0001\u000e\u0010\u0014\ty\u00119D\u0012\t\u0007\u0005s\u0011yd\u0013.\u000e\u0005\tm\"b\u0001B\u001f\u0005\u00069!/\u001e8uS6,\u0017\u0002\u0002B!\u0005w\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011\u0019\u0004\u0006\u0002\u0002P\u0006)\u0011\r\u001d9msR\u0019!La\u0013\t\u000b%\u000b\u0003\u0019A&\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u000bB,!\u0011\t%1K&\n\u0007\tU#I\u0001\u0004PaRLwN\u001c\u0005\t\u00053\u0012\u0013\u0011!a\u00015\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u0002B!!5\u0003b%!!1MAj\u0005\u0019y%M[3di\u0002")
public class Concat
extends Expression
implements ComplexTypeMergingExpression,
QueryErrorsBase,
scala.Serializable {
    private transient DataType dataType;
    private transient Function1<InternalRow, Object> doConcat;
    private final Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Seq<Expression>> unapply(Concat concat) {
        return Concat$.MODULE$.unapply(concat);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Concat, A> function1) {
        return Concat$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Concat> compose(Function1<A, Seq<Expression>> function1) {
        return Concat$.MODULE$.compose(function1);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public Seq<AbstractDataType> org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().isEmpty()) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        Option dataTypeMismatch = ((TraversableOnce)this.children().zipWithIndex(Seq$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Concat $outer;

            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (!this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$applyOrElse$1(e, x$44)))) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Integer.toString(idx + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply(this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    if (!this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$isDefinedAt$1(e, x$44)))) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression e$1, AbstractDataType x$44) {
                return x$44.acceptsType(e$1.dataType());
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Expression e$2, AbstractDataType x$44) {
                return x$44.acceptsType(e$2.dataType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.types.AbstractDataType ), $anonfun$isDefinedAt$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.types.AbstractDataType )}, serializedLambda);
            }
        });
        Option option = dataTypeMismatch;
        if (option instanceof Some) {
            Some some = (Some)option;
            TypeCheckResult.DataTypeMismatch mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
            return mismatch;
        }
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)((Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$45 -> x$45.dataType(), Seq$.MODULE$.canBuildFrom())), this.prettyName());
    }

    private DataType dataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.children().isEmpty() ? StringType$.MODULE$ : ComplexTypeMergingExpression.dataType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private String javaType() {
        return CodeGenerator$.MODULE$.javaType(this.dataType());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)x$46.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)x$47.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        return this.doConcat().apply((Object)input);
    }

    private Function1<InternalRow, Object> doConcat$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.dataType();
                if (BinaryType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        Seq inputs = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$48 -> (byte[])x$48.eval((InternalRow)input), Seq$.MODULE$.canBuildFrom());
                        return ByteArray.concat((byte[][])((byte[][])inputs.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        Seq inputs = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$49 -> (UTF8String)x$49.eval((InternalRow)input), Seq$.MODULE$.canBuildFrom());
                        return UTF8String.concat((UTF8String[])((UTF8String[])inputs.toArray(ClassTag$.MODULE$.apply(UTF8String.class))));
                    };
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        Stream inputs = (Stream)this.children().toStream().map((Function1 & Serializable & scala.Serializable)x$50 -> x$50.eval((InternalRow)input), Stream$.MODULE$.canBuildFrom());
                        if (inputs.contains(null)) {
                            return null;
                        }
                        Stream arrayData = (Stream)inputs.map((Function1 & Serializable & scala.Serializable)x$51 -> (ArrayData)x$51, Stream$.MODULE$.canBuildFrom());
                        long numberOfElements = BoxesRunTime.unboxToLong((Object)arrayData.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, ad) -> BoxesRunTime.boxToLong((long)Concat.$anonfun$doConcat$8(BoxesRunTime.unboxToLong((Object)sum), ad))));
                        if (numberOfElements > 0x7FFFFFF0L) {
                            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(numberOfElements);
                        }
                        Object[] finalData = new Object[(int)numberOfElements];
                        IntRef position = IntRef.create((int)0);
                        arrayData.foreach((Function1 & Serializable & scala.Serializable)ad -> {
                            Concat.$anonfun$doConcat$9(elementType, finalData, position, ad);
                            return BoxedUnit.UNIT;
                        });
                        return new GenericArrayData((Object)finalData);
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doConcat = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doConcat;
    }

    private Function1<InternalRow, Object> doConcat() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.doConcat$lzycompute();
        }
        return this.doConcat;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Tuple2 tuple2;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$52 -> x$52.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        String args = ctx.freshName("args");
        String hasNull = ctx.freshName("hasNull");
        Seq inputs = (Seq)((TraversableLike)((IterableLike)evals.zip((GenIterable)this.children().map((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)x$53.nullable()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    ExprCode eval = (ExprCode)tuple22._1();
                    boolean bl = tuple22._2$mcZ$sp();
                    if (bl) {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n           |if (!").append(hasNull).append(") {\n           |  ").append(eval.code()).append("\n           |  if (!").append(eval.isNull()).append(") {\n           |    ").append(args).append("[").append(index).append("] = ").append(eval.value()).append(";\n           |  } else {\n           |    ").append(hasNull).append(" = true;\n           |  }\n           |}\n         ").toString())).stripMargin();
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple23 != null) {
                    ExprCode eval = (ExprCode)tuple23._1();
                    boolean bl = tuple23._2$mcZ$sp();
                    if (!bl) {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n           |if (!").append(hasNull).append(") {\n           |  ").append(eval.code()).append("\n           |  ").append(args).append("[").append(index).append("] = ").append(eval.value()).append(";\n           |}\n         ").toString())).stripMargin();
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple22 = new Tuple2((Object)new StringBuilder(2).append(this.javaType()).append("[]").toString(), (Object)args);
        Tuple2 tuple23 = new Tuple2((Object)"boolean", (Object)hasNull);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)inputs, "valueConcat", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22), "boolean", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)body -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(44).append("\n           |").append((String)body).append("\n           |return ").append(hasNull).append(";\n         ").toString())).stripMargin(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)x$56 -> ((TraversableOnce)x$56.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringBuilder(4).append(hasNull).append(" = ").append((String)funcCall).append(";").toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n"));
        DataType dataType = this.dataType();
        if (BinaryType$.MODULE$.equals(dataType)) {
            tuple2 = new Tuple2((Object)new StringBuilder(7).append(ByteArray.class.getName()).append(".concat").toString(), (Object)new StringBuilder(25).append("byte[][] ").append(args).append(" = new byte[").append(evals.length()).append("][];").toString());
        } else if (StringType$.MODULE$.equals(dataType)) {
            tuple2 = new Tuple2((Object)"UTF8String.concat", (Object)new StringBuilder(33).append("UTF8String[] ").append(args).append(" = new UTF8String[").append(evals.length()).append("];").toString());
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            String concat = this.genCodeForArrays(ctx, elementType, containsNull);
            tuple2 = new Tuple2((Object)concat, (Object)new StringBuilder(31).append("ArrayData[] ").append(args).append(" = new ArrayData[").append(evals.length()).append("];").toString());
        } else {
            throw new MatchError((Object)dataType);
        }
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String concat = (String)tuple24._1();
        String initCode = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)concat, (Object)initCode);
        String concat2 = (String)tuple25._1();
        String initCode2 = (String)tuple25._2();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " = null;\n         |if (!", ") {\n         |  ", " = ", "(", ");\n         |}\n         |boolean ", " = ", " == null;\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hasNull, initCode2, codes, this.javaType(), ev.value(), hasNull, ev.value(), concat2, args, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx) {
        String numElements = ctx.freshName("numElements");
        String z = ctx.freshName("z");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n        |long ").append(numElements).append(" = 0L;\n        |for (int ").append(z).append(" = 0; ").append(z).append(" < ").append(this.children().length()).append("; ").append(z).append("++) {\n        |  ").append(numElements).append(" += args[").append(z).append("].numElements();\n        |}\n      ").toString())).stripMargin();
        return new Tuple2((Object)code, (Object)numElements);
    }

    private String genCodeForArrays(CodegenContext ctx, DataType elementType, boolean checkForNull) {
        String counter = ctx.freshName("counter");
        String arrayData = ctx.freshName("arrayData");
        String y = ctx.freshName("y");
        String z = ctx.freshName("z");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        String numElemCode2 = (String)tuple22._1();
        String numElemName2 = (String)tuple22._2();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, new StringBuilder(6).append("args[").append(y).append("]").toString(), counter, z, this.resultArrayElementNullable());
        String concat = ctx.freshName("concat");
        String concatDef = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(303).append("\n         |private ArrayData ").append(concat).append("(ArrayData[] args) {\n         |  ").append(numElemCode2).append("\n         |  ").append(initialization).append("\n         |  int ").append(counter).append(" = 0;\n         |  for (int ").append(y).append(" = 0; ").append(y).append(" < ").append(this.children().length()).append("; ").append(y).append("++) {\n         |    for (int ").append(z).append(" = 0; ").append(z).append(" < args[").append(y).append("].numElements(); ").append(z).append("++) {\n         |      ").append(assignment).append("\n         |      ").append(counter).append("++;\n         |    }\n         |  }\n         |  return ").append(arrayData).append(";\n         |}\n       ").toString())).stripMargin();
        return ctx.addNewFunction(concat, concatDef, ctx.addNewFunction$default$3());
    }

    @Override
    public String toString() {
        return new StringBuilder(8).append("concat(").append(this.children().mkString(", ")).append(")").toString();
    }

    @Override
    public String sql() {
        return new StringBuilder(8).append("concat(").append(((TraversableOnce)this.children().map((Function1 & Serializable & scala.Serializable)x$59 -> x$59.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
    }

    @Override
    public Concat withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public Concat copy(Seq<Expression> children2) {
        return new Concat(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Concat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Concat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Concat)) return false;
        boolean bl = true;
        if (!bl) return false;
        Concat concat = (Concat)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = concat.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!concat.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$doConcat$8(long sum, ArrayData ad) {
        return sum + (long)ad.numElements();
    }

    public static final /* synthetic */ void $anonfun$doConcat$9(DataType elementType$2, Object[] finalData$1, IntRef position$1, ArrayData ad) {
        Object[] arr = ad.toObjectArray(elementType$2);
        Array$.MODULE$.copy((Object)arr, 0, (Object)finalData$1, position$1.elem, arr.length);
        position$1.elem += arr.length;
    }

    public Concat(Seq<Expression> children2) {
        this.children = children2;
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.CONCAT(), (List)Nil$.MODULE$);
    }
}

