/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CallMethodViaReflection$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(class, method[, arg1[, arg2 ..]]) - Calls a method with reflection.", examples="\n    Examples:\n      > SELECT _FUNC_('java.util.UUID', 'randomUUID');\n       c33fb387-8500-4bfa-81d2-6e0e3e930df2\n      > SELECT _FUNC_('java.util.UUID', 'fromString', 'a5cf6c42-0c85-418f-af6c-3e4e5b1328f2');\n       a5cf6c42-0c85-418f-af6c-3e4e5b1328f2\n  ", since="2.0.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001\u0002\u0016,\u0001bB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\tG\u0002\u0011\t\u0012)A\u0005/\"AA\r\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005j\u0001\tE\t\u0015!\u0003g\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015Q\u0007\u0001\"\u0001p\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015Y\b\u0001\"\u0011}\u0011\u0019\t9\u0001\u0001C!K\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00131\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u000e!9\u00111\u0004\u0001\u0005R\u0005u\u0001bBA\u0018\u0001\u0011E\u0013\u0011\u0007\u0005\u000b\u0003\u000b\u0002\u0001R1A\u0005\n\u0005\u001d\u0003BCA,\u0001!\u0015\r\u0011\"\u0003\u0002Z!I\u00111\u000e\u0001\t\u0006\u0004%I!\u001a\u0005\u000b\u0003_\u0002\u0001R1A\u0005\n\u0005e\u0003BCA:\u0001!\u0015\r\u0011\"\u0001\u0002v!Q\u0011Q\u0011\u0001\t\u0006\u0004%I!a\"\t\u000f\u0005M\u0005\u0001\"\u0015\u0002\u0016\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003S\u0003\u0011\u0013!C\u0001\u0003WC\u0011\"!1\u0001#\u0003%\t!a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005e\u0003\"CAe\u0001\u0005\u0005I\u0011AAf\u0011%\ti\rAA\u0001\n\u0003\ty\rC\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\"I\u0011Q\u001d\u0001\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003W\u0004\u0011\u0011!C!\u0003[<qA!\u0005,\u0011\u0003\u0011\u0019B\u0002\u0004+W!\u0005!Q\u0003\u0005\u0007U~!\tA!\b\t\u0013\t}qD1A\u0005\u0002\t\u0005\u0002\u0002\u0003B\"?\u0001\u0006IAa\t\t\u000f\u0005-t\u0004\"\u0003\u0003N!9!\u0011K\u0010\u0005\u0002\tM\u0003\"\u0003B3?\u0005\u0005I\u0011\u0011B4\u0011%\u0011igHI\u0001\n\u0003\t\u0019\rC\u0005\u0003p}\t\t\u0011\"!\u0003r!I!qP\u0010\u0012\u0002\u0013\u0005\u00111\u0019\u0005\n\u0005\u0003{\u0012\u0011!C\u0005\u0005\u0007\u0013qcQ1mY6+G\u000f[8e-&\f'+\u001a4mK\u000e$\u0018n\u001c8\u000b\u00051j\u0013aC3yaJ,7o]5p]NT!AL\u0018\u0002\u0011\r\fG/\u00197zgRT!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001d>\u0001\u001ac%\u000b\u0005\u0002;w5\t1&\u0003\u0002=W\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005AquN\u001c3fi\u0016\u0014X.\u001b8jgRL7\r\u0005\u0002B\t6\t!I\u0003\u0002DW\u000591m\u001c3fO\u0016t\u0017BA#C\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA$K\u001b\u0005A%BA%0\u0003\u0019)'O]8sg&\u00111\n\u0013\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n9\u0001K]8ek\u000e$\bCA'T\u0013\t!fJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005dQ&dGM]3o+\u00059\u0006c\u0001-as9\u0011\u0011L\u0018\b\u00035vk\u0011a\u0017\u0006\u00039^\na\u0001\u0010:p_Rt\u0014\"A(\n\u0005}s\u0015a\u00029bG.\fw-Z\u0005\u0003C\n\u00141aU3r\u0015\tyf*A\u0005dQ&dGM]3oA\u0005Ya-Y5m\u001f:,%O]8s+\u00051\u0007CA'h\u0013\tAgJA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\raWN\u001c\t\u0003u\u0001AQ!V\u0003A\u0002]Cq\u0001Z\u0003\u0011\u0002\u0003\u0007a\r\u0006\u0002ma\")QK\u0002a\u0001/\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003M\u0004\"\u0001\u001e=\u000f\u0005U4\bC\u0001.O\u0013\t9h*\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<O\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u00025\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0004\u0003\u000by(a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00119,H\u000e\\1cY\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'y\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u0011\u0001\u0002R1uCRK\b/Z\u0001\nI\u0006$\u0018\rV=qK\u0002\n!#\u001b8ji&\fG.\u001b>f\u0013:$XM\u001d8bYR!\u0011qDA\u0013!\ri\u0015\u0011E\u0005\u0004\u0003Gq%\u0001B+oSRDq!a\n\r\u0001\u0004\tI#\u0001\bqCJ$\u0018\u000e^5p]&sG-\u001a=\u0011\u00075\u000bY#C\u0002\u0002.9\u00131!\u00138u\u00031)g/\u00197J]R,'O\\1m)\u0011\t\u0019$!\u000f\u0011\u00075\u000b)$C\u0002\u000289\u00131!\u00118z\u0011\u001d\tY$\u0004a\u0001\u0003{\tQ!\u001b8qkR\u0004B!a\u0010\u0002B5\tQ&C\u0002\u0002D5\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006A\u0011M]4FqB\u00148/\u0006\u0002\u0002JA!Q*a\u0013:\u0013\r\tiE\u0014\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004\u001d\u0005E\u0003cA'\u0002T%\u0019\u0011Q\u000b(\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!C2mCN\u001ch*Y7f+\t\tY\u0006\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0003K\nAA[1wC&\u0019\u00110a\u0018)\u0007=\t\t&A\u0006dY\u0006\u001c8/\u0012=jgR\u001c\bf\u0001\t\u0002R\u0005QQ.\u001a;i_\u0012t\u0015-\\3)\u0007E\t\t&\u0001\u0004nKRDw\u000eZ\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0005\u0003{\ny&A\u0004sK\u001adWm\u0019;\n\t\u0005\u0005\u00151\u0010\u0002\u0007\u001b\u0016$\bn\u001c3)\u0007I\t\t&\u0001\u0004ck\u001a4WM]\u000b\u0003\u0003\u0013\u0003R!TA&\u0003\u0017\u0003B!!\u0018\u0002\u000e&!\u0011qRA0\u0005\u0019y%M[3di\"\u001a1#!\u0015\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u00017\u0002\u0018\"9\u0011\u0011\u0014\u000bA\u0002\u0005m\u0015a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004B\u0001WAOs%\u0019\u0011q\u00142\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLH#\u00027\u0002&\u0006\u001d\u0006bB+\u0016!\u0003\u0005\ra\u0016\u0005\bIV\u0001\n\u00111\u0001g\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!,+\u0007]\u000byk\u000b\u0002\u00022B!\u00111WA_\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016!C;oG\",7m[3e\u0015\r\tYLT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA`\u0003k\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!2+\u0007\u0019\fy+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003S\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00024\u0005E\u0007\"CAj5\u0005\u0005\t\u0019AA\u0015\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001c\t\u0007\u00037\f\t/a\r\u000e\u0005\u0005u'bAAp\u001d\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018Q\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002g\u0003SD\u0011\"a5\u001d\u0003\u0003\u0005\r!a\r\u0002\r\u0015\fX/\u00197t)\r1\u0017q\u001e\u0005\n\u0003'l\u0012\u0011!a\u0001\u0003gA3\u0003AAz\u0003s\fY0a@\u0003\u0002\t\u0015!q\u0001B\u0006\u0005\u001b\u00012AOA{\u0013\r\t9p\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti0\u0001&`\rVs5i\u0018\u0015dY\u0006\u001c8\u000f\f\u0011nKRDw\u000eZ.-A\u0005\u0014x-M.-A\u0005\u0014xM\r\u0011/]uk\u0016\u0006I\u0017!\u0007\u0006dGn\u001d\u0011bA5,G\u000f[8eA]LG\u000f\u001b\u0011sK\u001adWm\u0019;j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\r\u0011!a@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dR\u0017M^1/kRLGNL+V\u0013\u0012;C\u0006I\u0014sC:$w.\\+V\u0013\u0012;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011dgM2'm\r\u001d8[a*\u0004\u0007M\u00175E\u001a\fW\u0006O\u0019ee52T\rM34Kf\u001a\u0004\u0007\u001a43\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#.\u0019<b]U$\u0018\u000e\u001c\u0018V+&#u\u0005\f\u0011(MJ|Wn\u0015;sS:<w\u0005\f\u0011(CV\u001agMN25e5\u00024\rO\u001b.iEBd-L1gm\rl3'\u001a\u001bfk\t\f4G\r\u001dge\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I16G\u001a44\r\u000e\u001a.a\rDT'\f\u001b2q\u0019l\u0013M\u001a\u001cd[M*G'Z\u001bccM\u0012\u0004H\u001a\u001a\u000bA\u0001\nQa]5oG\u0016\f#A!\u0003\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t=\u0011AC7jg\u000e|f-\u001e8dg\u000692)\u00197m\u001b\u0016$\bn\u001c3WS\u0006\u0014VM\u001a7fGRLwN\u001c\t\u0003u}\u0019Ba\bB\f%B\u0019QJ!\u0007\n\u0007\tmaJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005'\t1\u0002^=qK6\u000b\u0007\u000f]5oOV\u0011!1\u0005\t\t\u0005K\u0011Y#!\u0004\u000305\u0011!q\u0005\u0006\u0005\u0005S\ti.A\u0005j[6,H/\u00192mK&!!Q\u0006B\u0014\u0005\ri\u0015\r\u001d\t\u0007\u00037\u0014\tDa\r\n\u0007\u0005\fi\u000e\r\u0003\u00036\t}\u0002CBA/\u0005o\u0011Y$\u0003\u0003\u0003:\u0005}#!B\"mCN\u001c\b\u0003\u0002B\u001f\u0005\u007fa\u0001\u0001B\u0006\u0003B\t\n\t\u0011!A\u0003\u0002\t\u0015#aA0%c\u0005aA/\u001f9f\u001b\u0006\u0004\b/\u001b8hAE!!qIA\u001a!\ri%\u0011J\u0005\u0004\u0005\u0017r%a\u0002(pi\"Lgn\u001a\u000b\u0004M\n=\u0003BBA,G\u0001\u00071/\u0001\u0006gS:$W*\u001a;i_\u0012$\u0002B!\u0016\u0003\\\tu#q\f\t\u0006\u001b\n]\u0013qO\u0005\u0004\u00053r%AB(qi&|g\u000e\u0003\u0004\u0002X\u0011\u0002\ra\u001d\u0005\u0007\u0003_\"\u0003\u0019A:\t\u000f\t\u0005D\u00051\u0001\u0003d\u0005A\u0011M]4UsB,7\u000f\u0005\u0003YA\u00065\u0011!B1qa2LH#\u00027\u0003j\t-\u0004\"B+&\u0001\u00049\u0006b\u00023&!\u0003\u0005\rAZ\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003\u0002B:\u0005w\u0002R!\u0014B,\u0005k\u0002R!\u0014B</\u001aL1A!\u001fO\u0005\u0019!V\u000f\u001d7fe!A!QP\u0014\u0002\u0002\u0003\u0007A.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a#")
public class CallMethodViaReflection
extends Expression
implements Nondeterministic,
CodegenFallback,
QueryErrorsBase,
scala.Serializable {
    private transient Expression[] argExprs;
    private transient String className;
    private transient boolean classExists;
    private transient String methodName;
    private transient Method method;
    private transient Object[] buffer;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return CallMethodViaReflection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CallMethodViaReflection callMethodViaReflection) {
        return CallMethodViaReflection$.MODULE$.unapply(callMethodViaReflection);
    }

    public static boolean apply$default$2() {
        return CallMethodViaReflection$.MODULE$.apply$default$2();
    }

    public static Option<Method> findMethod(String string, String string2, Seq<DataType> seq) {
        return CallMethodViaReflection$.MODULE$.findMethod(string, string2, seq);
    }

    public static Map<DataType, Seq<Class<?>>> typeMapping() {
        return CallMethodViaReflection$.MODULE$.typeMapping();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "reflect");
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(this.toSQLId(this.prettyName()), (Seq<Object>)((Seq)new .colon.colon((Object)"> 1", (List)Nil$.MODULE$)), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Option unexpectedParameter = ((TraversableOnce)this.children().zipWithIndex(Seq$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CallMethodViaReflection $outer;

            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (0 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !e.foldable()) {
                            return (B1)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.$outer.toSQLId("class")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().head()))}))));
                        }
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("class"))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (1 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !e.foldable()) {
                            return (B1)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.$outer.toSQLId("method")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().apply(1)))}))));
                        }
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("method"))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType())) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Integer.toString(idx + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !e.foldable()) {
                            return true;
                        }
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (1 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !e.foldable()) {
                            return true;
                        }
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType())) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option option = unexpectedParameter;
        if (option instanceof Some) {
            Some some = (Some)option;
            TypeCheckResult.DataTypeMismatch mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
            return mismatch;
        }
        if (!this.classExists()) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_CLASS_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())}))));
        }
        if (this.method() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_STATIC_METHOD", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methodName"), (Object)this.methodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
    }

    @Override
    public Object evalInternal(InternalRow input) {
        UTF8String uTF8String;
        for (int i = 0; i < this.argExprs().length; ++i) {
            this.buffer()[i] = this.argExprs()[i].eval(input);
            if (!(this.buffer()[i] instanceof UTF8String)) continue;
            this.buffer()[i] = this.buffer()[i].toString();
        }
        try {
            Object ret = this.method().invoke(null, this.buffer());
            uTF8String = UTF8String.fromString((String)String.valueOf(ret));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty() && !this.failOnError()) {
                uTF8String = null;
            }
            throw throwable;
        }
        return uTF8String;
    }

    private Expression[] argExprs$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.argExprs = (Expression[])((TraversableOnce)this.children().drop(2)).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.argExprs;
    }

    private Expression[] argExprs() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.argExprs$lzycompute();
        }
        return this.argExprs;
    }

    private String className$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Expression qual$1 = (Expression)this.children().apply(0);
                InternalRow x$1 = qual$1.eval$default$1();
                this.className = ((UTF8String)qual$1.eval(x$1)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.className;
    }

    private String className() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.className$lzycompute();
        }
        return this.className;
    }

    private boolean classExists$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.classExists = CallMethodViaReflection$.MODULE$.org$apache$spark$sql$catalyst$expressions$CallMethodViaReflection$$classExists(this.className());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.classExists;
    }

    private boolean classExists() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.classExists$lzycompute();
        }
        return this.classExists;
    }

    private String methodName$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.methodName = ((UTF8String)((Expression)this.children().apply(1)).eval(null)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.methodName;
    }

    private String methodName() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.methodName$lzycompute();
        }
        return this.methodName;
    }

    private Method method$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.method = (Method)CallMethodViaReflection$.MODULE$.findMethod(this.className(), this.methodName(), (Seq<DataType>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.argExprs())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))).orNull(Predef$.MODULE$.$conforms());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.method;
    }

    public Method method() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.method$lzycompute();
        }
        return this.method;
    }

    private Object[] buffer$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.buffer = new Object[this.argExprs().length];
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.buffer;
    }

    private Object[] buffer() {
        if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
            return this.buffer$lzycompute();
        }
        return this.buffer;
    }

    @Override
    public CallMethodViaReflection withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public CallMethodViaReflection copy(Seq<Expression> children2, boolean failOnError) {
        return new CallMethodViaReflection(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "CallMethodViaReflection";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CallMethodViaReflection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CallMethodViaReflection)) return false;
        boolean bl = true;
        if (!bl) return false;
        CallMethodViaReflection callMethodViaReflection = (CallMethodViaReflection)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = callMethodViaReflection.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.failOnError() != callMethodViaReflection.failOnError()) return false;
        if (!callMethodViaReflection.canEqual(this)) return false;
        return true;
    }

    public CallMethodViaReflection(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        Nondeterministic.$init$(this);
        CodegenFallback.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.dataType = StringType$.MODULE$;
    }

    public CallMethodViaReflection(Seq<Expression> children2) {
        this(children2, true);
    }
}

