/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0012%\u0001FB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011[\u0011!\t\u0007\u0001#b\u0001\n\u0013\u0011\u0007\u0002C;\u0001\u0011\u000b\u0007I\u0011\u0002<\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u00111\u0012\u0001\u0005B\u00055\u0005bBAH\u0001\u0011E\u0013\u0011\u0013\u0005\n\u00037\u0003\u0011\u0011!C\u0001\u0003;C\u0011\"a)\u0001#\u0003%\t!!*\t\u0013\u0005m\u0006!%A\u0005\u0002\u0005\u0015\u0006\"CA_\u0001\u0005\u0005I\u0011IA`\u0011%\ty\rAA\u0001\n\u0003\t\t\u000eC\u0005\u0002Z\u0002\t\t\u0011\"\u0001\u0002\\\"I\u0011\u0011\u001d\u0001\u0002\u0002\u0013\u0005\u00131\u001d\u0005\n\u0003c\u0004\u0011\u0011!C\u0001\u0003gD\u0011\"a>\u0001\u0003\u0003%\t%!?\b\u0013\tuA%!A\t\u0002\t}a\u0001C\u0012%\u0003\u0003E\tA!\t\t\rQkB\u0011\u0001B\u0018\u0011%\u0011\t$HA\u0001\n\u000b\u0012\u0019\u0004C\u0005\u00036u\t\t\u0011\"!\u00038!I!QH\u000f\u0002\u0002\u0013\u0005%q\b\u0005\n\u0005#j\u0012\u0011!C\u0005\u0005'\u0012Q\"\u0011:sCf\u001cxJ^3sY\u0006\u0004(BA\u0013'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dB\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0011d'\u000f!D\u0013B\u00111\u0007N\u0007\u0002I%\u0011Q\u0007\n\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aM\u001c\n\u0005a\"#!\n\"j]\u0006\u0014\u00180\u0011:sCf,\u0005\u0010\u001d:fgNLwN\\,ji\"LU\u000e\u001d7jG&$8)Y:u!\tQTH\u0004\u00024w%\u0011A\bJ\u0001\ba\u0006\u001c7.Y4f\u0013\tqtH\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005q\"\u0003CA\u001aB\u0013\t\u0011EEA\u0005Qe\u0016$\u0017nY1uKB\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n9\u0001K]8ek\u000e$\bC\u0001#K\u0013\tYUI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001(\u0011\u0005Mz\u0015B\u0001)%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r1v\u000b\u0017\t\u0003g\u0001AQ\u0001T\u0003A\u00029CQAU\u0003A\u00029\u000b1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u001a\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003Av\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\t_J$WM]5oOV\t1\rE\u0002eW:t!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!\u0004\u0014A\u0002\u001fs_>$h(C\u0001G\u0013\taT)\u0003\u0002m[\nAqJ\u001d3fe&twM\u0003\u0002=\u000bB\u0011Ai\\\u0005\u0003a\u0016\u00131!\u00118zQ\t9!\u000f\u0005\u0002Eg&\u0011A/\u0012\u0002\niJ\fgn]5f]R\fA\u0002Z8Fm\u0006dW/\u0019;j_:,\u0012a\u001e\t\u0006\tbT(P\\\u0005\u0003s\u0016\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u0005mtX\"\u0001?\u000b\u0005u4\u0013\u0001B;uS2L!a ?\u0003\u0013\u0005\u0013(/Y=ECR\f\u0007F\u0001\u0005s\u0003!qW\u000f\u001c7bE2,WCAA\u0004!\r!\u0015\u0011B\u0005\u0004\u0003\u0017)%a\u0002\"p_2,\u0017M\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0006]\u0006E\u0011Q\u0003\u0005\u0007\u0003'Q\u0001\u0019\u00018\u0002\u0005\u0005\f\u0004BBA\f\u0015\u0001\u0007a.\u0001\u0002be\u0005Aa-Y:u\u000bZ\fG\u000eF\u0003o\u0003;\t\t\u0003\u0003\u0004\u0002 -\u0001\rA_\u0001\u0005CJ\u0014\u0018\u0007\u0003\u0004\u0002$-\u0001\rA_\u0001\u0005CJ\u0014('\u0001\bceV$XMR8sG\u0016,e/\u00197\u0015\u000b9\fI#a\u000b\t\r\u0005}A\u00021\u0001{\u0011\u0019\t\u0019\u0003\u0004a\u0001u\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003c\ti$a\u0012\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e%\u0003\u001d\u0019w\u000eZ3hK:LA!a\u000f\u00026\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002@5\u0001\r!!\u0011\u0002\u0007\r$\b\u0010\u0005\u0003\u00024\u0005\r\u0013\u0002BA#\u0003k\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002J5\u0001\r!!\r\u0002\u0005\u00154\u0018a\u00034bgR\u001cu\u000eZ3hK:$\"\"a\u0014\u0002`\u0005\u0005\u00141MA4!\u0011\t\t&!\u0017\u000f\t\u0005M\u0013Q\u000b\t\u0003M\u0016K1!a\u0016F\u0003\u0019\u0001&/\u001a3fM&!\u00111LA/\u0005\u0019\u0019FO]5oO*\u0019\u0011qK#\t\u000f\u0005}b\u00021\u0001\u0002B!9\u0011\u0011\n\bA\u0002\u0005E\u0002bBA3\u001d\u0001\u0007\u0011qJ\u0001\bg6\fG\u000e\\3s\u0011\u001d\tIG\u0004a\u0001\u0003\u001f\naAY5hO\u0016\u0014\u0018!\u00052skR,gi\u001c:dK\u000e{G-Z4f]RQ\u0011qJA8\u0003c\n\u0019(!\u001e\t\u000f\u0005}r\u00021\u0001\u0002B!9\u0011\u0011J\bA\u0002\u0005E\u0002bBA3\u001f\u0001\u0007\u0011q\n\u0005\b\u0003Sz\u0001\u0019AA(\u0003YqW\u000f\u001c7TC\u001a,W\t\\3nK:$8i\u001c3fO\u0016tGCCA(\u0003w\ny(a!\u0002\b\"9\u0011Q\u0010\tA\u0002\u0005=\u0013\u0001C1se\u0006Lh+\u0019:\t\u000f\u0005\u0005\u0005\u00031\u0001\u0002P\u0005)\u0011N\u001c3fq\"9\u0011Q\u0011\tA\u0002\u0005=\u0013\u0001B2pI\u0016Dq!!#\u0011\u0001\u0004\ty%\u0001\u0006jg:+H\u000e\\\"pI\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\ty%A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)a+a%\u0002\u0018\"1\u0011Q\u0013\nA\u00029\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u001aJ\u0001\rAT\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u00151\u0016qTAQ\u0011\u001da5\u0003%AA\u00029CqAU\n\u0011\u0002\u0003\u0007a*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d&f\u0001(\u0002*.\u0012\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003%)hn\u00195fG.,GMC\u0002\u00026\u0016\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI,a,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\r\u0005\u0003\u0002D\u00065WBAAc\u0015\u0011\t9-!3\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\fAA[1wC&!\u00111LAc\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u000eE\u0002E\u0003+L1!a6F\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rq\u0017Q\u001c\u0005\n\u0003?D\u0012\u0011!a\u0001\u0003'\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAs!\u0015\t9/!<o\u001b\t\tIOC\u0002\u0002l\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty/!;\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\t)\u0010\u0003\u0005\u0002`j\t\t\u00111\u0001o\u0003\u0019)\u0017/^1mgR!\u0011qAA~\u0011!\tynGA\u0001\u0002\u0004q\u0007f\u0005\u0001\u0002\u0000\n\u0015!q\u0001B\u0006\u0005\u001b\u0011\tBa\u0005\u0003\u0018\te\u0001cA\u001a\u0003\u0002%\u0019!1\u0001\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011B\u0001\u0002X~3UKT\"`Q\u0005\fD\u0006I13S\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011bc\u0001\u001awN\u001c;bS:\u001c\b%\u0019;!Y\u0016\f7\u000f\u001e\u0011bA9|g.\f8vY2\u0004S\r\\3nK:$\b\u0005\u001d:fg\u0016tG\u000fI1mg>\u0004\u0013N\u001c\u0011be9\u0002\u0013J\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bsN\u0004\u0003.\u0019<fA9|\u0007eY8n[>t\u0007%\u001a7f[\u0016tG\u000fI1oI\u0002\"\b.Z=!CJ,\u0007EY8uQ\u0002rwN\\\u0017f[B$\u0018\u0010I1oI\u0002*\u0017\u000e\u001e5fe\u0002zg\r\t;iK6\u00043m\u001c8uC&t7\u000fI1!]VdG\u000eI3mK6,g\u000e\u001e\u0011ok2d\u0007%[:!e\u0016$XO\u001d8fI2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qB\u0001U\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%b\u0003%\u0019:sCfD3\u0007\f\u00115Y\u0001*\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011)\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u000e\u0003\u0015\u0011d\u0006\u000e\u00181\u00035\t%O]1zg>3XM\u001d7baB\u00111'H\n\u0005;\t\r\u0012\nE\u0004\u0003&\t-bJ\u0014,\u000e\u0005\t\u001d\"b\u0001B\u0015\u000b\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0017\u0005O\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011y\"\u0001\u0005u_N#(/\u001b8h)\t\t\t-A\u0003baBd\u0017\u0010F\u0003W\u0005s\u0011Y\u0004C\u0003MA\u0001\u0007a\nC\u0003SA\u0001\u0007a*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005#Q\n\t\u0006\t\n\r#qI\u0005\u0004\u0005\u000b*%AB(qi&|g\u000eE\u0003E\u0005\u0013re*C\u0002\u0003L\u0015\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B(C\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B+!\u0011\t\u0019Ma\u0016\n\t\te\u0013Q\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
package.NullIntolerant,
Predicate,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap arraysOverlap) {
        return ArraysOverlap$.MODULE$.unapply(arraysOverlap);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    @Override
    public boolean leftArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.leftArrayElementNullable$(this);
    }

    @Override
    public boolean rightArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.rightArrayElementNullable$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            return TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), this.prettyName());
        }
        return typeCheckResult;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.doEvaluation$lzycompute();
        }
        return this.doEvaluation;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || this.leftArrayElementNullable() || this.rightArrayElementNullable();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            ArrayData bigger2 = (ArrayData)tuple23._1();
            ArrayData smaller2 = (ArrayData)tuple23._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$29, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$29), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$30, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$30), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$31, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$31), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString())).stripMargin();
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString())).stripMargin();
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString())).stripMargin();
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        if (this.inputTypes().exists((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$33)))) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())).stripMargin();
        }
        return code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    @Override
    public ArraysOverlap withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$29, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
            return;
        }
        smallestSet$1.add(v);
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$30, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
            return;
        }
        if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$32, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
            return;
        }
        if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$31, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
            return;
        }
        arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$32, v2) -> {
            ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$32), v2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$33) {
        return ((ArrayType)x$33).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        Predicate.$init$(this);
    }
}

