/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert;
import org.apache.spark.sql.catalyst.expressions.ArrayPendBase;
import org.apache.spark.sql.catalyst.expressions.ArrayPrepend$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(array, element) - Add the element at the beginning of the array passed as first\n      argument. Type of element should be the same as the type of the elements of the array.\n      Null element is also prepended to the array. But if the array passed is NULL\n      output is NULL\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'), 'd');\n       [\"d\",\"b\",\"d\",\"c\",\"a\"]\n      > SELECT _FUNC_(array(1, 2, 3, null), null);\n       [null,1,2,3,null]\n      > SELECT _FUNC_(CAST(null as Array<Int>), 2);\n       NULL\n  ", group="array_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\tu\u0001\u0011\t\u0012)A\u0005Q!A1\b\u0001BK\u0002\u0013\u0005\u0011\b\u0003\u0005=\u0001\tE\t\u0015!\u0003)\u0011\u0015i\u0004\u0001\"\u0001?\u0011!\u0011\u0005\u0001#b\u0001\n\u0003J\u0004\"B\"\u0001\t\u0003\"\u0005\"\u0002)\u0001\t#\n\u0006b\u0002,\u0001\u0003\u0003%\ta\u0016\u0005\b5\u0002\t\n\u0011\"\u0001\\\u0011\u001d1\u0007!%A\u0005\u0002mCqa\u001a\u0001\u0002\u0002\u0013\u0005\u0003\u000eC\u0004q\u0001\u0005\u0005I\u0011A9\t\u000fU\u0004\u0011\u0011!C\u0001m\"9A\u0010AA\u0001\n\u0003j\b\"CA\u0005\u0001\u0005\u0005I\u0011AA\u0006\u0011%\t)\u0002AA\u0001\n\u0003\n9bB\u0005\u0002<i\t\t\u0011#\u0001\u0002>\u0019A\u0011DGA\u0001\u0012\u0003\ty\u0004\u0003\u0004>'\u0011\u0005\u0011Q\n\u0005\n\u0003\u001f\u001a\u0012\u0011!C#\u0003#B\u0011\"a\u0015\u0014\u0003\u0003%\t)!\u0016\t\u0013\u0005m3#!A\u0005\u0002\u0006u\u0003\"CA8'\u0005\u0005I\u0011BA9\u00051\t%O]1z!J,\u0007/\u001a8e\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011#\u0002\u0001)Y=*\u0004CA\u0015+\u001b\u0005Q\u0012BA\u0016\u001b\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003S5J!A\f\u000e\u0003\u001b\u0005\u0013(/Y=QK:$')Y:f!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\r\u001c\n\u0005]\n$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012\u0001K\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\ry\u0004)\u0011\t\u0003S\u0001AQ\u0001O\u0003A\u0002!BQaO\u0003A\u0002!\n1B]3qY\u0006\u001cW-\\3oi\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0015\u0003\"AR'\u000f\u0005\u001d[\u0005C\u0001%2\u001b\u0005I%B\u0001&'\u0003\u0019a$o\\8u}%\u0011A*M\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002Mc\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u007fI#\u0006\"B*\t\u0001\u0004A\u0013a\u00028fo2+g\r\u001e\u0005\u0006+\"\u0001\r\u0001K\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\ry\u0004,\u0017\u0005\bq%\u0001\n\u00111\u0001)\u0011\u001dY\u0014\u0002%AA\u0002!\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001]U\tASlK\u0001_!\tyF-D\u0001a\u0015\t\t'-A\u0005v]\u000eDWmY6fI*\u00111-M\u0001\u000bC:tw\u000e^1uS>t\u0017BA3a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006!A.\u00198h\u0015\u0005q\u0017\u0001\u00026bm\u0006L!AT6\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003I\u0004\"\u0001M:\n\u0005Q\f$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HCA<{!\t\u0001\u00040\u0003\u0002zc\t\u0019\u0011I\\=\t\u000fmt\u0011\u0011!a\u0001e\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\u0012A \t\u0005\u007f\u0006\u0015q/\u0004\u0002\u0002\u0002)\u0019\u00111A\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0005\u0005!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0004\u0002\u0014A\u0019\u0001'a\u0004\n\u0007\u0005E\u0011GA\u0004C_>dW-\u00198\t\u000fm\u0004\u0012\u0011!a\u0001o\u00061Q-];bYN$B!!\u0004\u0002\u001a!910EA\u0001\u0002\u00049\bf\u0005\u0001\u0002\u001e\u0005\r\u0012QEA\u0015\u0003W\ty#!\r\u00026\u0005]\u0002cA\u0015\u0002 %\u0019\u0011\u0011\u0005\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qE\u0001\u0003P)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=-A\u0015dW-\\3oi&\u0002S\u0006I!eI\u0002\"\b.\u001a\u0011fY\u0016lWM\u001c;!CR\u0004C\u000f[3!E\u0016<\u0017N\u001c8j]\u001e\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002\u0002\u0018m]:fI\u0002\n7\u000f\t4jeN$(\u0002\t\u0011!A\u0001\u0002\u0013M]4v[\u0016tGO\f\u0011UsB,\u0007e\u001c4!K2,W.\u001a8uAMDw.\u001e7eA\t,\u0007\u0005\u001e5fAM\fW.\u001a\u0011bg\u0002\"\b.\u001a\u0011usB,\u0007e\u001c4!i\",\u0007%\u001a7f[\u0016tGo\u001d\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017P\f\u0006!A\u0001\u0002\u0003\u0005\t(vY2\u0004S\r\\3nK:$\b%[:!C2\u001cx\u000e\t9sKB,g\u000eZ3eAQ|\u0007\u0005\u001e5fA\u0005\u0014(/Y=/A\t+H\u000fI5gAQDW\rI1se\u0006L\b\u0005]1tg\u0016$\u0007%[:!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003e\\;uaV$\b%[:!\u001dVcEJ\u0003\u0011!A\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\t\u00111\u001d\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015(E\u001eb\u0003e\n3(Y\u0001:3m\n\u0017!O\u0005<\u0013\u0006\f\u0011(I\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#I\nb#E\u0019\u0012-E\u0011\u0014CFI2#Y\t\n'%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a-A9,H\u000e\\\u0015-A9,H\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AmsW\u000f\u001c7-c1\u0012Df\r\u0017ok2dWL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015D\u0003N#\u0006F\\;mY\u0002\n7\u000fI!se\u0006LH(\u00138u}%b\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012\u00111G\u0001\fCJ\u0014\u0018-_0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002:\u0005)1GL\u001b/a\u0005a\u0011I\u001d:bsB\u0013X\r]3oIB\u0011\u0011fE\n\u0005'\u0005\u0005S\u0007E\u0004\u0002D\u0005%\u0003\u0006K \u000e\u0005\u0005\u0015#bAA$c\u00059!/\u001e8uS6,\u0017\u0002BA&\u0003\u000b\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\ti$\u0001\u0005u_N#(/\u001b8h)\u0005I\u0017!B1qa2LH#B \u0002X\u0005e\u0003\"\u0002\u001d\u0017\u0001\u0004A\u0003\"B\u001e\u0017\u0001\u0004A\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003?\nY\u0007E\u00031\u0003C\n)'C\u0002\u0002dE\u0012aa\u00149uS>t\u0007#\u0002\u0019\u0002h!B\u0013bAA5c\t1A+\u001e9mKJB\u0001\"!\u001c\u0018\u0003\u0003\u0005\raP\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001d\u0011\u0007)\f)(C\u0002\u0002x-\u0014aa\u00142kK\u000e$\b")
public class ArrayPrepend
extends Expression
implements ArrayPendBase,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPrepend arrayPrepend) {
        return ArrayPrepend$.MODULE$.unapply(arrayPrepend);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPrepend> tupled() {
        return ArrayPrepend$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPrepend>> curried() {
        return ArrayPrepend$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return ArrayPendBase.inputTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayPendBase.checkInputDataTypes$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayPrepend arrayPrepend = this;
        synchronized (arrayPrepend) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ArrayPrepend arrayPrepend = this;
        synchronized (arrayPrepend) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        ArrayPrepend arrayPrepend = this;
        synchronized (arrayPrepend) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new ArrayInsert(this.left(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)), this.right());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "array_prepend";
    }

    @Override
    public ArrayPrepend withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayPrepend copy(Expression left, Expression right) {
        return new ArrayPrepend(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPrepend";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPrepend;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPrepend)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPrepend arrayPrepend = (ArrayPrepend)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPrepend.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPrepend.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPrepend.canEqual(this)) return false;
        return true;
    }

    public ArrayPrepend(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ArrayPendBase.$init$(this);
    }
}

