/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1. The maximum negative index is -1 for which the function inserts\n      new element after the current last element.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 4, 3, 2), -1, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -4, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\t%e\u0001\u0002\u0017.\u0001jB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\tE\t\u0015!\u0003Z\u0011!y\u0006A!f\u0001\n\u0003A\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B-\t\u0011\u0005\u0004!Q3A\u0005\u0002\tD\u0001B\u001a\u0001\u0003\u0012\u0003\u0006Ia\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006O\u0002!\tA\u001c\u0005\u0006e\u0002!\te\u001d\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011)\ti\u0002\u0001EC\u0002\u0013%\u0011q\u0004\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!a\u0015\u0001\t\u0003\n)\u0006\u0003\u0004\u0002r\u0001!\t\u0005\u0017\u0005\u0007\u0003g\u0002A\u0011\t-\t\r\u0005U\u0004\u0001\"\u0011Y\u0011\u001d\t9\b\u0001C!\u0003sBq!a#\u0001\t\u0003\ni\t\u0003\u0004\u0002\u0016\u0002!\tE\u0019\u0005\u000b\u0003/\u0003\u0001R1A\u0005\n\u00055\u0005bBAQ\u0001\u0011E\u00131\u0015\u0005\b\u0003c\u0003A\u0011IAZ\u0011%\t\u0019\rAA\u0001\n\u0003\t)\rC\u0005\u0002P\u0002\t\n\u0011\"\u0001\u0002R\"I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003S\u0004\u0011\u0013!C\u0001\u0003#D\u0011\"a;\u0001#\u0003%\t!!<\t\u0013\u0005E\b!!A\u0005B\u0005M\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\u0001B\u0003\u0011%\u00119\u0001AA\u0001\n\u0003\u0011I\u0001C\u0005\u0003\u0010\u0001\t\t\u0011\"\u0011\u0003\u0012!I!q\u0004\u0001\u0002\u0002\u0013\u0005!\u0011\u0005\u0005\n\u0005K\u0001\u0011\u0011!C!\u0005O9\u0011Ba\u0013.\u0003\u0003E\tA!\u0014\u0007\u00111j\u0013\u0011!E\u0001\u0005\u001fBaa\u001a\u0014\u0005\u0002\tu\u0003\"\u0003B0M\u0005\u0005IQ\tB1\u0011%\u0011\u0019GJA\u0001\n\u0003\u0013)\u0007C\u0005\u0003p\u0019\n\t\u0011\"!\u0003r!I!q\u0010\u0014\u0002\u0002\u0013%!\u0011\u0011\u0002\f\u0003J\u0014\u0018-_%og\u0016\u0014HO\u0003\u0002/_\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0014'\u0001\u0005dCR\fG._:u\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'!\u00011h\u0010\"F\u0017:#\u0006C\u0001\u001f>\u001b\u0005i\u0013B\u0001 .\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003y\u0001K!!Q\u0017\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001P\"\n\u0005\u0011k#\u0001H\"p[BdW\r\u001f+za\u0016lUM]4j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011F\na!\u001a:s_J\u001c\u0018B\u0001&H\u0005=\tV/\u001a:z\u000bJ\u0014xN]:CCN,\u0007C\u0001\u001fM\u0013\tiUFA\nTkB\u0004xN\u001d;Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006KA\u0004Qe>$Wo\u0019;\u0011\u0005=+\u0016B\u0001,Q\u00051\u0019VM]5bY&T\u0018M\u00197f\u00031\u0019(oY!se\u0006LX\t\u001f9s+\u0005I\u0006C\u0001\u001f[\u0013\tYVF\u0001\u0006FqB\u0014Xm]:j_:\fQb\u001d:d\u0003J\u0014\u0018-_#yaJ\u0004\u0013a\u00029pg\u0016C\bO]\u0001\ta>\u001cX\t\u001f9sA\u0005A\u0011\u000e^3n\u000bb\u0004(/A\u0005ji\u0016lW\t\u001f9sA\u0005\u0019B.Z4bGftUmZ1uSZ,\u0017J\u001c3fqV\t1\r\u0005\u0002PI&\u0011Q\r\u0015\u0002\b\u0005>|G.Z1o\u0003QaWmZ1ds:+w-\u0019;jm\u0016Le\u000eZ3yA\u00051A(\u001b8jiz\"R!\u001b6lY6\u0004\"\u0001\u0010\u0001\t\u000b]K\u0001\u0019A-\t\u000buK\u0001\u0019A-\t\u000b}K\u0001\u0019A-\t\u000b\u0005L\u0001\u0019A2\u0015\t%|\u0007/\u001d\u0005\u0006/*\u0001\r!\u0017\u0005\u0006;*\u0001\r!\u0017\u0005\u0006?*\u0001\r!W\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001;\u0011\tUl\u0018\u0011\u0001\b\u0003mnt!a\u001e>\u000e\u0003aT!!_\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0016B\u0001?Q\u0003\u001d\u0001\u0018mY6bO\u0016L!A`@\u0003\u0007M+\u0017O\u0003\u0002}!B!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bE\nQ\u0001^=qKNLA!a\u0003\u0002\u0006\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/y\u0013\u0001C1oC2L8/[:\n\t\u0005m\u0011Q\u0003\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Y\u0001o\\:ji&4X\rU8t+\t\t\t\u0003E\u0003P\u0003G\t9#C\u0002\u0002&A\u0013aa\u00149uS>t\u0007cA(\u0002*%\u0019\u00111\u0006)\u0003\u0007%sG/\u0001\u0003fm\u0006dG\u0003BA\u0019\u0003o\u00012aTA\u001a\u0013\r\t)\u0004\u0015\u0002\u0004\u0003:L\b\"CA\u001d\u001dA\u0005\t\u0019AA\u001e\u0003\u0015Ig\u000e];u!\u0011\ti$a\u0010\u000e\u0003=J1!!\u00110\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005E\u0012qIA&\u0003\u001fBq!!\u0013\u0010\u0001\u0004\t\t$A\u0002beJDq!!\u0014\u0010\u0001\u0004\t\t$A\u0002q_NDq!!\u0015\u0010\u0001\u0004\t\t$\u0001\u0003ji\u0016l\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9&a\u0019\u0002nA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^5\nqaY8eK\u001e,g.\u0003\u0003\u0002b\u0005m#\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002h\u0005\u00191\r\u001e=\u0011\t\u0005e\u0013\u0011N\u0005\u0005\u0003W\nYF\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005=\u0004\u00031\u0001\u0002X\u0005\u0011QM^\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002|A!\u0011QPAC\u001d\u0011\ty(!!\u0011\u0005]\u0004\u0016bAAB!\u00061\u0001K]3eK\u001aLA!a\"\u0002\n\n11\u000b\u001e:j]\u001eT1!a!Q\u0003!!\u0017\r^1UsB,WCAAH!\u0011\t\u0019!!%\n\t\u0005M\u0015Q\u0001\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-A\u0006fY\u0016lWM\u001c;UsB,\u0007fA\f\u0002\u001cB\u0019q*!(\n\u0007\u0005}\u0005KA\u0005ue\u0006t7/[3oi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\bS\u0006\u0015\u0016\u0011VAW\u0011\u0019\t9\u000b\u0007a\u00013\u0006ya.Z<Te\u000e\f%O]1z\u000bb\u0004(\u000f\u0003\u0004\u0002,b\u0001\r!W\u0001\u000b]\u0016<\bk\\:FqB\u0014\bBBAX1\u0001\u0007\u0011,A\u0006oK^LE/Z7FqB\u0014\u0018\u0001E5oSR\fV/\u001a:z\u0007>tG/\u001a=u)\t\t)\fE\u0003P\u0003G\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\tilL\u0001\u0006iJ,Wm]\u0005\u0005\u0003\u0003\fYLA\bT#2\u000bV/\u001a:z\u0007>tG/\u001a=u\u0003\u0011\u0019w\u000e]=\u0015\u0013%\f9-!3\u0002L\u00065\u0007bB,\u001b!\u0003\u0005\r!\u0017\u0005\b;j\u0001\n\u00111\u0001Z\u0011\u001dy&\u0004%AA\u0002eCq!\u0019\u000e\u0011\u0002\u0003\u00071-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M'fA-\u0002V.\u0012\u0011q\u001b\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003%)hn\u00195fG.,GMC\u0002\u0002bB\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)/a7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAAxU\r\u0019\u0017Q[\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\b\u0003BA|\u0005\u0003i!!!?\u000b\t\u0005m\u0018Q`\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0006!!.\u0019<b\u0013\u0011\t9)!?\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\u0011Y\u0001C\u0005\u0003\u000e\u0005\n\t\u00111\u0001\u0002(\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0005\u0011\r\tU!1DA\u0019\u001b\t\u00119BC\u0002\u0003\u001aA\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iBa\u0006\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004G\n\r\u0002\"\u0003B\u0007G\u0005\u0005\t\u0019AA\u0019\u0003\u0019)\u0017/^1mgR\u00191M!\u000b\t\u0013\t5A%!AA\u0002\u0005E\u0002f\u0005\u0001\u0003.\tM\"Q\u0007B\u001d\u0005w\u0011yD!\u0011\u0003F\t\u001d\u0003c\u0001\u001f\u00030%\u0019!\u0011G\u0017\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qG\u0001\u0003\u001c*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015yY\u0001\u0002xn\u001d\u0017!m\u0006d\u0017\u0006I\u0017!!2\f7-Z:!m\u0006d\u0007%\u001b8u_\u0002Jg\u000eZ3yAA|7\u000fI8gA\u0005\u0014(/Y=!q:R\u0001\u0005\t\u0011!A\u0001\n%O]1zA%tG-[2fg\u0002\u001aH/\u0019:uA\u0005$\b%\r\u0018!)\",\u0007%\\1yS6,X\u000e\t8fO\u0006$\u0018N^3!S:$W\r\u001f\u0011jg\u0002j\u0013\u0007\t4pe\u0002:\b.[2iAQDW\r\t4v]\u000e$\u0018n\u001c8!S:\u001cXM\u001d;t\u0015\u0001\u0002\u0003\u0005\t\u0011!]\u0016<\b%\u001a7f[\u0016tG\u000fI1gi\u0016\u0014\b\u0005\u001e5fA\r,(O]3oi\u0002b\u0017m\u001d;!K2,W.\u001a8u])\u0001\u0003\u0005\t\u0011!A%sG-\u001a=!C\n|g/\u001a\u0011beJ\f\u0017\u0010I:ju\u0016\u0004\u0013\r\u001d9f]\u0012\u001c\b\u0005\u001e5fA\u0005\u0014(/Y=-A=\u0014\b\u0005\u001d:fa\u0016tGm\u001d\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002Jg\rI5oI\u0016D\b%[:!]\u0016<\u0017\r^5wK2R\u0001\u0005\t\u0011!A\u0001:\u0018\u000e\u001e5!O9,H\u000e\\\u0014!K2,W.\u001a8ug:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QH\u0001\u0002:*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMb\u0003\u0005N\u0015-AUb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u000bDF\r\u00174YQbS'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00156Y\u0001\"D\u0006I\u001a-AIJC\u0006I\u00172Y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\k1\"Df\r\u00173YEj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\u000e\u0017!g1\u0002#\u0007\f\u00112S1\u0002S\u0006\u000e\u0017!i%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001b-i1\u001aDF\r\u00172;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003D\u0005Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011I%A\u00034]Qr\u0003'A\u0006BeJ\f\u00170\u00138tKJ$\bC\u0001\u001f''\u00111#\u0011\u000b+\u0011\u0013\tM#\u0011L-Z3\u000eLWB\u0001B+\u0015\r\u00119\u0006U\u0001\beVtG/[7f\u0013\u0011\u0011YF!\u0016\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003N\u0005AAo\\*ue&tw\r\u0006\u0002\u0002v\u0006)\u0011\r\u001d9msRI\u0011Na\u001a\u0003j\t-$Q\u000e\u0005\u0006/&\u0002\r!\u0017\u0005\u0006;&\u0002\r!\u0017\u0005\u0006?&\u0002\r!\u0017\u0005\u0006C&\u0002\raY\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ha\u001f\u0011\u000b=\u000b\u0019C!\u001e\u0011\u000f=\u00139(W-ZG&\u0019!\u0011\u0010)\u0003\rQ+\b\u000f\\35\u0011!\u0011iHKA\u0001\u0002\u0004I\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\t\u0005\u0003\u0002x\n\u0015\u0015\u0002\u0002BD\u0003s\u0014aa\u00142kK\u000e$\b")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private Option<Object> positivePos;
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private final boolean legacyNegativeIndex;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(ArrayInsert arrayInsert) {
        return ArrayInsert$.MODULE$.unapply(arrayInsert);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, ArrayInsert>>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    public boolean legacyNegativeIndex() {
        return this.legacyNegativeIndex;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            return (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$)));
                        }
                        return (Seq)Nil$.MODULE$;
                    }
                }
            }
        }
        if (tuple3 != null) {
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError((Object)tuple3);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.second().dataType()))}))));
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType).elementType(), e3)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.third().dataType()))}))));
    }

    private Option<Object> positivePos$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                InternalRow x$1;
                Expression qual$1;
                int pos;
                this.positivePos = this.second().foldable() ? ((pos = BoxesRunTime.unboxToInt((Object)(qual$1 = this.second()).eval(x$1 = qual$1.eval$default$1()))) > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)pos)) : None$.MODULE$) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.positivePos;
    }

    private Option<Object> positivePos() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.positivePos$lzycompute();
        }
        return this.positivePos;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        boolean newPosExtendsArrayLeft;
        ArrayData baseArr = (ArrayData)arr;
        if (this.positivePos().isDefined()) {
            int newArrayLength = package$.MODULE$.max(baseArr.numElements() + 1, BoxesRunTime.unboxToInt((Object)this.positivePos().get()));
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            int posInt = BoxesRunTime.unboxToInt((Object)this.positivePos().get()) - 1;
            baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$9(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[posInt] = item;
            return new GenericArrayData(newArray);
        }
        IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
        if (posInt.elem == 0) {
            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
        }
        boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
        if (newPosExtendsArrayLeft) {
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            int newArrayLength = -posInt.elem + baseOffset;
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$10(baseOffset, posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[0] = item;
            return new GenericArrayData(newArray);
        }
        if (posInt.elem < 0) {
            posInt.elem = posInt.elem + baseArr.numElements() + (this.legacyNegativeIndex() ? 0 : 1);
        } else if (posInt.elem > 0) {
            --posInt.elem;
        }
        int newArrayLength = package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
        }
        Object[] newArray = new Object[newArrayLength];
        baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayInsert.$anonfun$nullSafeEval$11(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        newArray[posInt.elem] = item;
        return new GenericArrayData(newArray);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Function3 & Serializable & scala.Serializable f = (Function3 & Serializable & scala.Serializable)(arrExpr, posExpr, itemExpr) -> {
            ExprValue arr = arrExpr.value();
            ExprValue item = itemExpr.value();
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(8).append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            if (this.positivePos().isDefined()) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(630).append("\n           |int ").append(itemInsertionIndex).append(" = ").append(BoxesRunTime.unboxToInt((Object)this.positivePos().get()) - 1).append(";\n           |int ").append(adjustedAllocIdx).append(" = 0;\n           |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n           |\n           |final int ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(this.positivePos().get()).append(");\n           |if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n           |  throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n           |}\n           |\n           |").append(allocation).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n           |  ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n           |  if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n           |    ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n           |  }\n           |  ").append(assignment).append("\n           |}\n           |").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n           |\n           |for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n           |  ").append(values).append(".setNullAt(").append(j).append(");\n           |}\n           |\n           |").append(ev.value()).append(" = ").append(values).append(";\n           |").toString())).stripMargin();
            }
            ExprValue pos = posExpr.value();
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1662).append("\n           |int ").append(itemInsertionIndex).append(" = 0;\n           |int ").append(resLength).append(" = 0;\n           |int ").append(adjustedAllocIdx).append(" = 0;\n           |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n           |\n           |if (").append(pos).append(" == 0) {\n           |  throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n           |}\n           |\n           |if (").append(pos).append(" < 0 && (java.lang.Math.abs(").append(pos).append(") > ").append(arr).append(".numElements())) {\n           |\n           |  ").append(resLength).append(" = java.lang.Math.abs(").append(pos).append(") + ").append(baseOffset).append(";\n           |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n           |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n           |  }\n           |\n           |  ").append(allocation).append("\n           |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n           |    ").append(adjustedAllocIdx).append(" = ").append(i).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements());\n           |    ").append(assignment).append("\n           |  }\n           |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n           |\n           |  for (int ").append(j).append(" = ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(" + ").append(pos).append(" + ").append(arr).append(".numElements(); ").append(j).append(" < 0; ").append(j).append(" ++) {\n           |    ").append(values).append(".setNullAt(").append(j).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements()));\n           |  }\n           |\n           |  ").append(ev.value()).append(" = ").append(values).append(";\n           |} else {\n           |\n           |  ").append(itemInsertionIndex).append(" = 0;\n           |  if (").append(pos).append(" < 0) {\n           |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" + ").append(arr).append(".numElements() + ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(";\n           |  } else if (").append(pos).append(" > 0) {\n           |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" - 1;\n           |  }\n           |\n           |  ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(itemInsertionIndex).append(" + 1);\n           |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n           |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n           |  }\n           |\n           |  ").append(allocation).append("\n           |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n           |    ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n           |    if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n           |      ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n           |    }\n           |    ").append(assignment).append("\n           |  }\n           |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n           |\n           |  for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n           |    ").append(values).append(".setNullAt(").append(j).append(");\n           |  }\n           |\n           |  ").append(ev.value()).append(" = ").append(values).append(";\n           |}\n           |").toString())).stripMargin();
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)midGen.code()), ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), new StringBuilder(67).append("\n              ").append(rightGen.code()).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n            ").toString()))));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr, this.copy$default$4());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr, legacyNegativeIndex);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    public boolean copy$default$4() {
        return this.legacyNegativeIndex();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcArrayExpr();
            }
            case 1: {
                return this.posExpr();
            }
            case 2: {
                return this.itemExpr();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacyNegativeIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.legacyNegativeIndex() != arrayInsert.legacyNegativeIndex()) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$9(int posInt$1, Object[] newArray$2, int i, Object v) {
        if (i >= posInt$1) {
            newArray$2[i + 1] = v;
            return;
        }
        newArray$2[i] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$10(int baseOffset$1, IntRef posInt$2, ArrayData baseArr$1, Object[] newArray$3, int i, Object v) {
        int elementPosition = i + baseOffset$1 + package$.MODULE$.abs(posInt$2.elem + baseArr$1.numElements());
        newArray$3[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$11(IntRef posInt$2, Object[] newArray$4, int i, Object v) {
        if (i >= posInt$2.elem) {
            newArray$4[i + 1] = v;
            return;
        }
        newArray$4[i] = v;
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        this.legacyNegativeIndex = legacyNegativeIndex;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this(srcArrayExpr, posExpr, itemExpr, SQLConf$.MODULE$.get().legacyNegativeIndexInArrayInsert());
    }
}

