/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayAppend$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert;
import org.apache.spark.sql.catalyst.expressions.ArrayPendBase;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(array, element) - Add the element at the end of the array passed as first\n      argument. Type of element should be similar to type of the elements of the array.\n      Null element is also appended into the array. But if the array passed, is NULL\n      output is NULL\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'), 'd');\n       [\"b\",\"d\",\"c\",\"a\",\"d\"]\n      > SELECT _FUNC_(array(1, 2, 3, null), null);\n       [1,2,3,null,null]\n      > SELECT _FUNC_(CAST(null as Array<Int>), 2);\n       NULL\n  ", since="3.4.0", group="array_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\tu\u0001\u0011\t\u0012)A\u0005Q!A1\b\u0001BK\u0002\u0013\u0005\u0011\b\u0003\u0005=\u0001\tE\t\u0015!\u0003)\u0011\u0015i\u0004\u0001\"\u0001?\u0011!\u0011\u0005\u0001#b\u0001\n\u0003J\u0004\"B\"\u0001\t\u0003\"\u0005\"\u0002)\u0001\t#\n\u0006b\u0002,\u0001\u0003\u0003%\ta\u0016\u0005\b5\u0002\t\n\u0011\"\u0001\\\u0011\u001d1\u0007!%A\u0005\u0002mCqa\u001a\u0001\u0002\u0002\u0013\u0005\u0003\u000eC\u0004q\u0001\u0005\u0005I\u0011A9\t\u000fU\u0004\u0011\u0011!C\u0001m\"9A\u0010AA\u0001\n\u0003j\b\"CA\u0005\u0001\u0005\u0005I\u0011AA\u0006\u0011%\t)\u0002AA\u0001\n\u0003\n9bB\u0005\u0002<i\t\t\u0011#\u0001\u0002>\u0019A\u0011DGA\u0001\u0012\u0003\ty\u0004\u0003\u0004>'\u0011\u0005\u0011Q\n\u0005\n\u0003\u001f\u001a\u0012\u0011!C#\u0003#B\u0011\"a\u0015\u0014\u0003\u0003%\t)!\u0016\t\u0013\u0005m3#!A\u0005\u0002\u0006u\u0003\"CA8'\u0005\u0005I\u0011BA9\u0005-\t%O]1z\u0003B\u0004XM\u001c3\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0015-_U\u0002\"!\u000b\u0016\u000e\u0003iI!a\u000b\u000e\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002*[%\u0011aF\u0007\u0002\u000e\u0003J\u0014\u0018-\u001f)f]\u0012\u0014\u0015m]3\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001GN\u0005\u0003oE\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\t\u0001&A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u0002\u0015\t\u0005\u0002*\u0001!)\u0001(\u0002a\u0001Q!)1(\u0002a\u0001Q\u0005Y!/\u001a9mC\u000e,W.\u001a8u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u000bB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u0019\u000e\u0003%S!A\u0013\u0014\u0002\rq\u0012xn\u001c;?\u0013\ta\u0015'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'2\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002@%RCQa\u0015\u0005A\u0002!\nqA\\3x\u0019\u00164G\u000fC\u0003V\u0011\u0001\u0007\u0001&\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007}B\u0016\fC\u00049\u0013A\u0005\t\u0019\u0001\u0015\t\u000fmJ\u0001\u0013!a\u0001Q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001/+\u0005!j6&\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017!C;oG\",7m[3e\u0015\t\u0019\u0017'\u0001\u0006b]:|G/\u0019;j_:L!!\u001a1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0011a\u0017M\\4\u000b\u00039\fAA[1wC&\u0011aj[\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002eB\u0011\u0001g]\u0005\u0003iF\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"a\u001e>\u0011\u0005AB\u0018BA=2\u0005\r\te.\u001f\u0005\bw:\t\t\u00111\u0001s\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\ta\u0010\u0005\u0003\u0000\u0003\u000b9XBAA\u0001\u0015\r\t\u0019!M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0004\u0003\u0003\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QBA\n!\r\u0001\u0014qB\u0005\u0004\u0003#\t$a\u0002\"p_2,\u0017M\u001c\u0005\bwB\t\t\u00111\u0001x\u0003\u0019)\u0017/^1mgR!\u0011QBA\r\u0011\u001dY\u0018#!AA\u0002]D3\u0003AA\u000f\u0003G\t)#!\u000b\u0002,\u0005=\u0012\u0011GA\u001b\u0003o\u00012!KA\u0010\u0013\r\t\tC\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9#\u0001B!\u0015\u0001\u0002\u0003\u0005\t\u0011!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!K2,W.\u001a8uS\u0001j\u0003%\u00113eAQDW\rI3mK6,g\u000e\u001e\u0011bi\u0002\"\b.\u001a\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002\u0002\u0018m]:fI\u0002\n7\u000f\t4jeN$(\u0002\t\u0011!A\u0001\u0002\u0013M]4v[\u0016tGO\f\u0011UsB,\u0007e\u001c4!K2,W.\u001a8uAMDw.\u001e7eA\t,\u0007e]5nS2\f'\u000f\t;pAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011fY\u0016lWM\u001c;tA=4\u0007\u0005\u001e5fA\u0005\u0014(/Y=/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u001dVdG\u000eI3mK6,g\u000e\u001e\u0011jg\u0002\nGn]8!CB\u0004XM\u001c3fI\u0002Jg\u000e^8!i\",\u0007%\u0019:sCft\u0003EQ;uA%4\u0007\u0005\u001e5fA\u0005\u0014(/Y=!a\u0006\u001c8/\u001a3-A%\u001c\bET+M\u0019*\u0001\u0003\u0005\t\u0011!A=,H\u000f];uA%\u001c\bET+M\u0019*\u0001\u0003\u0005\t\u0011!A\u0005AQ\r_1na2,7/\t\u0002\u0002.\u0005\t\u0019O\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014cO1\u0002s\u0005Z\u0014-A\u001d\u001aw\u0005\f\u0011(C\u001eJC\u0006I\u0014eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012cE1\u0012CM\t\u0017#G\nb#%\u0019\u0012-E\u0011\u0014SL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003e\r\u0017!]VdG.\u000b\u0017!]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb#\u0007L\u001a-]VdG\u000e\f8vY2l&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\"B'RCc.\u001e7mA\u0005\u001c\b%\u0011:sCfd\u0014J\u001c;?S1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019$A\u00034]Qr\u0003'A\u0003he>,\b/\t\u0002\u0002:\u0005Y\u0011M\u001d:bs~3WO\\2t\u0003-\t%O]1z\u0003B\u0004XM\u001c3\u0011\u0005%\u001a2\u0003B\n\u0002BU\u0002r!a\u0011\u0002J!Bs(\u0004\u0002\u0002F)\u0019\u0011qI\u0019\u0002\u000fI,h\u000e^5nK&!\u00111JA#\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003{\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002S\u0006)\u0011\r\u001d9msR)q(a\u0016\u0002Z!)\u0001H\u0006a\u0001Q!)1H\u0006a\u0001Q\u00059QO\\1qa2LH\u0003BA0\u0003W\u0002R\u0001MA1\u0003KJ1!a\u00192\u0005\u0019y\u0005\u000f^5p]B)\u0001'a\u001a)Q%\u0019\u0011\u0011N\u0019\u0003\rQ+\b\u000f\\33\u0011!\tigFA\u0001\u0002\u0004y\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\bE\u0002k\u0003kJ1!a\u001el\u0005\u0019y%M[3di\u0002")
public class ArrayAppend
extends Expression
implements ArrayPendBase,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayAppend arrayAppend) {
        return ArrayAppend$.MODULE$.unapply(arrayAppend);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayAppend> tupled() {
        return ArrayAppend$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayAppend>> curried() {
        return ArrayAppend$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return ArrayPendBase.inputTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayPendBase.checkInputDataTypes$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new ArrayInsert(this.left(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)), this.right());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "array_append";
    }

    @Override
    public ArrayAppend withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayAppend copy(Expression left, Expression right) {
        return new ArrayAppend(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayAppend";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayAppend;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayAppend)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayAppend arrayAppend = (ArrayAppend)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayAppend.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayAppend.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayAppend.canEqual(this)) return false;
        return true;
    }

    public ArrayAppend(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ArrayPendBase.$init$(this);
    }
}

