/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u000e\u001d\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003F\u0001\u0011\u0005a\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\ra\u0003\u0001\u0015!\u0003N\u0011\u001dI\u0006A1A\u0005\niCaA\u0018\u0001!\u0002\u0013YV\u0001B0\u0001\t\u0001Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004}\u0001\u0001\u0006Ia\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\tY\u0001\u0001Q\u0001\n}D\u0001\"!\u0004\u0001\u0005\u0004%IA \u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003\u0000\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000b\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA;\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003o\u0002A\u0011AA1\u0005I)f.\u001b<pG&$\u0018pR3oKJ\fGo\u001c:\u000b\u0005uq\u0012aA2tm*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\rM\u001c\u0007.Z7b!\t\u0011T'D\u00014\u0015\t!\u0004%A\u0003usB,7/\u0003\u00027g\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\r]\u0014\u0018\u000e^3s!\tId(D\u0001;\u0015\tYD(\u0001\u0002j_*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\u00199&/\u001b;fe\u00069q\u000e\u001d;j_:\u001c\bC\u0001\"D\u001b\u0005a\u0012B\u0001#\u001d\u0005)\u00195KV(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dC\u0015J\u0013\t\u0003\u0005\u0002AQ\u0001\r\u0003A\u0002EBQa\u000e\u0003A\u0002aBQ\u0001\u0011\u0003A\u0002\u0005\u000bab\u001e:ji\u0016\u00148+\u001a;uS:<7/F\u0001N!\tqe+D\u0001P\u0015\ti\u0002K\u0003\u0002R%\u00069\u0001/\u0019:tKJ\u001c(BA*U\u0003%)h.\u001b<pG&$\u0018PC\u0001V\u0003\r\u0019w.\\\u0005\u0003/>\u0013\u0011cQ:w/JLG/\u001a:TKR$\u0018N\\4t\u0003=9(/\u001b;feN+G\u000f^5oON\u0004\u0013aA4f]V\t1\f\u0005\u0002O9&\u0011Ql\u0014\u0002\n\u0007N4xK]5uKJ\fAaZ3oA\tqa+\u00197vK\u000e{gN^3si\u0016\u0014\b#B\u0016bG\u001eT\u0017B\u00012-\u0005%1UO\\2uS>t'\u0007\u0005\u0002eK6\ta$\u0003\u0002g=\tY\u0011J\u001c;fe:\fGNU8x!\tY\u0003.\u0003\u0002jY\t\u0019\u0011J\u001c;\u0011\u0005-\u0014hB\u00017q!\tiG&D\u0001o\u0015\ty\u0007&\u0001\u0004=e>|GOP\u0005\u0003c2\na\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000fL\u0001\u0010m\u0006dW/Z\"p]Z,'\u000f^3sgV\tq\u000fE\u0002,qjL!!\u001f\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\u0005mLQ\"\u0001\u0001\u0002!Y\fG.^3D_:4XM\u001d;feN\u0004\u0013A\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0010\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM]\u0001\u0017i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3sA\u0005iA-\u0019;f\r>\u0014X.\u0019;uKJ,\"!!\u0006\u0011\t\u0005\u0005\u0011qC\u0005\u0005\u00033\t\u0019AA\u0007ECR,gi\u001c:nCR$XM]\u0001\u000fI\u0006$XMR8s[\u0006$H/\u001a:!\u0003]qW\u000f\u001c7BgF+x\u000e^3e\u000b6\u0004H/_*ue&tw-\u0006\u0002\u0002\"A\u00191&a\t\n\u0007\u0005\u0015BFA\u0004C_>dW-\u00198\u000219,H\u000e\\!t#V|G/\u001a3F[B$\u0018p\u0015;sS:<\u0007%A\u0007nC.,7i\u001c8wKJ$XM\u001d\u000b\u0004u\u00065\u0002bBA\u0018)\u0001\u0007\u0011\u0011G\u0001\tI\u0006$\u0018\rV=qKB\u0019!'a\r\n\u0007\u0005U2G\u0001\u0005ECR\fG+\u001f9fQ\r!\u0012\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005u\"a\u0002;bS2\u0014XmY\u0001\u000bG>tg/\u001a:u%><H\u0003BA%\u00037\u0002R!a\u0013\u0002V)tA!!\u0014\u0002R9\u0019Q.a\u0014\n\u00035J1!a\u0015-\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0016\u0002Z\t\u00191+Z9\u000b\u0007\u0005MC\u0006\u0003\u0004\u0002^U\u0001\raY\u0001\u0004e><\u0018\u0001D<sSR,\u0007*Z1eKJ\u001cHCAA2!\rY\u0013QM\u0005\u0004\u0003Ob#\u0001B+oSR\fQa\u001e:ji\u0016$B!a\u0019\u0002n!1\u0011QL\fA\u0002\r\fQb\u001e:ji\u0016$vn\u0015;sS:<Gc\u00016\u0002t!1\u0011Q\f\rA\u0002\r\fQa\u00197pg\u0016\fQA\u001a7vg\"\u0004")
public class UnivocityGenerator {
    private final CSVOptions options;
    private final CsvWriterSettings writerSettings;
    private final CsvWriter gen;
    private final Function2<InternalRow, Object, String>[] valueConverters;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private final boolean nullAsQuotedEmptyString;

    private CsvWriterSettings writerSettings() {
        return this.writerSettings;
    }

    private CsvWriter gen() {
        return this.gen;
    }

    private Function2<InternalRow, Object, String>[] valueConverters() {
        return this.valueConverters;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private boolean nullAsQuotedEmptyString() {
        return this.nullAsQuotedEmptyString;
    }

    private Function2<InternalRow, Object, String> makeConverter(DataType dataType) {
        DataType dataType2;
        while (true) {
            if (DateType$.MODULE$.equals(dataType2 = dataType)) {
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (dataType2 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> IntervalUtils$.MODULE$.toYearMonthIntervalString(row.getInt(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (dataType2 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> IntervalUtils$.MODULE$.toDayTimeIntervalString(row.getLong(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (dataType2 != null) {
            DataType dataType3 = dataType2;
            return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$6(dataType3, row, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        throw new MatchError((Object)dataType2);
    }

    private Seq<String> convertRow(InternalRow row) {
        String[] values = new String[row.numFields()];
        for (int i = 0; i < row.numFields(); ++i) {
            if (!row.isNullAt(i)) {
                values[i] = (String)this.valueConverters()[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.nullAsQuotedEmptyString()) continue;
            values[i] = this.options.nullValue();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])values);
    }

    public void writeHeaders() {
        this.gen().writeHeaders();
    }

    public void write(InternalRow row) {
        this.gen().writeRow((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String writeToString(InternalRow row) {
        return this.gen().writeRowToString((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$1(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.dateFormatter().format(row.getInt(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$2(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.timestampFormatter().format(row.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$3(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(row.getLong(ordinal)));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$6(DataType x8$1, InternalRow row, int ordinal) {
        return row.get(ordinal, x8$1).toString();
    }

    public UnivocityGenerator(StructType schema, Writer writer, CSVOptions options) {
        this.options = options;
        this.writerSettings = options.asWriterSettings();
        this.writerSettings().setHeaders(schema.fieldNames());
        this.gen = new CsvWriter(writer, this.writerSettings());
        this.valueConverters = (Function2[])((TraversableOnce)((TraversableLike)schema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.nullAsQuotedEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_NULL_VALUE_WRITTEN_AS_QUOTED_EMPTY_STRING_CSV()));
    }
}

