/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.testutils.logging.LoggerAuditingExtension;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobIDLoggingUtil {
    private static final Logger logger = LoggerFactory.getLogger(JobIDLoggingUtil.class);

    public static void assertKeyPresent(String key, Set<String> expectedValues, LoggerAuditingExtension ext, List<String> expectedPatterns, String ... ignoredPatterns) {
        ArrayList<LogEvent> eventsWithMissingKey = new ArrayList<LogEvent>();
        ArrayList<LogEvent> eventsWithWrongValue = new ArrayList<LogEvent>();
        ArrayList<LogEvent> ignoredEvents = new ArrayList<LogEvent>();
        List expected = expectedPatterns.stream().map(Pattern::compile).collect(Collectors.toList());
        List<Pattern> ignorePatterns = Arrays.stream(ignoredPatterns).map(Pattern::compile).collect(Collectors.toList());
        for (LogEvent e : ext.getEvents()) {
            ReadOnlyStringMap context = e.getContextData();
            if (context.containsKey(key)) {
                if (expectedValues.contains(context.getValue(key))) {
                    expected.removeIf(pattern -> pattern.matcher(e.getMessage().getFormattedMessage()).matches());
                    continue;
                }
                eventsWithWrongValue.add(e);
                continue;
            }
            if (JobIDLoggingUtil.matchesAny(ignorePatterns, e.getMessage().getFormattedMessage())) {
                ignoredEvents.add(e);
                continue;
            }
            eventsWithMissingKey.add(e);
        }
        logger.debug("checked events for {}:\n  {};\n  ignored: {},\n  wrong value: {},\n missing key: {}", new Object[]{ext.getLoggerName(), ext.getEvents(), ignoredEvents, eventsWithWrongValue, eventsWithMissingKey});
        ((ListAssert)Assertions.assertThat(eventsWithWrongValue).as("events with a wrong value", new Object[0])).isEmpty();
        ((ListAssert)Assertions.assertThat(expected).as("not all expected events logged by %s, logged:\n%s", new Object[]{ext.getLoggerName(), ext.getEvents()})).isEmpty();
        ((ListAssert)Assertions.assertThat(eventsWithMissingKey).as("too many events without key logged by %s", new Object[]{ext.getLoggerName()})).isEmpty();
    }

    public static void assertKeyPresent(String key, String expectedValue, LoggerAuditingExtension ext, List<String> expectedPatterns, String ... ignoredPatterns) {
        JobIDLoggingUtil.assertKeyPresent(key, Collections.singleton(expectedValue), ext, expectedPatterns, ignoredPatterns);
    }

    private static boolean matchesAny(List<Pattern> patterns, String message) {
        return patterns.stream().anyMatch(pattern -> pattern.matcher(message).matches());
    }
}

