/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.s3;

import javax.annotation.Nullable;
import org.junit.Assume;

public class S3TestCredentials {
    @Nullable
    private static final String S3_TEST_BUCKET = System.getenv("IT_CASE_S3_BUCKET");
    @Nullable
    private static final String S3_TEST_ACCESS_KEY = System.getenv("IT_CASE_S3_ACCESS_KEY");
    @Nullable
    private static final String S3_TEST_SECRET_KEY = System.getenv("IT_CASE_S3_SECRET_KEY");

    private static boolean credentialsAvailable() {
        return S3TestCredentials.isNotEmpty(S3_TEST_BUCKET) && S3TestCredentials.isNotEmpty(S3_TEST_ACCESS_KEY) && S3TestCredentials.isNotEmpty(S3_TEST_SECRET_KEY);
    }

    private static boolean isNotEmpty(@Nullable String str) {
        return str != null && !str.isEmpty();
    }

    public static void assumeCredentialsAvailable() {
        Assume.assumeTrue((String)"No S3 credentials available in this test's environment", (boolean)S3TestCredentials.credentialsAvailable());
    }

    public static String getS3AccessKey() {
        if (S3_TEST_ACCESS_KEY != null) {
            return S3_TEST_ACCESS_KEY;
        }
        throw new IllegalStateException("S3 test access key not available");
    }

    public static String getS3SecretKey() {
        if (S3_TEST_SECRET_KEY != null) {
            return S3_TEST_SECRET_KEY;
        }
        throw new IllegalStateException("S3 test secret key not available");
    }

    public static String getTestBucketUri() {
        return S3TestCredentials.getTestBucketUriWithScheme("s3");
    }

    public static String getTestBucketUriWithScheme(String scheme) {
        if (S3_TEST_BUCKET != null) {
            return scheme + "://" + S3_TEST_BUCKET + "/temp/";
        }
        throw new IllegalStateException("S3 test bucket not available");
    }
}

