/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetState;
import org.apache.flink.table.runtime.sequencedmultisetstate.TimeSelector;
import org.apache.flink.util.Preconditions;

public class SequencedMultiSetStateConfig {
    private final SequencedMultiSetState.Strategy strategy;
    @Nullable
    private final Long adaptiveHighThresholdOverride;
    @Nullable
    private final Long adaptiveLowThresholdOverride;
    private final StateTtlConfig ttlConfig;
    private final TimeSelector ttlTimeSelector;

    public SequencedMultiSetStateConfig(SequencedMultiSetState.Strategy strategy, @Nullable Long adaptiveHighThresholdOverride, @Nullable Long adaptiveLowThresholdOverride, StateTtlConfig ttlConfig, TimeDomain ttlTimeDomain) {
        this(strategy, adaptiveHighThresholdOverride, adaptiveLowThresholdOverride, ttlConfig, TimeSelector.getTimeDomain(ttlTimeDomain));
    }

    public SequencedMultiSetStateConfig(SequencedMultiSetState.Strategy strategy, @Nullable Long adaptiveHighThresholdOverride, @Nullable Long adaptiveLowThresholdOverride, StateTtlConfig ttlConfig, TimeSelector ttlTimeSelector) {
        Preconditions.checkArgument((!ttlConfig.isEnabled() ? 1 : 0) != 0, (Object)"TTL is not supported");
        this.strategy = strategy;
        this.adaptiveHighThresholdOverride = adaptiveHighThresholdOverride;
        this.adaptiveLowThresholdOverride = adaptiveLowThresholdOverride;
        this.ttlConfig = ttlConfig;
        this.ttlTimeSelector = ttlTimeSelector;
    }

    public static SequencedMultiSetStateConfig defaults(TimeDomain ttlTimeDomain, StateTtlConfig ttlConfig) {
        return SequencedMultiSetStateConfig.forValue(ttlTimeDomain, ttlConfig);
    }

    public static SequencedMultiSetStateConfig forMap(TimeDomain ttlTimeDomain, StateTtlConfig ttlConfig) {
        return new SequencedMultiSetStateConfig(SequencedMultiSetState.Strategy.MAP_STATE, null, null, ttlConfig, ttlTimeDomain);
    }

    public static SequencedMultiSetStateConfig forValue(TimeDomain ttlTimeDomain, StateTtlConfig ttl) {
        return new SequencedMultiSetStateConfig(SequencedMultiSetState.Strategy.VALUE_STATE, null, null, ttl, ttlTimeDomain);
    }

    public static SequencedMultiSetStateConfig adaptive(TimeDomain ttlTimeDomain, long adaptiveHighThresholdOverride, long adaptiveLowThresholdOverride, StateTtlConfig ttl) {
        return new SequencedMultiSetStateConfig(SequencedMultiSetState.Strategy.ADAPTIVE, (Long)adaptiveHighThresholdOverride, (Long)adaptiveLowThresholdOverride, ttl, ttlTimeDomain);
    }

    public TimeSelector getTimeSelector() {
        return this.ttlTimeSelector;
    }

    public SequencedMultiSetState.Strategy getStrategy() {
        return this.strategy;
    }

    public Optional<Long> getAdaptiveHighThresholdOverride() {
        return Optional.ofNullable(this.adaptiveHighThresholdOverride);
    }

    public Optional<Long> getAdaptiveLowThresholdOverride() {
        return Optional.ofNullable(this.adaptiveLowThresholdOverride);
    }

    public StateTtlConfig getTtlConfig() {
        return this.ttlConfig;
    }
}

