/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.util.WatermarkStrategyWithPeriodicWatermarks;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.sources.wmstrategies.PeriodicWatermarkAssigner;

@Internal
public class PeriodicWatermarkAssignerWrapper
implements WatermarkStrategyWithPeriodicWatermarks<RowData> {
    private static final long serialVersionUID = 1L;
    private final PeriodicWatermarkAssigner assigner;
    private final int timeFieldIdx;

    public PeriodicWatermarkAssignerWrapper(PeriodicWatermarkAssigner assigner, int timeFieldIdx) {
        this.assigner = assigner;
        this.timeFieldIdx = timeFieldIdx;
    }

    @Nullable
    public Watermark getCurrentWatermark() {
        return this.assigner.getWatermark();
    }

    public long extractTimestamp(RowData row, long recordTimestamp) {
        long timestamp = row.getTimestamp(this.timeFieldIdx, 3).getMillisecond();
        this.assigner.nextTimestamp(timestamp);
        return 0L;
    }
}

