/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArraySliceFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;

    public ArraySliceFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_SLICE, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
    }

    @Nullable
    public ArrayData eval(@Nullable ArrayData array, @Nullable Integer start, @Nullable Integer end) {
        try {
            if (array == null || start == null || end == null) {
                return null;
            }
            if (array.size() == 0) {
                return array;
            }
            int startIndex = start;
            int endIndex = end;
            startIndex += startIndex < 0 ? array.size() + 1 : 0;
            int n = endIndex < 0 ? array.size() + 1 : 0;
            startIndex = Math.max(1, startIndex);
            int n2 = endIndex = (endIndex += n) == 0 ? 1 : Math.min(endIndex, array.size());
            if (endIndex < startIndex) {
                return new GenericArrayData(new Object[0]);
            }
            if (startIndex == 1 && endIndex == array.size()) {
                return array;
            }
            ArrayList<Object> slicedArray = new ArrayList<Object>();
            for (int i = startIndex - 1; i <= endIndex - 1; ++i) {
                slicedArray.add(this.elementGetter.getElementOrNull(array, i));
            }
            return new GenericArrayData(slicedArray.toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    @Nullable
    public ArrayData eval(@Nullable ArrayData array, @Nullable Integer start) {
        return array == null ? null : this.eval(array, start, array.size());
    }
}

