/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class LastValueAggFunction<T>
extends BuiltInAggregateFunction<T, RowData> {
    private final transient DataType valueDataType;

    public LastValueAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType((LogicalType)valueType);
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.valueDataType);
    }

    @Override
    public DataType getAccumulatorDataType() {
        return (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"lastValue", (DataType)((DataType)this.valueDataType.nullable())), DataTypes.FIELD((String)"lastOrder", (DataType)DataTypes.BIGINT())}).bridgedTo(RowData.class);
    }

    @Override
    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    public RowData createAccumulator() {
        GenericRowData acc = new GenericRowData(2);
        acc.setField(0, null);
        acc.setField(1, (Object)Long.MIN_VALUE);
        return acc;
    }

    public void accumulate(RowData rowData, Object value) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value != null) {
            acc.setField(0, value);
        }
    }

    public void accumulate(RowData rowData, Object value, Long order) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value != null && acc.getLong(1) < order) {
            acc.setField(0, value);
            acc.setField(1, (Object)order);
        }
    }

    public void accumulate(GenericRowData acc, StringData value) {
        if (value != null) {
            this.accumulate((RowData)acc, ((BinaryStringData)value).copy());
        }
    }

    public void accumulate(GenericRowData acc, StringData value, Long order) {
        if (value != null) {
            this.accumulate((RowData)acc, ((BinaryStringData)value).copy(), order);
        }
    }

    public void resetAccumulator(RowData rowData) {
        GenericRowData acc = (GenericRowData)rowData;
        acc.setField(0, null);
        acc.setField(1, (Object)Long.MIN_VALUE);
    }

    public T getValue(RowData rowData) {
        GenericRowData acc = (GenericRowData)rowData;
        return (T)acc.getField(0);
    }
}

