/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.apache.flink.state.rocksdb.EmbeddedRocksDBStateBackend;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.Rule;
import org.junit.jupiter.api.AfterEach;
import org.junit.rules.TemporaryFolder;

public abstract class StateParameterizedHarnessTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    protected static final StateBackendMode HEAP_BACKEND = StateBackendMode.HEAP;
    protected static final StateBackendMode ROCKSDB_BACKEND = StateBackendMode.ROCKSDB;
    private final StateBackendMode mode;
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    protected StateParameterizedHarnessTestBase(StateBackendMode mode) {
        this.mode = mode;
        try {
            this.tempFolder.create();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary folder in HarnessTestBase constructor", e);
        }
    }

    @AfterEach
    public void tearDownTemporaryFolder() {
        this.tempFolder.delete();
    }

    protected StateBackend getStateBackend() {
        switch (this.mode) {
            case HEAP: {
                Configuration conf = new Configuration();
                return new HashMapStateBackend().configure((ReadableConfig)conf, this.classLoader);
            }
            case ROCKSDB: {
                return new EmbeddedRocksDBStateBackend();
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + this.mode);
    }

    protected CheckpointStorage getCheckpointStorage() {
        switch (this.mode) {
            case HEAP: {
                return new JobManagerCheckpointStorage();
            }
            case ROCKSDB: {
                try {
                    return new FileSystemCheckpointStorage("file://" + this.tempFolder.getRoot().getAbsolutePath());
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot create folder in temporary directory for checkpoint storage", e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + this.mode);
    }

    @Parameters(name="StateBackend={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({HEAP_BACKEND}, {ROCKSDB_BACKEND});
    }

    public static enum StateBackendMode {
        HEAP,
        ROCKSDB;

    }
}

