/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class WindowedSliceAssignerTest
extends SliceAssignerTestBase {
    private ZoneId shiftTimeZone;
    private SliceAssigner tumbleAssigner;
    private SliceAssigner hopAssigner;
    private SliceAssigner cumulateAssigner;

    WindowedSliceAssignerTest() {
    }

    @Parameters(name="timezone = {0}")
    private static Collection<ZoneId> parameters() {
        return Arrays.asList(ZoneId.of("America/Los_Angeles"), ZoneId.of("Asia/Shanghai"));
    }

    @BeforeEach
    void setUp() {
        this.tumbleAssigner = SliceAssigners.tumbling((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(4L));
        this.hopAssigner = SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        this.cumulateAssigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
    }

    @TestTemplate
    void testSliceAssignment() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat((long)WindowedSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)WindowedSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)WindowedSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T10:00:00"));
    }

    @TestTemplate
    void testGetWindowStartForTumble() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T20:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T08:00:00"))).isEqualTo(this.utcMills("1970-01-01T04:00:00"));
    }

    @TestTemplate
    void testGetWindowStartForHop() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.hopAssigner);
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00"))).isEqualTo(this.utcMills("1969-12-31T20:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00"))).isEqualTo(this.utcMills("1969-12-31T21:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00"))).isEqualTo(this.utcMills("1969-12-31T22:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1969-12-31T23:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00"))).isEqualTo(this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @TestTemplate
    void testGetWindowStartForCumulate() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.cumulateAssigner);
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T10:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @TestTemplate
    void testExpiredSlices() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat(WindowedSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T00:00:00")});
        Assertions.assertThat(WindowedSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T04:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T04:00:00")});
        Assertions.assertThat(WindowedSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T10:00:00")});
    }

    @TestTemplate
    void testEventTime() {
        SliceAssigners.WindowedSliceAssigner assigner = SliceAssigners.windowed((int)0, (SliceAssigner)this.tumbleAssigner);
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
    }

    @TestTemplate
    void testInvalidParameters() {
        WindowedSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.windowed((int)-1, (SliceAssigner)this.tumbleAssigner), "Windowed slice assigner must have a positive window end index.");
        SliceAssigners.windowed((int)1, (SliceAssigner)this.tumbleAssigner);
    }

    private long localMills(String timestampStr) {
        return this.localMills(timestampStr, this.shiftTimeZone);
    }
}

