/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class CumulativeSliceAssignerTest
extends SliceAssignerTestBase {
    CumulativeSliceAssignerTest() {
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testSliceAssignment(ZoneId zoneId) {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofDays(1L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00", zoneId))).isEqualTo(this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat((long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-02T22:59:59.999", zoneId))).isEqualTo(this.utcMills("1970-01-02T23:00:00"));
        Assertions.assertThat((long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-02T23:00:00", zoneId))).isEqualTo(this.utcMills("1970-01-03T00:00:00"));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testSliceAssignmentWithOffset(ZoneId zoneId) {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L)).withOffset(Duration.ofMillis(100L));
        Assertions.assertThat((long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00.100", zoneId))).isEqualTo(this.utcMills("1970-01-01T01:00:00.100"));
        Assertions.assertThat((long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.099", zoneId))).isEqualTo(this.utcMills("1970-01-01T05:00:00.100"));
        Assertions.assertThat((long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.1", zoneId))).isEqualTo(this.utcMills("1970-01-01T06:00:00.100"));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testDstSaving(ZoneId zoneId) {
        if (!TimeZone.getTimeZone(zoneId).useDaylightTime()) {
            return;
        }
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(4L), (Duration)Duration.ofHours(1L));
        long epoch1 = 1615708800000L;
        long epoch2 = 1615712400000L;
        long epoch3 = 1615716000000L;
        long epoch4 = 1615719600000L;
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T01:00", epoch1, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T02:00", epoch2, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch3, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T04:00", "2021-03-14T05:00", epoch4, (SliceAssigner)assigner);
        long epoch5 = 1636268400000L;
        long epoch6 = 1636272000000L;
        long epoch7 = 1636275600000L;
        long epoch8 = 1636279200000L;
        long epoch9 = 1636282800000L;
        long epoch10 = 1636286400000L;
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T01:00", epoch5, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T02:00", epoch6, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T02:00", epoch7, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T03:00", epoch8, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch9, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T04:00", "2021-11-07T05:00", epoch10, (SliceAssigner)assigner);
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testGetWindowStart(ZoneId zoneId) {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00"))).isEqualTo(this.utcMills("1969-12-31T19:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00"))).isEqualTo(this.utcMills("1970-01-01T00:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
        Assertions.assertThat((long)assigner.getWindowStart(this.utcMills("1970-01-01T08:00:00"))).isEqualTo(this.utcMills("1970-01-01T05:00:00"));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testExpiredSlices(ZoneId zoneId) {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T01:00:00"))).isEmpty();
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T02:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T02:00:00")});
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T03:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T03:00:00")});
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T04:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T04:00:00")});
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).isEqualTo(Arrays.asList(this.utcMills("1970-01-01T05:00:00"), this.utcMills("1970-01-01T01:00:00")));
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T06:00:00"))).isEmpty();
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).isEqualTo(Arrays.asList(this.utcMills("1970-01-01T10:00:00"), this.utcMills("1970-01-01T06:00:00")));
        Assertions.assertThat(CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).isEqualTo(Arrays.asList(this.utcMills("1970-01-01T00:00:00"), this.utcMills("1969-12-31T20:00:00")));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testMerge(ZoneId zoneId) throws Exception {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T01:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T01:00:00"))).isEmpty();
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T02:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T02:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T02:00:00")});
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T03:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T03:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T03:00:00")});
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T04:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T04:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T04:00:00")});
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T01:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T05:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T05:00:00")});
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T06:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T06:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T06:00:00"))).isEmpty();
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T08:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T06:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T08:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T08:00:00")});
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).isEqualTo((Object)this.utcMills("1970-01-01T06:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T10:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T10:00:00")});
        Assertions.assertThat((Long)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).isEqualTo((Object)this.utcMills("1969-12-31T20:00:00"));
        Assertions.assertThat(CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T00:00:00"))).containsExactly((Object[])new Long[]{this.utcMills("1970-01-01T00:00:00")});
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testNextTriggerWindow(ZoneId zoneId) {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T00:00:00"), () -> false)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T01:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T02:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T02:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T03:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T03:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T04:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T04:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T05:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T05:00:00"), () -> false)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T06:00:00"), () -> false)).isEqualTo(Optional.of(this.utcMills("1970-01-01T07:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T00:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T01:00:00"), () -> true)).isEqualTo(Optional.of(this.utcMills("1970-01-01T02:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T02:00:00"), () -> true)).isEqualTo(Optional.of(this.utcMills("1970-01-01T03:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T03:00:00"), () -> true)).isEqualTo(Optional.of(this.utcMills("1970-01-01T04:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T04:00:00"), () -> true)).isEqualTo(Optional.of(this.utcMills("1970-01-01T05:00:00")));
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T05:00:00"), () -> true)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)assigner.nextTriggerWindow(this.utcMills("1970-01-01T06:00:00"), () -> true)).isEqualTo(Optional.of(this.utcMills("1970-01-01T07:00:00")));
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testEventTime(ZoneId zoneId) {
        if (zoneId.equals("Asia/Shanghai")) {
            return;
        }
        SliceAssigners.CumulativeSliceAssigner assigner1 = SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)assigner1.isEventTime()).isTrue();
        SliceAssigners.CumulativeSliceAssigner assigner2 = SliceAssigners.cumulative((int)-1, (ZoneId)zoneId, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)assigner2.isEventTime()).isFalse();
    }

    @ParameterizedTest(name="timezone = {0}")
    @MethodSource(value={"zoneIds"})
    void testInvalidParameters(ZoneId zoneId) {
        CumulativeSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(-5L), (Duration)Duration.ofSeconds(1L)), "Cumulative Window parameters must satisfy maxSize > 0 and step > 0, but got maxSize -5000ms and step 1000ms.");
        CumulativeSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(-1L)), "Cumulative Window parameters must satisfy maxSize > 0 and step > 0, but got maxSize 5000ms and step -1000ms.");
        CumulativeSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.cumulative((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(2L)), "Cumulative Window requires maxSize must be an integral multiple of step, but got maxSize 5000ms and step 2000ms.");
        SliceAssigners.hopping((int)0, (ZoneId)zoneId, (Duration)Duration.ofSeconds(10L), (Duration)Duration.ofSeconds(2L)).withOffset(Duration.ofSeconds(-1L));
    }
}

