/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.operator;

import java.time.ZoneId;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.GenericRowRecordSortComparator;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;

abstract class WindowTableFunctionOperatorTestBase {
    protected static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    protected static final ZoneId SHANGHAI_ZONE_ID = ZoneId.of("Asia/Shanghai");
    protected final ZoneId shiftTimeZone;
    protected static final RowType INPUT_ROW_TYPE = new RowType(Arrays.asList(new RowType.RowField("f0", (LogicalType)new VarCharType(Integer.MAX_VALUE)), new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new TimestampType(3))));
    protected static final RowDataSerializer INPUT_ROW_SER = new RowDataSerializer(INPUT_ROW_TYPE);
    protected static final int ROW_TIME_INDEX = 2;
    protected static final LogicalType[] OUTPUT_TYPES = new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType(), new TimestampType(3), new TimestampType(3), new TimestampType(3), new TimestampType(3)};
    protected static final TypeSerializer<RowData> OUT_SERIALIZER = new RowDataSerializer(OUTPUT_TYPES);
    protected static final RowDataHarnessAssertor ASSERTER = new RowDataHarnessAssertor(OUTPUT_TYPES, new GenericRowRecordSortComparator(4, (LogicalType)new TimestampType()));

    public WindowTableFunctionOperatorTestBase(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
    }

    protected long localMills(long epochMills) {
        return TimeWindowUtil.toUtcTimestampMills((long)epochMills, (ZoneId)this.shiftTimeZone);
    }

    protected static StreamRecord<RowData> insertRecord(String f0, int f1, Long ... f2) {
        Object[] fields = new Object[2 + f2.length];
        fields[0] = f0;
        fields[1] = f1;
        for (int idx = 0; idx < f2.length; ++idx) {
            fields[2 + idx] = f2[idx] == null ? null : TimestampData.fromEpochMillis((long)f2[idx]);
        }
        return new StreamRecord((Object)StreamRecordUtils.row(fields));
    }
}

