/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.sink.RowKindSetter;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RowKindSetterTest {
    RowKindSetterTest() {
    }

    @Test
    void testSetRowKind() throws Exception {
        for (RowKind targetRowKind : RowKind.values()) {
            RowKindSetter rowKindSetter = new RowKindSetter(targetRowKind);
            try (OneInputStreamOperatorTestHarness operatorTestHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)rowKindSetter);){
                operatorTestHarness.open();
                List<RowData> rows = this.getRowsWithAllRowKind();
                for (RowData row : rows) {
                    operatorTestHarness.processElement(new StreamRecord((Object)row));
                }
                this.verifyRowKind(operatorTestHarness.extractOutputValues(), targetRowKind);
            }
        }
    }

    private List<RowData> getRowsWithAllRowKind() {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        for (RowKind rowKind : RowKind.values()) {
            rows.add((RowData)GenericRowData.of((Object[])new Object[]{rowKind, 1}));
        }
        return rows;
    }

    private void verifyRowKind(List<RowData> rows, RowKind rowKind) {
        for (RowData row : rows) {
            Assertions.assertThat((Comparable)row.getRowKind()).isEqualTo((Object)rowKind);
        }
    }
}

