/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

public class TestingOneInputStreamOperator
extends AbstractStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData>,
BoundedOneInput {
    private final boolean emitDataInEndInput;
    private boolean isOpened = false;
    private StreamRecord<RowData> currentElement = null;
    private Watermark currentWatermark = null;
    private LatencyMarker currentLatencyMarker = null;
    private boolean isEnd = false;
    private boolean isClosed = false;
    private final List<StreamRecord<RowData>> receivedElements = new ArrayList<StreamRecord<RowData>>();

    public TestingOneInputStreamOperator() {
        this(null, false);
    }

    public TestingOneInputStreamOperator(StreamOperatorParameters<RowData> parameters) {
        this(parameters, false);
    }

    public TestingOneInputStreamOperator(boolean emitDataInEndInput) {
        this(null, emitDataInEndInput);
    }

    public TestingOneInputStreamOperator(StreamOperatorParameters<RowData> parameters, boolean emitDataInEndInput) {
        super(parameters);
        this.emitDataInEndInput = emitDataInEndInput;
    }

    public void open() throws Exception {
        this.isOpened = true;
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        this.currentElement = element;
        if (this.emitDataInEndInput) {
            this.receivedElements.add(element);
        } else {
            this.output.collect(element);
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.currentWatermark = mark;
        this.output.emitWatermark(mark);
    }

    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        this.currentLatencyMarker = latencyMarker;
        this.output.emitLatencyMarker(latencyMarker);
    }

    public void endInput() throws Exception {
        this.isEnd = true;
        if (this.emitDataInEndInput) {
            this.receivedElements.forEach(arg_0 -> ((Output)this.output).collect(arg_0));
        } else {
            Preconditions.checkArgument((boolean)this.receivedElements.isEmpty());
        }
    }

    public void close() throws Exception {
        this.isClosed = true;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public StreamRecord<RowData> getCurrentElement() {
        return this.currentElement;
    }

    public Watermark getCurrentWatermark() {
        return this.currentWatermark;
    }

    public LatencyMarker getCurrentLatencyMarker() {
        return this.currentLatencyMarker;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

