/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputTestBase;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.TestingOneInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.TestingTwoInputStreamOperator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableOperatorWrapperTest
extends MultipleInputTestBase {
    TableOperatorWrapperTest() {
    }

    @Test
    void testBasicInfo() {
        TestingOneInputStreamOperator inOperator1 = new TestingOneInputStreamOperator();
        TestingOneInputStreamOperator inOperator2 = new TestingOneInputStreamOperator();
        TestingTwoInputStreamOperator outOperator = new TestingTwoInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper1 = this.createOneInputOperatorWrapper(inOperator1, "test1");
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper2 = this.createOneInputOperatorWrapper(inOperator2, "test2");
        TableOperatorWrapper<TestingTwoInputStreamOperator> wrapper3 = this.createTwoInputOperatorWrapper(outOperator, "test3");
        wrapper3.addInput(wrapper1, 1);
        wrapper3.addInput(wrapper2, 2);
        Assertions.assertThat((List)wrapper1.getInputEdges()).isEmpty();
        Assertions.assertThat((List)wrapper1.getInputWrappers()).isEmpty();
        Assertions.assertThat((List)wrapper1.getOutputWrappers()).containsExactly((Object[])new TableOperatorWrapper[]{wrapper3});
        Assertions.assertThat((List)wrapper1.getOutputEdges()).containsExactly((Object[])new TableOperatorWrapper.Edge[]{new TableOperatorWrapper.Edge(wrapper1, wrapper3, 1)});
        Assertions.assertThat((List)wrapper2.getInputEdges()).isEmpty();
        Assertions.assertThat((List)wrapper2.getInputWrappers()).isEmpty();
        Assertions.assertThat((List)wrapper2.getOutputWrappers()).containsExactly((Object[])new TableOperatorWrapper[]{wrapper3});
        Assertions.assertThat((List)wrapper2.getOutputEdges()).containsExactly((Object[])new TableOperatorWrapper.Edge[]{new TableOperatorWrapper.Edge(wrapper2, wrapper3, 2)});
        Assertions.assertThat((List)wrapper3.getOutputEdges()).isEmpty();
        Assertions.assertThat((List)wrapper3.getOutputWrappers()).isEmpty();
        Assertions.assertThat((List)wrapper3.getInputWrappers()).isEqualTo(Arrays.asList(wrapper1, wrapper2));
        Assertions.assertThat((List)wrapper3.getInputEdges()).isEqualTo(Arrays.asList(new TableOperatorWrapper.Edge(wrapper1, wrapper3, 1), new TableOperatorWrapper.Edge(wrapper2, wrapper3, 2)));
    }

    @Test
    void testCreateOperator() throws Exception {
        TestingOneInputStreamOperator operator = new TestingOneInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper = this.createOneInputOperatorWrapper(operator, "test");
        StreamOperatorParameters<RowData> parameters = this.createStreamOperatorParameters();
        wrapper.createOperator(parameters);
        Assertions.assertThat((Object)((Object)((TestingOneInputStreamOperator)wrapper.getStreamOperator()))).isEqualTo((Object)operator);
        Assertions.assertThatThrownBy(() -> wrapper.createOperator(parameters)).hasMessageContaining("This operator has been initialized");
    }

    @Test
    void testEndInput() throws Exception {
        StreamOperatorParameters<RowData> parameters = this.createStreamOperatorParameters();
        TestingOneInputStreamOperator inOperator1 = new TestingOneInputStreamOperator();
        TestingOneInputStreamOperator inOperator2 = new TestingOneInputStreamOperator();
        TestingTwoInputStreamOperator outOperator = new TestingTwoInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper1 = this.createOneInputOperatorWrapper(inOperator1, "test1");
        wrapper1.createOperator(parameters);
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper2 = this.createOneInputOperatorWrapper(inOperator2, "test2");
        wrapper2.createOperator(parameters);
        TableOperatorWrapper<TestingTwoInputStreamOperator> wrapper3 = this.createTwoInputOperatorWrapper(outOperator, "test3");
        wrapper3.addInput(wrapper1, 1);
        wrapper3.addInput(wrapper2, 2);
        wrapper3.createOperator(parameters);
        Assertions.assertThat((boolean)inOperator1.isEnd()).isFalse();
        Assertions.assertThat((boolean)inOperator2.isEnd()).isFalse();
        Assertions.assertThat(outOperator.getEndInputs()).isEmpty();
        wrapper1.endOperatorInput(1);
        Assertions.assertThat((boolean)inOperator1.isEnd()).isTrue();
        Assertions.assertThat((int)wrapper1.getEndedInputCount()).isEqualTo(1);
        Assertions.assertThat((boolean)inOperator2.isEnd()).isFalse();
        Assertions.assertThat((int)wrapper2.getEndedInputCount()).isEqualTo(0);
        Assertions.assertThat(outOperator.getEndInputs()).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((int)wrapper3.getEndedInputCount()).isEqualTo(1);
        wrapper2.endOperatorInput(1);
        Assertions.assertThat((boolean)inOperator1.isEnd()).isTrue();
        Assertions.assertThat((int)wrapper1.getEndedInputCount()).isEqualTo(1);
        Assertions.assertThat((boolean)inOperator2.isEnd()).isTrue();
        Assertions.assertThat((int)wrapper2.getEndedInputCount()).isEqualTo(1);
        Assertions.assertThat(outOperator.getEndInputs()).isEqualTo(Arrays.asList(1, 2));
        Assertions.assertThat((int)wrapper3.getEndedInputCount()).isEqualTo(2);
    }

    @Test
    void testClose() throws Exception {
        TestingOneInputStreamOperator operator = new TestingOneInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper = this.createOneInputOperatorWrapper(operator, "test");
        StreamOperatorParameters<RowData> parameters = this.createStreamOperatorParameters();
        wrapper.createOperator(parameters);
        Assertions.assertThat((Object)((Object)((TestingOneInputStreamOperator)wrapper.getStreamOperator()))).isEqualTo((Object)operator);
        Assertions.assertThat((boolean)operator.isClosed()).isFalse();
        Assertions.assertThat((boolean)wrapper.isClosed()).isFalse();
        wrapper.close();
        Assertions.assertThat((boolean)wrapper.isClosed()).isTrue();
        Assertions.assertThat((boolean)operator.isClosed()).isTrue();
        wrapper.close();
        Assertions.assertThat((boolean)wrapper.isClosed()).isTrue();
        Assertions.assertThat((boolean)operator.isClosed()).isTrue();
    }
}

