/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.List;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingTwoWayInnerMultiJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    public StreamingTwoWayInnerMultiJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 2, List.of(FlinkJoinType.INNER, FlinkJoinType.INNER), StreamingTwoWayInnerMultiJoinOperatorTest.defaultConditions(), false);
    }

    @TestTemplate
    void testTwoWayInnerJoin() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.insertOrder("2", "order_2", "Order 2 Details");
        this.emitsNothing();
        this.insertUser("2", "Bob", "User 2 Details");
        this.emits(INSERT, "2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details");
    }

    @TestTemplate
    void testTwoWayInnerJoinUpdating() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.updateAfterUser("1", "Gus", "User 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details");
        this.updateAfterOrder("1", "order_1", "Order 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated");
        this.deleteOrder("1", "order_1", "Order 1 Details Updated");
        this.emits(DELETE, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated");
        this.insertOrder("1", "order_1", "Order 1 New Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 New Details");
    }
}

