/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.dynamicfiltering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.MockOperatorCoordinatorContext;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.TestingOperatorCoordinator;
import org.apache.flink.runtime.source.event.SourceEventWrapper;
import org.apache.flink.table.connector.source.DynamicFilteringData;
import org.apache.flink.table.connector.source.DynamicFilteringEvent;
import org.apache.flink.table.runtime.operators.dynamicfiltering.DynamicFilteringDataCollectorOperatorCoordinator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DynamicFilteringDataCollectorOperatorCoordinatorTest {
    DynamicFilteringDataCollectorOperatorCoordinatorTest() {
    }

    @Test
    void testRedistributeData() throws Exception {
        MockOperatorCoordinatorContext context = new MockOperatorCoordinatorContext(new OperatorID(), 1);
        String listenerID1 = "test-listener-1";
        String listenerID2 = "test-listener-2";
        TestingOperatorCoordinator listener1 = new TestingOperatorCoordinator((OperatorCoordinator.Context)context);
        TestingOperatorCoordinator listener2 = new TestingOperatorCoordinator((OperatorCoordinator.Context)context);
        context.getCoordinatorStore().putIfAbsent((Object)listenerID1, (Object)listener1);
        context.getCoordinatorStore().putIfAbsent((Object)listenerID2, (Object)listener2);
        RowType rowType = RowType.of((LogicalType[])new LogicalType[]{new IntType()});
        OperatorEvent testEvent = this.dynamicFilteringEvent(rowType, Collections.emptyList());
        try (DynamicFilteringDataCollectorOperatorCoordinator coordinator = new DynamicFilteringDataCollectorOperatorCoordinator((OperatorCoordinator.Context)context, Arrays.asList(listenerID1, listenerID2));){
            coordinator.handleEventFromOperator(0, 1, testEvent);
        }
        Assertions.assertThat((Object)listener1.getNextReceivedOperatorEvent()).isSameAs((Object)testEvent);
        Assertions.assertThat((Object)listener1.getNextReceivedOperatorEvent()).isNull();
        Assertions.assertThat((Object)listener2.getNextReceivedOperatorEvent()).isSameAs((Object)testEvent);
        Assertions.assertThat((Object)listener2.getNextReceivedOperatorEvent()).isNull();
    }

    @Test
    void testTaskFailover() throws Exception {
        MockOperatorCoordinatorContext context = new MockOperatorCoordinatorContext(new OperatorID(), 1);
        String listenerID = "test-listener-1";
        TestingOperatorCoordinator listener = new TestingOperatorCoordinator((OperatorCoordinator.Context)context);
        context.getCoordinatorStore().putIfAbsent((Object)listenerID, (Object)listener);
        RowType rowType = RowType.of((LogicalType[])new LogicalType[]{new IntType()});
        try (DynamicFilteringDataCollectorOperatorCoordinator coordinator = new DynamicFilteringDataCollectorOperatorCoordinator((OperatorCoordinator.Context)context, Arrays.asList(listenerID));){
            OperatorEvent testEvent = this.dynamicFilteringEvent(rowType, Collections.singletonList(new byte[]{1, 2}));
            coordinator.handleEventFromOperator(0, 0, testEvent);
            Assertions.assertThat((Object)listener.getNextReceivedOperatorEvent()).isSameAs((Object)testEvent);
            coordinator.executionAttemptFailed(0, 0, null);
            OperatorEvent testEvent1 = this.dynamicFilteringEvent(rowType, Collections.singletonList(new byte[]{1, 2}));
            coordinator.handleEventFromOperator(0, 1, testEvent1);
            Assertions.assertThat((Object)listener.getNextReceivedOperatorEvent()).isNull();
            coordinator.executionAttemptFailed(0, 1, null);
            OperatorEvent testEvent2 = this.dynamicFilteringEvent(rowType, Collections.singletonList(new byte[]{1, 3}));
            Assertions.assertThatThrownBy(() -> coordinator.handleEventFromOperator(0, 2, testEvent2)).isInstanceOf(IllegalStateException.class);
        }
    }

    private OperatorEvent dynamicFilteringEvent(RowType rowType, List<byte[]> data) {
        return new SourceEventWrapper((SourceEvent)new DynamicFilteringEvent(new DynamicFilteringData((TypeInformation)InternalTypeInfo.of((RowType)rowType), rowType, data, data.isEmpty())));
    }
}

