/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
class RowDataKey {
    private final RecordEqualiser equaliser;
    private final HashFunction hashFunction;
    final RowData rowData;

    RowDataKey(RecordEqualiser equaliser, HashFunction hashFunction) {
        this.equaliser = (RecordEqualiser)Preconditions.checkNotNull((Object)equaliser);
        this.hashFunction = (HashFunction)Preconditions.checkNotNull((Object)hashFunction);
        this.rowData = null;
    }

    public RowDataKey(RowData rowData, RecordEqualiser equaliser, HashFunction hashFunction) {
        this.equaliser = (RecordEqualiser)Preconditions.checkNotNull((Object)equaliser);
        this.hashFunction = (HashFunction)Preconditions.checkNotNull((Object)hashFunction);
        this.rowData = (RowData)Preconditions.checkNotNull((Object)rowData);
    }

    public static RowDataKey toKeyNotProjected(RowData row, RecordEqualiser equaliser, HashFunction hasher) {
        return RowDataKey.toKey(row, equaliser, hasher);
    }

    public static RowDataKey toKey(RowData row, RecordEqualiser equaliser, HashFunction hasher) {
        row.setRowKind(RowKind.INSERT);
        return new RowDataKey(row, equaliser, hasher);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RowDataKey)) {
            return false;
        }
        RowDataKey other = (RowDataKey)o;
        return this.equaliser.equals(this.rowData, other.rowData);
    }

    public int hashCode() {
        return this.hashFunction.hashCode(this.rowData);
    }
}

