/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.EnforcerException;
import org.apache.flink.util.StringUtils;

@Internal
final class NestedArrayConstraint
implements Constraint {
    private final int[] nestedArrayFieldIndices;
    private final String[] nestedArrayFieldNames;
    private final Constraint[][] nestedElementsConstraints;
    private final ArrayData.ElementGetter[] elementGetters;

    NestedArrayConstraint(int[] nestedArrayFieldIndices, String[] nestedArrayFieldNames, Constraint[][] nestedElementsConstraints, ArrayData.ElementGetter[] elementGetters) {
        this.nestedArrayFieldIndices = nestedArrayFieldIndices;
        this.nestedArrayFieldNames = nestedArrayFieldNames;
        this.nestedElementsConstraints = nestedElementsConstraints;
        this.elementGetters = elementGetters;
    }

    @Override
    @Nullable
    public RowData enforce(RowData input) {
        for (int i = 0; i < this.nestedArrayFieldIndices.length; ++i) {
            int index = this.nestedArrayFieldIndices[i];
            if (input.isNullAt(index)) continue;
            ArrayData nestedArray = input.getArray(index);
            Constraint[] nestedConstraints = this.nestedElementsConstraints[i];
            ArrayData.ElementGetter elementGetter = this.elementGetters[i];
            for (int entryIdx = 0; entryIdx < nestedArray.size(); ++entryIdx) {
                Object element = elementGetter.getElementOrNull(nestedArray, entryIdx);
                for (Constraint nestedConstraint : nestedConstraints) {
                    if (this.enforce(nestedConstraint, element, i, entryIdx) != null) continue;
                    return null;
                }
            }
        }
        return input;
    }

    private RowData enforce(Constraint nestedConstraint, Object element, int i, int entryIdx) {
        try {
            return nestedConstraint.enforce((RowData)GenericRowData.of((Object[])new Object[]{element}));
        }
        catch (EnforcerException e) {
            String nestedColumnName = e.getColumnName().replace("element", "");
            Object columnName = String.format("%s[%d]", this.nestedArrayFieldNames[i], entryIdx);
            if (!StringUtils.isNullOrWhitespaceOnly((String)nestedColumnName)) {
                columnName = (String)columnName + nestedColumnName;
            }
            throw new EnforcerException(e.getFormat(), (String)columnName);
        }
    }

    public String toString() {
        return String.format("NestedArrayEnforcer(constraints=[%s])", IntStream.range(0, this.nestedArrayFieldIndices.length).mapToObj(idx -> String.format("{%s=%s}", this.nestedArrayFieldNames[idx], Arrays.toString(this.nestedElementsConstraints[idx]))).collect(Collectors.joining(", ")));
    }
}

