/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.flink.annotation.Internal;

@Internal
abstract class TimeConverter<TimeConversion> {
    abstract TimeConversion toExternal(long var1);

    abstract long toInternal(TimeConversion var1);

    private TimeConverter() {
    }

    static class LongTimeConverter
    extends TimeConverter<Long> {
        static final LongTimeConverter INSTANCE = new LongTimeConverter();

        private LongTimeConverter() {
        }

        @Override
        Long toExternal(long timeInternal) {
            return timeInternal;
        }

        @Override
        long toInternal(Long timeExternal) {
            return timeExternal;
        }
    }

    static class LocalDateTimeConverter
    extends TimeConverter<LocalDateTime> {
        static final LocalDateTimeConverter INSTANCE = new LocalDateTimeConverter();

        private LocalDateTimeConverter() {
        }

        @Override
        LocalDateTime toExternal(long timeInternal) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(timeInternal), ZoneOffset.UTC);
        }

        @Override
        long toInternal(LocalDateTime timeExternal) {
            return timeExternal.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
    }

    static class InstantTimeConverter
    extends TimeConverter<Instant> {
        static final TimeConverter<Instant> INSTANCE = new InstantTimeConverter();

        private InstantTimeConverter() {
        }

        @Override
        Instant toExternal(long timeInternal) {
            return Instant.ofEpochMilli(timeInternal);
        }

        @Override
        long toInternal(Instant timeExternal) {
            return timeExternal.toEpochMilli();
        }
    }
}

