/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.keyselector;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.JoinKeyExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class AttributeBasedJoinKeyExtractor
implements JoinKeyExtractor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, List<ConditionAttributeRef>> joinAttributeMap;
    private final List<RowType> inputTypes;
    private final Map<Integer, List<KeyExtractor>> leftKeyExtractorsMap;
    private final Map<Integer, List<KeyExtractor>> rightKeyExtractorsMap;
    private final Map<Integer, List<KeyExtractor>> commonJoinKeyExtractors;
    private RowType commonJoinKeyType;

    public AttributeBasedJoinKeyExtractor(Map<Integer, List<ConditionAttributeRef>> joinAttributeMap, List<RowType> inputTypes) {
        this.joinAttributeMap = joinAttributeMap;
        this.inputTypes = inputTypes;
        this.leftKeyExtractorsMap = new HashMap<Integer, List<KeyExtractor>>();
        this.rightKeyExtractorsMap = new HashMap<Integer, List<KeyExtractor>>();
        this.commonJoinKeyExtractors = new HashMap<Integer, List<KeyExtractor>>();
        this.initializeCaches();
        this.initializeCommonJoinKeyStructures();
        this.validateKeyStructures();
    }

    @Override
    public RowData getJoinKey(RowData row, int inputId) {
        if (inputId == 0) {
            return null;
        }
        List<ConditionAttributeRef> attributeMapping = this.joinAttributeMap.get(inputId);
        if (attributeMapping == null || attributeMapping.isEmpty()) {
            return null;
        }
        List<KeyExtractor> keyExtractors = this.rightKeyExtractorsMap.get(inputId);
        if (keyExtractors == null || keyExtractors.isEmpty()) {
            return null;
        }
        return this.buildKeyRowFromSourceRow(row, keyExtractors);
    }

    @Override
    public RowData getLeftSideJoinKey(int depth, RowData joinedRowData) {
        if (depth == 0) {
            return null;
        }
        List<KeyExtractor> keyExtractors = this.leftKeyExtractorsMap.get(depth);
        if (keyExtractors == null || keyExtractors.isEmpty()) {
            return null;
        }
        return this.buildKeyRowFromJoinedRow(keyExtractors, joinedRowData);
    }

    @Override
    @Nullable
    public RowType getJoinKeyType(int inputId) {
        if (inputId == 0) {
            return null;
        }
        List<KeyExtractor> keyExtractors = this.rightKeyExtractorsMap.get(inputId);
        if (keyExtractors == null || keyExtractors.isEmpty()) {
            return null;
        }
        return this.buildJoinKeyType(inputId, keyExtractors);
    }

    @Override
    public int[] getJoinKeyIndices(int inputId) {
        List<KeyExtractor> keyFieldIndices = this.rightKeyExtractorsMap.get(inputId);
        if (keyFieldIndices == null) {
            return new int[0];
        }
        return keyFieldIndices.stream().mapToInt(KeyExtractor::getFieldIndexInSourceRow).toArray();
    }

    @Override
    public RowType getCommonJoinKeyType() {
        return Objects.requireNonNullElseGet(this.commonJoinKeyType, () -> RowType.of((LogicalType[])new LogicalType[0]));
    }

    @Override
    @Nullable
    public RowData getCommonJoinKey(RowData row, int inputId) {
        List<KeyExtractor> extractors = this.commonJoinKeyExtractors.get(inputId);
        if (extractors == null || extractors.isEmpty()) {
            return null;
        }
        return this.buildKeyRowFromSourceRow(row, extractors);
    }

    @Override
    public int[] getCommonJoinKeyIndices(int inputId) {
        List<KeyExtractor> extractors = this.commonJoinKeyExtractors.get(inputId);
        if (extractors == null || extractors.isEmpty()) {
            return new int[0];
        }
        return extractors.stream().mapToInt(KeyExtractor::getFieldIndexInSourceRow).toArray();
    }

    private void initializeCaches() {
        if (this.inputTypes != null) {
            for (int i = 0; i < this.inputTypes.size(); ++i) {
                this.leftKeyExtractorsMap.put(i, this.createLeftJoinKeyFieldExtractors(i));
                this.rightKeyExtractorsMap.put(i, this.createRightJoinKeyExtractors(i));
            }
        }
    }

    private List<KeyExtractor> createLeftJoinKeyFieldExtractors(int inputId) {
        if (inputId == 0) {
            return Collections.emptyList();
        }
        List<ConditionAttributeRef> attributeMapping = this.joinAttributeMap.get(inputId);
        if (attributeMapping == null || attributeMapping.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyExtractor> keyExtractors = new ArrayList<KeyExtractor>();
        for (ConditionAttributeRef entry : attributeMapping) {
            AttributeRef leftAttrRef = AttributeBasedJoinKeyExtractor.getLeftAttributeRef(inputId, entry);
            keyExtractors.add(this.createKeyExtractor(leftAttrRef));
        }
        return keyExtractors;
    }

    private List<KeyExtractor> createRightJoinKeyExtractors(int inputId) {
        List<ConditionAttributeRef> attributeMapping = this.joinAttributeMap.get(inputId);
        if (attributeMapping == null) {
            return Collections.emptyList();
        }
        ArrayList<KeyExtractor> keyExtractors = new ArrayList<KeyExtractor>();
        for (ConditionAttributeRef entry : attributeMapping) {
            AttributeRef rightAttrRef = AttributeBasedJoinKeyExtractor.getRightAttributeRef(inputId, entry);
            keyExtractors.add(this.createKeyExtractor(rightAttrRef));
        }
        return keyExtractors;
    }

    private static AttributeRef getLeftAttributeRef(int inputId, ConditionAttributeRef entry) {
        AttributeRef leftAttrRef = new AttributeRef(entry.leftInputId, entry.leftFieldIndex);
        if (leftAttrRef.inputId >= inputId) {
            throw new IllegalStateException("Invalid joinAttributeMap configuration for inputId " + inputId + ". Left attribute " + leftAttrRef + " does not reference a previous input (< " + inputId + ").");
        }
        return leftAttrRef;
    }

    private static AttributeRef getRightAttributeRef(int inputId, ConditionAttributeRef entry) {
        AttributeRef rightAttrRef = new AttributeRef(entry.rightInputId, entry.rightFieldIndex);
        if (rightAttrRef.inputId != inputId) {
            throw new IllegalStateException("Invalid joinAttributeMap configuration for inputId " + inputId + ". Right attribute " + rightAttrRef + " must reference the current input (" + inputId + ").");
        }
        return rightAttrRef;
    }

    private KeyExtractor createKeyExtractor(AttributeRef attrRef) {
        RowType rowType = this.inputTypes.get(attrRef.inputId);
        this.validateFieldIndex(attrRef.inputId, attrRef.fieldIndex, rowType);
        LogicalType fieldType = rowType.getTypeAt(attrRef.fieldIndex);
        int absoluteFieldIndex = attrRef.fieldIndex;
        for (int i = 0; i < attrRef.inputId; ++i) {
            absoluteFieldIndex += this.inputTypes.get(i).getFieldCount();
        }
        return new KeyExtractor(attrRef.inputId, attrRef.fieldIndex, absoluteFieldIndex, fieldType);
    }

    private RowData buildKeyRowFromJoinedRow(List<KeyExtractor> keyExtractors, RowData joinedRowData) {
        if (keyExtractors.isEmpty()) {
            return null;
        }
        GenericRowData keyRow = new GenericRowData(keyExtractors.size());
        for (int i = 0; i < keyExtractors.size(); ++i) {
            keyRow.setField(i, keyExtractors.get(i).getLeftSideKey(joinedRowData));
        }
        return keyRow;
    }

    private GenericRowData buildKeyRowFromSourceRow(RowData sourceRow, List<KeyExtractor> keyExtractors) {
        if (keyExtractors.isEmpty()) {
            return null;
        }
        GenericRowData keyRow = new GenericRowData(keyExtractors.size());
        for (int i = 0; i < keyExtractors.size(); ++i) {
            keyRow.setField(i, keyExtractors.get(i).getRightSideKey(sourceRow));
        }
        return keyRow;
    }

    private RowType buildJoinKeyType(int inputId, List<KeyExtractor> keyExtractors) {
        RowType originalRowType = this.inputTypes.get(inputId);
        LogicalType[] keyTypes = new LogicalType[keyExtractors.size()];
        String[] keyNames = new String[keyExtractors.size()];
        for (int i = 0; i < keyExtractors.size(); ++i) {
            KeyExtractor extractor = keyExtractors.get(i);
            int fieldIndex = extractor.getFieldIndexInSourceRow();
            this.validateFieldIndex(inputId, fieldIndex, originalRowType);
            keyTypes[i] = extractor.fieldType;
            keyNames[i] = (String)originalRowType.getFieldNames().get(fieldIndex) + "_key";
        }
        return RowType.of((LogicalType[])keyTypes, (String[])keyNames);
    }

    private void initializeCommonJoinKeyStructures() {
        this.commonJoinKeyType = null;
        if (this.inputTypes != null) {
            for (int i = 0; i < this.inputTypes.size(); ++i) {
                this.commonJoinKeyExtractors.put(i, Collections.emptyList());
            }
        }
        assert (this.inputTypes != null);
        if (this.inputTypes.isEmpty() || this.joinAttributeMap.isEmpty()) {
            return;
        }
        HashMap<AttributeRef, AttributeRef> attributeToRoot = new HashMap<AttributeRef, AttributeRef>();
        HashMap<AttributeRef, Integer> rootRank = new HashMap<AttributeRef, Integer>();
        Set<AttributeRef> allAttrRefs = this.collectAllAttributeRefs();
        if (allAttrRefs.isEmpty()) {
            return;
        }
        this.initializeDisjointSets(attributeToRoot, rootRank, allAttrRefs);
        this.findAttributeRoots(attributeToRoot, rootRank);
        Map<AttributeRef, Set<AttributeRef>> equivalenceSets = this.buildEquivalenceSets(attributeToRoot, allAttrRefs);
        List<Set<AttributeRef>> commonConceptualAttributeSets = this.findCommonConceptualAttributeSets(equivalenceSets);
        this.processCommonAttributes(commonConceptualAttributeSets, attributeToRoot);
    }

    private Set<AttributeRef> collectAllAttributeRefs() {
        HashSet<AttributeRef> allAttrRefs = new HashSet<AttributeRef>();
        for (Map.Entry<Integer, List<ConditionAttributeRef>> entry : this.joinAttributeMap.entrySet()) {
            if (entry.getKey() == 0) continue;
            for (ConditionAttributeRef attrRef : entry.getValue()) {
                allAttrRefs.add(new AttributeRef(attrRef.leftInputId, attrRef.leftFieldIndex));
                allAttrRefs.add(new AttributeRef(attrRef.rightInputId, attrRef.rightFieldIndex));
            }
        }
        return allAttrRefs;
    }

    private void initializeDisjointSets(Map<AttributeRef, AttributeRef> attributeToRoot, Map<AttributeRef, Integer> rootRank, Set<AttributeRef> allAttrRefs) {
        for (AttributeRef attrRef : allAttrRefs) {
            attributeToRoot.put(attrRef, attrRef);
            rootRank.put(attrRef, 0);
        }
    }

    private void findAttributeRoots(Map<AttributeRef, AttributeRef> attributeToRoot, Map<AttributeRef, Integer> rootRank) {
        for (Map.Entry<Integer, List<ConditionAttributeRef>> entry : this.joinAttributeMap.entrySet()) {
            if (entry.getKey() == 0) continue;
            for (ConditionAttributeRef condition : entry.getValue()) {
                AttributeBasedJoinKeyExtractor.unionAttributeSets(attributeToRoot, rootRank, new AttributeRef(condition.leftInputId, condition.leftFieldIndex), new AttributeRef(condition.rightInputId, condition.rightFieldIndex));
            }
        }
    }

    private Map<AttributeRef, Set<AttributeRef>> buildEquivalenceSets(Map<AttributeRef, AttributeRef> attributeToRoot, Set<AttributeRef> allAttrRefs) {
        HashMap<AttributeRef, Set<AttributeRef>> equivalenceSets = new HashMap<AttributeRef, Set<AttributeRef>>();
        for (AttributeRef attrRef : allAttrRefs) {
            AttributeRef root = AttributeBasedJoinKeyExtractor.findAttributeSet(attributeToRoot, attrRef);
            equivalenceSets.computeIfAbsent(root, k -> new HashSet()).add(attrRef);
        }
        return equivalenceSets;
    }

    private List<Set<AttributeRef>> findCommonConceptualAttributeSets(Map<AttributeRef, Set<AttributeRef>> equivalenceSets) {
        ArrayList<Set<AttributeRef>> commonConceptualAttributeSets = new ArrayList<Set<AttributeRef>>();
        for (Set<AttributeRef> eqSet : equivalenceSets.values()) {
            if (!this.isCommonConceptualAttributeSet(eqSet)) continue;
            commonConceptualAttributeSets.add(eqSet);
        }
        return commonConceptualAttributeSets;
    }

    private boolean isCommonConceptualAttributeSet(Set<AttributeRef> eqSet) {
        if (this.joinAttributeMap.isEmpty()) {
            return false;
        }
        for (List<ConditionAttributeRef> conditionsForStep : this.joinAttributeMap.values()) {
            if (conditionsForStep.isEmpty()) {
                return false;
            }
            boolean foundInThisStep = false;
            for (ConditionAttributeRef condition : conditionsForStep) {
                if (!eqSet.contains(new AttributeRef(condition.leftInputId, condition.leftFieldIndex)) && !eqSet.contains(new AttributeRef(condition.rightInputId, condition.rightFieldIndex))) continue;
                foundInThisStep = true;
                break;
            }
            if (foundInThisStep) continue;
            return false;
        }
        return true;
    }

    private void processCommonAttributes(List<Set<AttributeRef>> commonConceptualAttributeSets, Map<AttributeRef, AttributeRef> attributeToRoot) {
        for (int currentInputId = 0; currentInputId < this.inputTypes.size(); ++currentInputId) {
            List<AttributeRef> commonAttrsForThisInput = this.findCommonAttributesForInput(currentInputId, commonConceptualAttributeSets, attributeToRoot);
            if (commonAttrsForThisInput.isEmpty()) {
                throw new IllegalStateException("All inputs in a multi-way join must share a common join key. Input #" + currentInputId + " does not share a join key with the other inputs. Please ensure all join conditions connect all inputs with a common key. Support for multiple independent join key groups is tracked under FLINK-37890.");
            }
            this.processInputCommonAttributes(currentInputId, commonAttrsForThisInput);
        }
    }

    private List<AttributeRef> findCommonAttributesForInput(int currentInputId, List<Set<AttributeRef>> commonConceptualAttributeSets, Map<AttributeRef, AttributeRef> attributeToRoot) {
        ArrayList<AttributeRef> commonAttrsForThisInput = new ArrayList<AttributeRef>();
        block0: for (Set<AttributeRef> eqSet : commonConceptualAttributeSets) {
            for (AttributeRef attrRef : eqSet) {
                if (attrRef.inputId != currentInputId) continue;
                commonAttrsForThisInput.add(attrRef);
                continue block0;
            }
        }
        commonAttrsForThisInput.sort(Comparator.comparingInt(a -> {
            AttributeRef root = (AttributeRef)attributeToRoot.get(a);
            return root != null ? root.fieldIndex : -1;
        }).thenComparingInt(a -> a.fieldIndex));
        return commonAttrsForThisInput;
    }

    private void processInputCommonAttributes(int currentInputId, List<AttributeRef> commonAttrsForThisInput) {
        ArrayList<KeyExtractor> extractors = new ArrayList<KeyExtractor>();
        String[] keyFieldNames = new String[commonAttrsForThisInput.size()];
        RowType originalRowType = this.inputTypes.get(currentInputId);
        for (int i = 0; i < commonAttrsForThisInput.size(); ++i) {
            AttributeRef attr = commonAttrsForThisInput.get(i);
            extractors.add(this.createKeyExtractor(attr));
            keyFieldNames[i] = (String)originalRowType.getFieldNames().get(attr.fieldIndex) + "_common";
        }
        this.commonJoinKeyExtractors.put(currentInputId, extractors);
        LogicalType[] keyFieldTypes = (LogicalType[])extractors.stream().map(e -> e.fieldType).toArray(LogicalType[]::new);
        if (currentInputId == 0 && !extractors.isEmpty()) {
            this.commonJoinKeyType = RowType.of((LogicalType[])keyFieldTypes, (String[])keyFieldNames);
        }
    }

    private void validateFieldIndex(int inputId, int fieldIndex, RowType rowType) {
        if (fieldIndex >= rowType.getFieldCount() || fieldIndex < 0) {
            throw new IndexOutOfBoundsException("joinAttributeMap references field index " + fieldIndex + " which is out of bounds for inputId " + inputId + " with type " + rowType);
        }
    }

    private static AttributeRef findAttributeSet(Map<AttributeRef, AttributeRef> attributeToRoot, AttributeRef item) {
        if (!attributeToRoot.get(item).equals(item)) {
            attributeToRoot.put(item, AttributeBasedJoinKeyExtractor.findAttributeSet(attributeToRoot, attributeToRoot.get(item)));
        }
        return attributeToRoot.get(item);
    }

    private static void unionAttributeSets(Map<AttributeRef, AttributeRef> attributeToRoot, Map<AttributeRef, Integer> rootRank, AttributeRef a, AttributeRef b) {
        AttributeRef rootB;
        AttributeRef rootA = AttributeBasedJoinKeyExtractor.findAttributeSet(attributeToRoot, a);
        if (!rootA.equals(rootB = AttributeBasedJoinKeyExtractor.findAttributeSet(attributeToRoot, b))) {
            if (rootRank.get(rootA) < rootRank.get(rootB)) {
                attributeToRoot.put(rootA, rootB);
            } else if (rootRank.get(rootA) > rootRank.get(rootB)) {
                attributeToRoot.put(rootB, rootA);
            } else {
                attributeToRoot.put(rootB, rootA);
                rootRank.put(rootA, rootRank.get(rootA) + 1);
            }
        }
    }

    public void validateKeyStructures() {
        int numInputs = this.inputTypes == null ? 0 : this.inputTypes.size();
        for (int inputId = 0; inputId < numInputs; ++inputId) {
            if (inputId == 0) {
                if (this.leftKeyExtractorsMap.get(inputId).isEmpty()) continue;
                throw new IllegalStateException("Input 0 should not have left key extractors, but found left extractors " + this.leftKeyExtractorsMap.get(inputId) + ".");
            }
            List<KeyExtractor> leftExtractors = this.leftKeyExtractorsMap.get(inputId);
            List<KeyExtractor> rightExtractors = this.rightKeyExtractorsMap.get(inputId);
            int extractorsLength = AttributeBasedJoinKeyExtractor.validateExtractorsLength(leftExtractors, rightExtractors, inputId);
            for (int j = 0; j < extractorsLength; ++j) {
                KeyExtractor rightExtractor = rightExtractors.get(j);
                KeyExtractor leftExtractor = leftExtractors.get(j);
                if (leftExtractor == null || rightExtractor == null) {
                    throw new IllegalStateException("Null extractor found when validating key structures for field " + j + " on input " + inputId + ": left extractor " + leftExtractor + ", right extractor " + rightExtractor + ".");
                }
                LogicalType leftType = leftExtractor.fieldType;
                LogicalType rightType = rightExtractor.fieldType;
                if (Objects.equals(leftType.getTypeRoot(), rightType.getTypeRoot())) continue;
                throw new IllegalStateException("Type mismatch for join key field " + j + " on input " + inputId + ": left type " + leftType.getTypeRoot() + " vs right type " + rightType.getTypeRoot() + ".");
            }
        }
        if (this.commonJoinKeyType != null) {
            int expectedCommonFields = this.commonJoinKeyType.getFieldCount();
            for (int inputId = 0; inputId < numInputs; ++inputId) {
                int actual;
                List<KeyExtractor> commonExtractors = this.commonJoinKeyExtractors.get(inputId);
                int n = actual = commonExtractors == null ? 0 : commonExtractors.size();
                if (actual != expectedCommonFields) {
                    throw new IllegalStateException("Mismatch in common key counts for input " + inputId + ": extractors (" + actual + ") vs commonJoinKeyType fields (" + expectedCommonFields + ").");
                }
                for (int i = 0; i < expectedCommonFields; ++i) {
                    LogicalType extractorType = commonExtractors.get((int)i).fieldType;
                    LogicalType expectedType = this.commonJoinKeyType.getTypeAt(i);
                    if (Objects.equals(extractorType.getTypeRoot(), expectedType.getTypeRoot())) continue;
                    throw new IllegalStateException("Type mismatch for common key field " + i + " on input " + inputId + ": extractor type " + extractorType.getTypeRoot() + " vs commonJoinKeyType " + expectedType.getTypeRoot() + ".");
                }
            }
        }
    }

    private static int validateExtractorsLength(List<KeyExtractor> leftExtractors, List<KeyExtractor> rightExtractors, int inputId) {
        int rightSize;
        int leftSize = leftExtractors == null ? 0 : leftExtractors.size();
        int n = rightSize = rightExtractors == null ? 0 : rightExtractors.size();
        if (leftSize != rightSize) {
            throw new IllegalStateException("Mismatch in key counts for input " + inputId + ": left extractors (" + leftSize + ") vs right extractors (" + rightSize + ").");
        }
        return leftSize;
    }

    public static final class ConditionAttributeRef
    implements Serializable {
        public int leftInputId;
        public int leftFieldIndex;
        public int rightInputId;
        public int rightFieldIndex;

        public ConditionAttributeRef() {
        }

        public ConditionAttributeRef(int leftInputId, int leftFieldIndex, int rightInputId, int rightFieldIndex) {
            this.leftInputId = leftInputId;
            this.leftFieldIndex = leftFieldIndex;
            this.rightInputId = rightInputId;
            this.rightFieldIndex = rightFieldIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionAttributeRef that = (ConditionAttributeRef)o;
            return this.leftInputId == that.leftInputId && this.leftFieldIndex == that.leftFieldIndex && this.rightInputId == that.rightInputId && this.rightFieldIndex == that.rightFieldIndex;
        }

        public int hashCode() {
            return Objects.hash(this.leftInputId, this.leftFieldIndex, this.rightInputId, this.rightFieldIndex);
        }

        public String toString() {
            return "LeftInputId:" + this.leftInputId + ";LeftFieldIndex:" + this.leftFieldIndex + ";RightInputId:" + this.rightInputId + ";RightFieldIndex:" + this.rightFieldIndex + ";";
        }
    }

    public static final class AttributeRef
    implements Serializable {
        public int inputId;
        public int fieldIndex;

        public AttributeRef() {
        }

        public AttributeRef(int inputId, int fieldIndex) {
            this.inputId = inputId;
            this.fieldIndex = fieldIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeRef that = (AttributeRef)o;
            return this.inputId == that.inputId && this.fieldIndex == that.fieldIndex;
        }

        public int hashCode() {
            return Objects.hash(this.inputId, this.fieldIndex);
        }

        public String toString() {
            return "InputId:" + this.inputId + ";FieldIndex:" + this.fieldIndex + ";";
        }
    }

    private static final class KeyExtractor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int inputIdToAccess;
        private final int fieldIndexInSourceRow;
        private final int absoluteFieldIndex;
        private final LogicalType fieldType;
        private transient RowData.FieldGetter leftFieldGetter;
        private transient RowData.FieldGetter rightFieldGetter;

        public KeyExtractor(int inputIdToAccess, int fieldIndexInSourceRow, int absoluteFieldIndex, LogicalType fieldType) {
            this.inputIdToAccess = inputIdToAccess;
            this.fieldIndexInSourceRow = fieldIndexInSourceRow;
            this.absoluteFieldIndex = absoluteFieldIndex;
            this.fieldType = fieldType;
            this.rightFieldGetter = RowData.createFieldGetter((LogicalType)this.fieldType, (int)this.fieldIndexInSourceRow);
            this.leftFieldGetter = RowData.createFieldGetter((LogicalType)this.fieldType, (int)this.absoluteFieldIndex);
        }

        public Object getRightSideKey(RowData row) {
            if (row == null) {
                return null;
            }
            if (this.rightFieldGetter == null) {
                this.rightFieldGetter = RowData.createFieldGetter((LogicalType)this.fieldType, (int)this.fieldIndexInSourceRow);
            }
            return this.rightFieldGetter.getFieldOrNull(row);
        }

        public Object getLeftSideKey(RowData joinedRowData) {
            if (joinedRowData == null) {
                return null;
            }
            if (this.leftFieldGetter == null) {
                this.leftFieldGetter = RowData.createFieldGetter((LogicalType)this.fieldType, (int)this.absoluteFieldIndex);
            }
            return this.leftFieldGetter.getFieldOrNull(joinedRowData);
        }

        public int getInputIdToAccess() {
            return this.inputIdToAccess;
        }

        public int getFieldIndexInSourceRow() {
            return this.fieldIndexInSourceRow;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.fieldType != null) {
                this.rightFieldGetter = RowData.createFieldGetter((LogicalType)this.fieldType, (int)this.fieldIndexInSourceRow);
                this.leftFieldGetter = RowData.createFieldGetter((LogicalType)this.fieldType, (int)this.absoluteFieldIndex);
            }
        }
    }
}

