/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.calc.async;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedFunction;

public class AsyncFunctionRunner
extends RichAsyncFunction<RowData, RowData> {
    private static final long serialVersionUID = -7198305381139008806L;
    private final GeneratedFunction<AsyncFunction<RowData, RowData>> generatedFetcher;
    private transient AsyncFunction<RowData, RowData> fetcher;

    public AsyncFunctionRunner(GeneratedFunction<AsyncFunction<RowData, RowData>> generatedFetcher) {
        this.generatedFetcher = generatedFetcher;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.fetcher = (AsyncFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (OpenContext)openContext);
    }

    public void asyncInvoke(RowData input, ResultFuture<RowData> resultFuture) {
        try {
            this.fetcher.asyncInvoke((Object)input, resultFuture);
        }
        catch (Throwable t) {
            resultFuture.completeExceptionally(t);
        }
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.fetcher);
    }
}

