/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.function.Supplier;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.WindowAggProcessorBase;
import org.apache.flink.table.runtime.operators.window.tvf.common.SyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowValueState;
import org.apache.flink.util.Preconditions;

public abstract class AbstractSyncStateWindowAggProcessor<W>
extends WindowAggProcessorBase<W, SyncStateWindowProcessor.SyncStateContext<W>>
implements SyncStateWindowProcessor<W> {
    private static final long serialVersionUID = 1L;
    protected final WindowIsEmptySupplier emptySupplier;
    protected transient WindowValueState<W> windowState;

    public AbstractSyncStateWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<W> genAggsHandler, WindowAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, boolean isEventTime, int indexOfCountStar, ZoneId shiftTimeZone) {
        super(genAggsHandler, accSerializer, isEventTime, shiftTimeZone);
        this.emptySupplier = new WindowIsEmptySupplier(indexOfCountStar, sliceAssigner);
    }

    @Override
    public void open(SyncStateWindowProcessor.SyncStateContext<W> context) throws Exception {
        super.open(context);
        ValueState state = (ValueState)((SyncStateWindowProcessor.SyncStateContext)this.ctx).getKeyedStateBackend().getOrCreateKeyedState(this.createWindowSerializer(), (StateDescriptor)new ValueStateDescriptor("window-aggs", this.accSerializer));
        this.windowState = new WindowValueState((InternalValueState)state);
    }

    @Override
    protected final void prepareAggregator() throws Exception {
        this.aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(((SyncStateWindowProcessor.SyncStateContext)this.ctx).getRuntimeContext().getUserCodeClassLoader());
        this.aggregator.open(new PerWindowStateDataViewStore(((SyncStateWindowProcessor.SyncStateContext)this.ctx).getKeyedStateBackend(), this.createWindowSerializer(), ((SyncStateWindowProcessor.SyncStateContext)this.ctx).getRuntimeContext()));
    }

    protected void collect(RowData aggResult) {
        this.collect((RowData)((SyncStateWindowProcessor.SyncStateContext)this.ctx).getKeyedStateBackend().getCurrentKey(), aggResult);
    }

    protected final class WindowIsEmptySupplier
    implements Supplier<Boolean>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int indexOfCountStar;

        private WindowIsEmptySupplier(int indexOfCountStar, WindowAssigner assigner) {
            if (assigner instanceof SliceAssigners.HoppingSliceAssigner) {
                Preconditions.checkArgument((indexOfCountStar >= 0 ? 1 : 0) != 0, (Object)"Hopping window requires a COUNT(*) in the aggregate functions.");
            }
            this.indexOfCountStar = indexOfCountStar;
        }

        @Override
        public Boolean get() {
            if (this.indexOfCountStar < 0) {
                return false;
            }
            try {
                RowData acc = AbstractSyncStateWindowAggProcessor.this.aggregator.getAccumulators();
                return acc == null || acc.getLong(this.indexOfCountStar) == 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

