/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class UrlDecodeFunction
extends BuiltInScalarFunction {
    public UrlDecodeFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.URL_DECODE, context);
    }

    @Nullable
    public StringData eval(StringData value) {
        if (value == null) {
            return null;
        }
        Charset charset = StandardCharsets.UTF_8;
        try {
            return StringData.fromString((String)URLDecoder.decode(value.toString(), charset.name()));
        }
        catch (UnsupportedEncodingException | RuntimeException e) {
            return null;
        }
    }
}

