/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class BTrimFunction
extends BuiltInScalarFunction {
    public BTrimFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.BTRIM, context);
    }

    @Nullable
    public StringData eval(@Nullable StringData str) {
        if (str == null) {
            return null;
        }
        return BinaryStringDataUtil.trim((BinaryStringData)str, BinaryStringData.fromString((String)" "));
    }

    @Nullable
    public StringData eval(@Nullable StringData str, @Nullable StringData trimStr) {
        if (str == null || trimStr == null) {
            return null;
        }
        return BinaryStringDataUtil.trim((BinaryStringData)str, (BinaryStringData)trimStr);
    }
}

