/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class ObjectUpdateTypeStrategy
implements TypeStrategy {
    private static DataTypes.Field[] extractFields(CallContext callContext, List<DataType> argumentDataTypes, StructuredType structuredType) {
        List<String> existingFieldNames = LogicalTypeChecks.getFieldNames(structuredType);
        List<LogicalType> existingFieldTypes = LogicalTypeChecks.getFieldTypes(structuredType);
        Map<String, LogicalType> fieldNameToTypeIndex = IntStream.range(0, existingFieldNames.size()).boxed().collect(Collectors.toMap(existingFieldNames::get, existingFieldTypes::get));
        for (int i = 1; i < argumentDataTypes.size(); i += 2) {
            LogicalType valueLogicalType;
            String fieldNameToBeUpdated = callContext.getArgumentValue(i, String.class).orElseThrow(IllegalStateException::new);
            LogicalType valueDataTypeToBeUpdated = argumentDataTypes.get(i + 1).getLogicalType();
            if (valueDataTypeToBeUpdated.equals(valueLogicalType = fieldNameToTypeIndex.get(fieldNameToBeUpdated))) continue;
            fieldNameToTypeIndex.put(fieldNameToBeUpdated, valueDataTypeToBeUpdated);
        }
        return (DataTypes.Field[])fieldNameToTypeIndex.entrySet().stream().map(e -> ObjectUpdateTypeStrategy.toFieldType((String)e.getKey(), (LogicalType)e.getValue())).toArray(DataTypes.Field[]::new);
    }

    private static DataTypes.Field toFieldType(String name, LogicalType logicalType) {
        return DataTypes.FIELD(name, TypeConversions.fromLogicalToDataType(logicalType));
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        StructuredType structuredType = (StructuredType)argumentDataTypes.get(0).getLogicalType();
        DataTypes.Field[] fields = ObjectUpdateTypeStrategy.extractFields(callContext, argumentDataTypes, structuredType);
        String className = structuredType.getClassName().orElseThrow(IllegalStateException::new);
        Optional<Class<?>> resolvedClass = StructuredType.resolveClass(callContext.getDataTypeFactory().getClassLoader(), className);
        return Optional.of(resolvedClass.map(clazz -> DataTypes.STRUCTURED(clazz, fields)).orElse(DataTypes.STRUCTURED(className, fields)));
    }
}

