/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ColumnList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> names;
    private final List<DataType> dataTypes;

    private ColumnList(List<String> names, List<DataType> dataTypes) {
        this.names = (List)Preconditions.checkNotNull(names, (String)"Names must not be null.");
        this.dataTypes = (List)Preconditions.checkNotNull(dataTypes, (String)"Data types must be null.");
        Preconditions.checkArgument((dataTypes.isEmpty() || dataTypes.size() == names.size() ? 1 : 0) != 0, (Object)"Mismatch between data types and names.");
    }

    public static ColumnList of(List<String> names, List<DataType> dataTypes) {
        return new ColumnList(List.copyOf(names), List.copyOf(dataTypes));
    }

    public static ColumnList of(List<String> names) {
        return ColumnList.of(names, List.of());
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<DataType> getDataTypes() {
        return this.dataTypes;
    }

    public String toString() {
        return IntStream.range(0, this.names.size()).mapToObj(pos -> {
            String name = EncodingUtils.escapeIdentifier(this.names.get(pos));
            if (this.dataTypes.isEmpty()) {
                return name;
            }
            String dataType = this.dataTypes.get(pos).getLogicalType().asSummaryString();
            return name + " " + dataType;
        }).collect(Collectors.joining(", ", "(", ")"));
    }
}

