/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.utils.ClassDataTypeConverter;
import org.apache.flink.types.variant.Variant;

@Internal
public final class ValueDataTypeConverter {
    public static Optional<DataType> extractDataType(Object value) {
        if (value == null) {
            return Optional.empty();
        }
        DataType convertedDataType = null;
        if (value instanceof String) {
            convertedDataType = ValueDataTypeConverter.convertToCharType((String)value);
        } else if (value instanceof byte[]) {
            convertedDataType = ValueDataTypeConverter.convertToBinaryType((byte[])value);
        } else if (value instanceof BigDecimal) {
            convertedDataType = ValueDataTypeConverter.convertToDecimalType((BigDecimal)value);
        } else if (value instanceof LocalTime) {
            convertedDataType = ValueDataTypeConverter.convertToTimeType((LocalTime)value);
        } else if (value instanceof LocalDateTime) {
            convertedDataType = ValueDataTypeConverter.convertToTimestampType(((LocalDateTime)value).getNano());
        } else if (value instanceof Timestamp) {
            convertedDataType = ValueDataTypeConverter.convertToTimestampType(((Timestamp)value).getNanos());
        } else if (value instanceof ZonedDateTime) {
            convertedDataType = ValueDataTypeConverter.convertToZonedTimestampType(((ZonedDateTime)value).getNano());
        } else if (value instanceof OffsetDateTime) {
            convertedDataType = ValueDataTypeConverter.convertToZonedTimestampType(((OffsetDateTime)value).getNano());
        } else if (value instanceof Instant) {
            convertedDataType = ValueDataTypeConverter.convertToLocalZonedTimestampType(((Instant)value).getNano());
        } else if (value instanceof Period) {
            convertedDataType = ValueDataTypeConverter.convertToYearMonthIntervalType(((Period)value).getYears());
        } else if (value instanceof Duration) {
            Duration duration = (Duration)value;
            convertedDataType = ValueDataTypeConverter.convertToDayTimeIntervalType(duration.toDays(), duration.getNano());
        } else {
            if (value instanceof Object[]) {
                return ValueDataTypeConverter.convertToArrayType((Object[])value).map(dt -> (DataType)((DataType)dt.notNull()).bridgedTo(value.getClass()));
            }
            if (value instanceof Variant) {
                convertedDataType = DataTypes.VARIANT();
            }
        }
        Optional<DataType> resultType = convertedDataType != null ? Optional.of(convertedDataType) : ClassDataTypeConverter.extractDataType(value.getClass());
        return resultType.map(dt -> (DataType)((DataType)dt.notNull()).bridgedTo(value.getClass()));
    }

    private static DataType convertToCharType(String string) {
        if (string.isEmpty()) {
            return new AtomicDataType(CharType.ofEmptyLiteral());
        }
        return DataTypes.CHAR(string.length());
    }

    private static DataType convertToBinaryType(byte[] bytes) {
        if (bytes.length == 0) {
            return new AtomicDataType(BinaryType.ofEmptyLiteral());
        }
        return DataTypes.BINARY(bytes.length);
    }

    private static DataType convertToDecimalType(BigDecimal decimal) {
        int precision = decimal.precision();
        int scale = decimal.scale();
        if (scale < 0) {
            precision -= scale;
            scale = 0;
        } else if (scale >= precision) {
            precision = scale + 1;
        }
        return DataTypes.DECIMAL(precision, scale);
    }

    private static DataType convertToTimeType(LocalTime time) {
        return DataTypes.TIME(ValueDataTypeConverter.fractionalSecondPrecision(time.getNano()));
    }

    private static DataType convertToTimestampType(int nanos) {
        return DataTypes.TIMESTAMP(ValueDataTypeConverter.fractionalSecondPrecision(nanos));
    }

    private static DataType convertToZonedTimestampType(int nanos) {
        return DataTypes.TIMESTAMP_WITH_TIME_ZONE(ValueDataTypeConverter.fractionalSecondPrecision(nanos));
    }

    private static DataType convertToLocalZonedTimestampType(int nanos) {
        return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(ValueDataTypeConverter.fractionalSecondPrecision(nanos));
    }

    private static DataType convertToYearMonthIntervalType(int years) {
        return DataTypes.INTERVAL(DataTypes.YEAR(ValueDataTypeConverter.yearPrecision(years)), DataTypes.MONTH());
    }

    private static DataType convertToDayTimeIntervalType(long days, int nanos) {
        return DataTypes.INTERVAL(DataTypes.DAY(ValueDataTypeConverter.dayPrecision(days)), DataTypes.SECOND(ValueDataTypeConverter.fractionalSecondPrecision(nanos)));
    }

    private static Optional<DataType> convertToArrayType(Object[] array) {
        if (array.length == 0 || Stream.of(array).allMatch(Objects::isNull)) {
            return ValueDataTypeConverter.extractElementTypeFromClass(array);
        }
        return ValueDataTypeConverter.extractElementTypeFromValues(array);
    }

    private static Optional<DataType> extractElementTypeFromValues(Object[] array) {
        DataType elementType = null;
        for (Object element : array) {
            if (element == null) continue;
            Optional<DataType> possibleElementType = ValueDataTypeConverter.extractDataType(element);
            if (!possibleElementType.isPresent()) {
                return Optional.empty();
            }
            DataType extractedElementType = (DataType)possibleElementType.get().nullable();
            if (elementType != null && !extractedElementType.equals(elementType)) {
                return Optional.empty();
            }
            elementType = extractedElementType;
        }
        return Optional.ofNullable(elementType).map(DataTypes::ARRAY);
    }

    private static Optional<DataType> extractElementTypeFromClass(Object[] array) {
        Optional<DataType> possibleElementType = ClassDataTypeConverter.extractDataType(array.getClass().getComponentType());
        return possibleElementType.map(AbstractDataType::nullable).map(DataTypes::ARRAY);
    }

    private static int fractionalSecondPrecision(int nanos) {
        return String.format("%09d", nanos).replaceAll("0+$", "").length();
    }

    private static int yearPrecision(int years) {
        return String.valueOf(years).length();
    }

    private static int dayPrecision(long days) {
        return String.valueOf(days).length();
    }

    private ValueDataTypeConverter() {
    }
}

