/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.variant.Variant;

@PublicEvolving
public final class GenericArrayData
implements ArrayData {
    private final Object array;
    private final int size;
    private final boolean isPrimitiveArray;

    public GenericArrayData(Object[] array) {
        this(array, array.length, false);
    }

    public GenericArrayData(int[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArrayData(long[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArrayData(float[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArrayData(double[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArrayData(short[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArrayData(byte[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    public GenericArrayData(boolean[] primitiveArray) {
        this(primitiveArray, primitiveArray.length, true);
    }

    private GenericArrayData(Object array, int size, boolean isPrimitiveArray) {
        this.array = array;
        this.size = size;
        this.isPrimitiveArray = isPrimitiveArray;
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public Object[] toObjectArray() {
        if (this.isPrimitiveArray) {
            Class<?> arrayClass = this.array.getClass();
            if (int[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((int[])((int[])this.array));
            }
            if (long[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((long[])((long[])this.array));
            }
            if (float[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((float[])((float[])this.array));
            }
            if (double[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((double[])((double[])this.array));
            }
            if (short[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((short[])((short[])this.array));
            }
            if (byte[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((byte[])((byte[])this.array));
            }
            if (boolean[].class.equals(arrayClass)) {
                return ArrayUtils.toObject((boolean[])((boolean[])this.array));
            }
            throw new RuntimeException("Unsupported primitive array: " + arrayClass);
        }
        return (Object[])this.array;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isNullAt(int pos) {
        return !this.isPrimitiveArray && ((Object[])this.array)[pos] == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericArrayData that = (GenericArrayData)o;
        return this.size == that.size && this.isPrimitiveArray == that.isPrimitiveArray && Objects.deepEquals(this.array, that.array);
    }

    public int hashCode() {
        int result = Objects.hash(this.size, this.isPrimitiveArray);
        result = 31 * result + Arrays.deepHashCode(new Object[]{this.array});
        return result;
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.isPrimitiveArray ? ((boolean[])this.array)[pos] : (Boolean)this.getObject(pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.isPrimitiveArray ? ((byte[])this.array)[pos] : (Byte)this.getObject(pos);
    }

    @Override
    public short getShort(int pos) {
        return this.isPrimitiveArray ? ((short[])this.array)[pos] : (Short)this.getObject(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.isPrimitiveArray ? ((int[])this.array)[pos] : (Integer)this.getObject(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.isPrimitiveArray ? ((long[])this.array)[pos] : (Long)this.getObject(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.isPrimitiveArray ? ((float[])this.array)[pos] : ((Float)this.getObject(pos)).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return this.isPrimitiveArray ? ((double[])this.array)[pos] : (Double)this.getObject(pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.getObject(pos);
    }

    @Override
    public StringData getString(int pos) {
        return (StringData)this.getObject(pos);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return (DecimalData)this.getObject(pos);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return (TimestampData)this.getObject(pos);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return (RawValueData)this.getObject(pos);
    }

    @Override
    public Variant getVariant(int pos) {
        return (Variant)this.getObject(pos);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return (RowData)this.getObject(pos);
    }

    @Override
    public ArrayData getArray(int pos) {
        return (ArrayData)this.getObject(pos);
    }

    @Override
    public MapData getMap(int pos) {
        return (MapData)this.getObject(pos);
    }

    private Object getObject(int pos) {
        return ((Object[])this.array)[pos];
    }

    private boolean anyNull() {
        for (Object element : (Object[])this.array) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    private void checkNoNull() {
        if (this.anyNull()) {
            throw new RuntimeException("Primitive array must not contain a null value.");
        }
    }

    @Override
    public boolean[] toBooleanArray() {
        if (this.isPrimitiveArray) {
            return (boolean[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Boolean[])((Boolean[])this.array));
    }

    @Override
    public byte[] toByteArray() {
        if (this.isPrimitiveArray) {
            return (byte[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Byte[])((Byte[])this.array));
    }

    @Override
    public short[] toShortArray() {
        if (this.isPrimitiveArray) {
            return (short[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Short[])((Short[])this.array));
    }

    @Override
    public int[] toIntArray() {
        if (this.isPrimitiveArray) {
            return (int[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Integer[])((Integer[])this.array));
    }

    @Override
    public long[] toLongArray() {
        if (this.isPrimitiveArray) {
            return (long[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Long[])((Long[])this.array));
    }

    @Override
    public float[] toFloatArray() {
        if (this.isPrimitiveArray) {
            return (float[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Float[])((Float[])this.array));
    }

    @Override
    public double[] toDoubleArray() {
        if (this.isPrimitiveArray) {
            return (double[])this.array;
        }
        this.checkNoNull();
        return ArrayUtils.toPrimitive((Double[])((Double[])this.array));
    }
}

