/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.math.BigDecimal;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.OverWindowRange;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;

class OverTypeStrategyTest
extends InputTypeStrategiesTestBase {
    private static final DataType TIME_ATTRIBUTE_TYPE = TypeConversions.fromLogicalToDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3));
    private static final DataType SYMBOL_TYPE = TypeConversions.fromLogicalToDataType((LogicalType)new SymbolType());

    OverTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Row window literals", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, SYMBOL_TYPE}).calledWithLiteralAt(2, OverWindowRange.UNBOUNDED_ROW).calledWithLiteralAt(3, OverWindowRange.UNBOUNDED_ROW).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, SYMBOL_TYPE}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Range window literals", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, SYMBOL_TYPE}).calledWithLiteralAt(2, OverWindowRange.CURRENT_RANGE).calledWithLiteralAt(3, OverWindowRange.UNBOUNDED_RANGE).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, SYMBOL_TYPE}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Row window literal with row number following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.BIGINT()}).calledWithLiteralAt(2, OverWindowRange.CURRENT_ROW).calledWithLiteralAt(3, 10L).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Row window literal with row number preceding", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.BIGINT(), SYMBOL_TYPE}).calledWithLiteralAt(2, 10L).calledWithLiteralAt(3, OverWindowRange.CURRENT_ROW).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.BIGINT(), SYMBOL_TYPE}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Row window literal with row number preceding and following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.BIGINT(), DataTypes.BIGINT()}).calledWithLiteralAt(2, 10L).calledWithLiteralAt(3, 10L).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.BIGINT(), DataTypes.BIGINT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Range window literal with time following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND())}).calledWithLiteralAt(2, OverWindowRange.CURRENT_RANGE).calledWithLiteralAt(3, BigDecimal.valueOf(10L)).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND())}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Range window literal with time preceding", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND()), SYMBOL_TYPE}).calledWithLiteralAt(2, BigDecimal.valueOf(10L)).calledWithLiteralAt(3, OverWindowRange.CURRENT_RANGE).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND()), SYMBOL_TYPE}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Range window literal with time preceding and following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND()), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND())}).calledWithLiteralAt(2, BigDecimal.valueOf(10L)).calledWithLiteralAt(3, BigDecimal.valueOf(10L)).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND()), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND())}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Different window kind literals", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, SYMBOL_TYPE}).calledWithLiteralAt(2, OverWindowRange.CURRENT_ROW).calledWithLiteralAt(3, OverWindowRange.UNBOUNDED_RANGE).expectErrorMessage("Preceding and following must be of same interval type."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Non literal preceding", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.BIGINT(), SYMBOL_TYPE}).calledWithLiteralAt(3, OverWindowRange.UNBOUNDED_ROW).expectErrorMessage("Preceding must be a row interval or time interval literal."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Non literal following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.BIGINT()}).calledWithLiteralAt(2, OverWindowRange.UNBOUNDED_ROW).expectErrorMessage("Following must be a row interval or time interval literal."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Negative preceding", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.BIGINT(), SYMBOL_TYPE}).calledWithLiteralAt(2, -2L).calledWithLiteralAt(3, OverWindowRange.UNBOUNDED_ROW).expectErrorMessage("Preceding row interval must be larger than 0."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Negative following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.BIGINT()}).calledWithLiteralAt(2, OverWindowRange.UNBOUNDED_ROW).calledWithLiteralAt(3, -2L).expectErrorMessage("Following row interval must be larger than 0."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Negative time preceding", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND()), SYMBOL_TYPE}).calledWithLiteralAt(2, BigDecimal.valueOf(-10L)).calledWithLiteralAt(3, OverWindowRange.UNBOUNDED_RANGE).expectErrorMessage("Preceding time interval must be equal or larger than 0."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Zero time following", SpecificInputTypeStrategies.OVER).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND())}).calledWithLiteralAt(2, OverWindowRange.UNBOUNDED_RANGE).calledWithLiteralAt(3, BigDecimal.valueOf(0L)).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), TIME_ATTRIBUTE_TYPE, SYMBOL_TYPE, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND())}));
    }
}

