/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;

class ObjectUpdateInputTypeStrategyTest
extends InputTypeStrategiesTestBase {
    private static final InputTypeStrategy OBJECT_UPDATE_INPUT_STRATEGY = BuiltInFunctionDefinitions.OBJECT_UPDATE.getTypeInference((DataTypeFactory)new DataTypeFactoryMock()).getInputTypeStrategy();
    private static final String USER_CLASS_PATH = "com.example.User";
    private static final DataType STRUCTURED_TYPE = (DataType)DataTypes.STRUCTURED((String)"com.example.User", (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT())}).notNull();

    ObjectUpdateInputTypeStrategyTest() {
    }

    @Override
    protected Stream<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid OBJECT_UPDATE with a pair of key-value arguments", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull(), DataTypes.INT()}).calledWithLiteralAt(1, "age").calledWithLiteralAt(2, 14).expectSignature("f(object STRUCTURED_TYPE, [STRING, ANY]+...)").expectArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Valid OBJECT_UPDATE with multiple pair of key-value arguments", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING().notNull(), DataTypes.INT()}).calledWithLiteralAt(1, "name").calledWithLiteralAt(2, "Alice").calledWithLiteralAt(3, "age").calledWithLiteralAt(4, 14).expectArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING().notNull(), DataTypes.INT()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_UPDATE with only one argument", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE}).expectErrorMessage("Invalid number of arguments. At least 3 arguments expected but 1 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_UPDATE with only two arguments", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull()}).expectErrorMessage("Invalid number of arguments. At least 3 arguments expected but 2 passed."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_UPDATE with field key as null", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING(), DataTypes.INT()}).calledWithLiteralAt(1, null).expectErrorMessage("The field key at position 2 must be a non-null character string literal."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_UPDATE with field repeated", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull(), DataTypes.INT(), DataTypes.STRING().notNull(), DataTypes.INT()}).calledWithLiteralAt(1, "age").calledWithLiteralAt(2, 42).calledWithLiteralAt(3, "age").calledWithLiteralAt(4, 14).expectErrorMessage("The field name 'age' at position 4 is repeated."), InputTypeStrategiesTestBase.TestSpec.forStrategy("Invalid OBJECT_UPDATE with field invalid field name", OBJECT_UPDATE_INPUT_STRATEGY).calledWithArgumentTypes(new AbstractDataType[]{STRUCTURED_TYPE, DataTypes.STRING().notNull(), DataTypes.INT()}).calledWithLiteralAt(1, "someRandomFieldName").calledWithLiteralAt(2, 42).expectErrorMessage("The field name 'someRandomFieldName' at position 2 is not part of the structured type attributes. Available attributes: [name, age]."));
    }
}

